<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for FulfillmentState EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FulfillmentState
 * @subpackage Enumerations
 */
class FulfillmentState extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotStarted'
     * @return string 'NotStarted'
     */
    const VALUE_NOT_STARTED = 'NotStarted';
    /**
     * Constant for value 'Processing'
     * @return string 'Processing'
     */
    const VALUE_PROCESSING = 'Processing';
    /**
     * Constant for value 'Testing'
     * @return string 'Testing'
     */
    const VALUE_TESTING = 'Testing';
    /**
     * Constant for value 'Aborted'
     * @return string 'Aborted'
     */
    const VALUE_ABORTED = 'Aborted';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'CompletedWithErrors'
     * @return string 'CompletedWithErrors'
     */
    const VALUE_COMPLETED_WITH_ERRORS = 'CompletedWithErrors';
    /**
     * Constant for value 'Verified'
     * @return string 'Verified'
     */
    const VALUE_VERIFIED = 'Verified';
    /**
     * Constant for value 'VerifiedWithErrors'
     * @return string 'VerifiedWithErrors'
     */
    const VALUE_VERIFIED_WITH_ERRORS = 'VerifiedWithErrors';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_STARTED
     * @uses self::VALUE_PROCESSING
     * @uses self::VALUE_TESTING
     * @uses self::VALUE_ABORTED
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_COMPLETED_WITH_ERRORS
     * @uses self::VALUE_VERIFIED
     * @uses self::VALUE_VERIFIED_WITH_ERRORS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_STARTED,
            self::VALUE_PROCESSING,
            self::VALUE_TESTING,
            self::VALUE_ABORTED,
            self::VALUE_COMPLETED,
            self::VALUE_COMPLETED_WITH_ERRORS,
            self::VALUE_VERIFIED,
            self::VALUE_VERIFIED_WITH_ERRORS,
        );
    }
}
