<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DraftInvoiceItemStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DraftInvoiceItemStatus
 * @subpackage Enumerations
 */
class DraftInvoiceItemStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Unpaid'
     * @return string 'Unpaid'
     */
    const VALUE_UNPAID = 'Unpaid';
    /**
     * Constant for value 'Paid'
     * @return string 'Paid'
     */
    const VALUE_PAID = 'Paid';
    /**
     * Constant for value 'PaidPartially'
     * @return string 'PaidPartially'
     */
    const VALUE_PAID_PARTIALLY = 'PaidPartially';
    /**
     * Constant for value 'Obsolete'
     * @return string 'Obsolete'
     */
    const VALUE_OBSOLETE = 'Obsolete';
    /**
     * Return allowed values
     * @uses self::VALUE_UNPAID
     * @uses self::VALUE_PAID
     * @uses self::VALUE_PAID_PARTIALLY
     * @uses self::VALUE_OBSOLETE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNPAID,
            self::VALUE_PAID,
            self::VALUE_PAID_PARTIALLY,
            self::VALUE_OBSOLETE,
        );
    }
}
