<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for CallOverSeatStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CallOverSeatStatus
 * @subpackage Enumerations
 */
class CallOverSeatStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Vacant'
     * @return string 'Vacant'
     */
    const VALUE_VACANT = 'Vacant';
    /**
     * Constant for value 'Sold'
     * @return string 'Sold'
     */
    const VALUE_SOLD = 'Sold';
    /**
     * Constant for value 'Reserved'
     * @return string 'Reserved'
     */
    const VALUE_RESERVED = 'Reserved';
    /**
     * Constant for value 'FreezedAndMine'
     * @return string 'FreezedAndMine'
     */
    const VALUE_FREEZED_AND_MINE = 'FreezedAndMine';
    /**
     * Constant for value 'TemporaryHeldSeatsNotMine'
     * @return string 'TemporaryHeldSeatsNotMine'
     */
    const VALUE_TEMPORARY_HELD_SEATS_NOT_MINE = 'TemporaryHeldSeatsNotMine';
    /**
     * Return allowed values
     * @uses self::VALUE_VACANT
     * @uses self::VALUE_SOLD
     * @uses self::VALUE_RESERVED
     * @uses self::VALUE_FREEZED_AND_MINE
     * @uses self::VALUE_TEMPORARY_HELD_SEATS_NOT_MINE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VACANT,
            self::VALUE_SOLD,
            self::VALUE_RESERVED,
            self::VALUE_FREEZED_AND_MINE,
            self::VALUE_TEMPORARY_HELD_SEATS_NOT_MINE,
        );
    }
}
