<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for BatchPrintStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BatchPrintStatus
 * @subpackage Enumerations
 */
class BatchPrintStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'InProcess'
     * @return string 'InProcess'
     */
    const VALUE_IN_PROCESS = 'InProcess';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'Printing'
     * @return string 'Printing'
     */
    const VALUE_PRINTING = 'Printing';
    /**
     * Return allowed values
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_IN_PROCESS
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_PRINTING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PENDING,
            self::VALUE_IN_PROCESS,
            self::VALUE_COMPLETED,
            self::VALUE_PRINTING,
        );
    }
}
