<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for BatchPrintItemStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BatchPrintItemStatus
 * @subpackage Enumerations
 */
class BatchPrintItemStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'Printed'
     * @return string 'Printed'
     */
    const VALUE_PRINTED = 'Printed';
    /**
     * Constant for value 'Erroneous'
     * @return string 'Erroneous'
     */
    const VALUE_ERRONEOUS = 'Erroneous';
    /**
     * Constant for value 'DataOnly'
     * @return string 'DataOnly'
     */
    const VALUE_DATA_ONLY = 'DataOnly';
    /**
     * Constant for value 'PrintedVirtually'
     * @return string 'PrintedVirtually'
     */
    const VALUE_PRINTED_VIRTUALLY = 'PrintedVirtually';
    /**
     * Return allowed values
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_PRINTED
     * @uses self::VALUE_ERRONEOUS
     * @uses self::VALUE_DATA_ONLY
     * @uses self::VALUE_PRINTED_VIRTUALLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PENDING,
            self::VALUE_PRINTED,
            self::VALUE_ERRONEOUS,
            self::VALUE_DATA_ONLY,
            self::VALUE_PRINTED_VIRTUALLY,
        );
    }
}
