<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfValueDescription ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfValueDescription
 * @subpackage Arrays
 */
class ArrayOfValueDescription extends AbstractStructArrayBase
{
    /**
     * The ValueDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ValueDescription[]
     */
    public $ValueDescription;
    /**
     * Constructor method for ArrayOfValueDescription
     * @uses ArrayOfValueDescription::setValueDescription()
     * @param \patest\StructType\ValueDescription[] $valueDescription
     */
    public function __construct(array $valueDescription = array())
    {
        $this
            ->setValueDescription($valueDescription);
    }
    /**
     * Get ValueDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ValueDescription[]|null
     */
    public function getValueDescription()
    {
        return isset($this->ValueDescription) ? $this->ValueDescription : null;
    }
    /**
     * This method is responsible for validating the values passed to the setValueDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValueDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueDescriptionForArrayConstraintsFromSetValueDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfValueDescriptionValueDescriptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfValueDescriptionValueDescriptionItem instanceof \patest\StructType\ValueDescription) {
                $invalidValues[] = is_object($arrayOfValueDescriptionValueDescriptionItem) ? get_class($arrayOfValueDescriptionValueDescriptionItem) : sprintf('%s(%s)', gettype($arrayOfValueDescriptionValueDescriptionItem), var_export($arrayOfValueDescriptionValueDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ValueDescription property can only contain items of type \patest\StructType\ValueDescription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ValueDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ValueDescription[] $valueDescription
     * @return \patest\ArrayType\ArrayOfValueDescription
     */
    public function setValueDescription(array $valueDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($valueDescriptionArrayErrorMessage = self::validateValueDescriptionForArrayConstraintsFromSetValueDescription($valueDescription))) {
            throw new \InvalidArgumentException($valueDescriptionArrayErrorMessage, __LINE__);
        }
        if (is_null($valueDescription) || (is_array($valueDescription) && empty($valueDescription))) {
            unset($this->ValueDescription);
        } else {
            $this->ValueDescription = $valueDescription;
        }
        return $this;
    }
    /**
     * Add item to ValueDescription value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ValueDescription $item
     * @return \patest\ArrayType\ArrayOfValueDescription
     */
    public function addToValueDescription(\patest\StructType\ValueDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\ValueDescription) {
            throw new \InvalidArgumentException(sprintf('The ValueDescription property can only contain items of type \patest\StructType\ValueDescription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ValueDescription[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\ValueDescription|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\ValueDescription|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\ValueDescription|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\ValueDescription|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\ValueDescription|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ValueDescription
     */
    public function getAttributeName()
    {
        return 'ValueDescription';
    }
}
