<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTicketItemDataFromSaleService ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTicketItemDataFromSaleService
 * @subpackage Arrays
 */
class ArrayOfTicketItemDataFromSaleService extends AbstractStructArrayBase
{
    /**
     * The TicketItemDataFromSaleService
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketItemDataFromSaleService[]
     */
    public $TicketItemDataFromSaleService;
    /**
     * Constructor method for ArrayOfTicketItemDataFromSaleService
     * @uses ArrayOfTicketItemDataFromSaleService::setTicketItemDataFromSaleService()
     * @param \patest\StructType\TicketItemDataFromSaleService[] $ticketItemDataFromSaleService
     */
    public function __construct(array $ticketItemDataFromSaleService = array())
    {
        $this
            ->setTicketItemDataFromSaleService($ticketItemDataFromSaleService);
    }
    /**
     * Get TicketItemDataFromSaleService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketItemDataFromSaleService[]|null
     */
    public function getTicketItemDataFromSaleService()
    {
        return isset($this->TicketItemDataFromSaleService) ? $this->TicketItemDataFromSaleService : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketItemDataFromSaleService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketItemDataFromSaleService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketItemDataFromSaleServiceForArrayConstraintsFromSetTicketItemDataFromSaleService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTicketItemDataFromSaleServiceTicketItemDataFromSaleServiceItem) {
            // validation for constraint: itemType
            if (!$arrayOfTicketItemDataFromSaleServiceTicketItemDataFromSaleServiceItem instanceof \patest\StructType\TicketItemDataFromSaleService) {
                $invalidValues[] = is_object($arrayOfTicketItemDataFromSaleServiceTicketItemDataFromSaleServiceItem) ? get_class($arrayOfTicketItemDataFromSaleServiceTicketItemDataFromSaleServiceItem) : sprintf('%s(%s)', gettype($arrayOfTicketItemDataFromSaleServiceTicketItemDataFromSaleServiceItem), var_export($arrayOfTicketItemDataFromSaleServiceTicketItemDataFromSaleServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketItemDataFromSaleService property can only contain items of type \patest\StructType\TicketItemDataFromSaleService, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketItemDataFromSaleService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\TicketItemDataFromSaleService[] $ticketItemDataFromSaleService
     * @return \patest\ArrayType\ArrayOfTicketItemDataFromSaleService
     */
    public function setTicketItemDataFromSaleService(array $ticketItemDataFromSaleService = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketItemDataFromSaleServiceArrayErrorMessage = self::validateTicketItemDataFromSaleServiceForArrayConstraintsFromSetTicketItemDataFromSaleService($ticketItemDataFromSaleService))) {
            throw new \InvalidArgumentException($ticketItemDataFromSaleServiceArrayErrorMessage, __LINE__);
        }
        if (is_null($ticketItemDataFromSaleService) || (is_array($ticketItemDataFromSaleService) && empty($ticketItemDataFromSaleService))) {
            unset($this->TicketItemDataFromSaleService);
        } else {
            $this->TicketItemDataFromSaleService = $ticketItemDataFromSaleService;
        }
        return $this;
    }
    /**
     * Add item to TicketItemDataFromSaleService value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\TicketItemDataFromSaleService $item
     * @return \patest\ArrayType\ArrayOfTicketItemDataFromSaleService
     */
    public function addToTicketItemDataFromSaleService(\patest\StructType\TicketItemDataFromSaleService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\TicketItemDataFromSaleService) {
            throw new \InvalidArgumentException(sprintf('The TicketItemDataFromSaleService property can only contain items of type \patest\StructType\TicketItemDataFromSaleService, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TicketItemDataFromSaleService[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\TicketItemDataFromSaleService|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\TicketItemDataFromSaleService|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\TicketItemDataFromSaleService|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\TicketItemDataFromSaleService|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\TicketItemDataFromSaleService|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TicketItemDataFromSaleService
     */
    public function getAttributeName()
    {
        return 'TicketItemDataFromSaleService';
    }
}
