<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTicketItem ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTicketItem
 * @subpackage Arrays
 */
class ArrayOfTicketItem extends AbstractStructArrayBase
{
    /**
     * The TicketItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketItem[]
     */
    public $TicketItem;
    /**
     * Constructor method for ArrayOfTicketItem
     * @uses ArrayOfTicketItem::setTicketItem()
     * @param \patest\StructType\TicketItem[] $ticketItem
     */
    public function __construct(array $ticketItem = array())
    {
        $this
            ->setTicketItem($ticketItem);
    }
    /**
     * Get TicketItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketItem[]|null
     */
    public function getTicketItem()
    {
        return isset($this->TicketItem) ? $this->TicketItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketItemForArrayConstraintsFromSetTicketItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTicketItemTicketItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfTicketItemTicketItemItem instanceof \patest\StructType\TicketItem) {
                $invalidValues[] = is_object($arrayOfTicketItemTicketItemItem) ? get_class($arrayOfTicketItemTicketItemItem) : sprintf('%s(%s)', gettype($arrayOfTicketItemTicketItemItem), var_export($arrayOfTicketItemTicketItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketItem property can only contain items of type \patest\StructType\TicketItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\TicketItem[] $ticketItem
     * @return \patest\ArrayType\ArrayOfTicketItem
     */
    public function setTicketItem(array $ticketItem = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketItemArrayErrorMessage = self::validateTicketItemForArrayConstraintsFromSetTicketItem($ticketItem))) {
            throw new \InvalidArgumentException($ticketItemArrayErrorMessage, __LINE__);
        }
        if (is_null($ticketItem) || (is_array($ticketItem) && empty($ticketItem))) {
            unset($this->TicketItem);
        } else {
            $this->TicketItem = $ticketItem;
        }
        return $this;
    }
    /**
     * Add item to TicketItem value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\TicketItem $item
     * @return \patest\ArrayType\ArrayOfTicketItem
     */
    public function addToTicketItem(\patest\StructType\TicketItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\TicketItem) {
            throw new \InvalidArgumentException(sprintf('The TicketItem property can only contain items of type \patest\StructType\TicketItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TicketItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\TicketItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\TicketItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\TicketItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\TicketItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\TicketItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TicketItem
     */
    public function getAttributeName()
    {
        return 'TicketItem';
    }
}
