<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPrintableItemInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPrintableItemInfo
 * @subpackage Arrays
 */
class ArrayOfPrintableItemInfo extends AbstractStructArrayBase
{
    /**
     * The PrintableItemInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PrintableItemInfo[]
     */
    public $PrintableItemInfo;
    /**
     * Constructor method for ArrayOfPrintableItemInfo
     * @uses ArrayOfPrintableItemInfo::setPrintableItemInfo()
     * @param \patest\StructType\PrintableItemInfo[] $printableItemInfo
     */
    public function __construct(array $printableItemInfo = array())
    {
        $this
            ->setPrintableItemInfo($printableItemInfo);
    }
    /**
     * Get PrintableItemInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PrintableItemInfo[]|null
     */
    public function getPrintableItemInfo()
    {
        return isset($this->PrintableItemInfo) ? $this->PrintableItemInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPrintableItemInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrintableItemInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrintableItemInfoForArrayConstraintsFromSetPrintableItemInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPrintableItemInfoPrintableItemInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfPrintableItemInfoPrintableItemInfoItem instanceof \patest\StructType\PrintableItemInfo) {
                $invalidValues[] = is_object($arrayOfPrintableItemInfoPrintableItemInfoItem) ? get_class($arrayOfPrintableItemInfoPrintableItemInfoItem) : sprintf('%s(%s)', gettype($arrayOfPrintableItemInfoPrintableItemInfoItem), var_export($arrayOfPrintableItemInfoPrintableItemInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PrintableItemInfo property can only contain items of type \patest\StructType\PrintableItemInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PrintableItemInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\PrintableItemInfo[] $printableItemInfo
     * @return \patest\ArrayType\ArrayOfPrintableItemInfo
     */
    public function setPrintableItemInfo(array $printableItemInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($printableItemInfoArrayErrorMessage = self::validatePrintableItemInfoForArrayConstraintsFromSetPrintableItemInfo($printableItemInfo))) {
            throw new \InvalidArgumentException($printableItemInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($printableItemInfo) || (is_array($printableItemInfo) && empty($printableItemInfo))) {
            unset($this->PrintableItemInfo);
        } else {
            $this->PrintableItemInfo = $printableItemInfo;
        }
        return $this;
    }
    /**
     * Add item to PrintableItemInfo value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\PrintableItemInfo $item
     * @return \patest\ArrayType\ArrayOfPrintableItemInfo
     */
    public function addToPrintableItemInfo(\patest\StructType\PrintableItemInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\PrintableItemInfo) {
            throw new \InvalidArgumentException(sprintf('The PrintableItemInfo property can only contain items of type \patest\StructType\PrintableItemInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PrintableItemInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\PrintableItemInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\PrintableItemInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\PrintableItemInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\PrintableItemInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\PrintableItemInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PrintableItemInfo
     */
    public function getAttributeName()
    {
        return 'PrintableItemInfo';
    }
}
