<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentMethodDescription ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPaymentMethodDescription
 * @subpackage Arrays
 */
class ArrayOfPaymentMethodDescription extends AbstractStructArrayBase
{
    /**
     * The PaymentMethodDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PaymentMethodDescription[]
     */
    public $PaymentMethodDescription;
    /**
     * Constructor method for ArrayOfPaymentMethodDescription
     * @uses ArrayOfPaymentMethodDescription::setPaymentMethodDescription()
     * @param \patest\StructType\PaymentMethodDescription[] $paymentMethodDescription
     */
    public function __construct(array $paymentMethodDescription = array())
    {
        $this
            ->setPaymentMethodDescription($paymentMethodDescription);
    }
    /**
     * Get PaymentMethodDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PaymentMethodDescription[]|null
     */
    public function getPaymentMethodDescription()
    {
        return isset($this->PaymentMethodDescription) ? $this->PaymentMethodDescription : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentMethodDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMethodDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentMethodDescriptionForArrayConstraintsFromSetPaymentMethodDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPaymentMethodDescriptionPaymentMethodDescriptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentMethodDescriptionPaymentMethodDescriptionItem instanceof \patest\StructType\PaymentMethodDescription) {
                $invalidValues[] = is_object($arrayOfPaymentMethodDescriptionPaymentMethodDescriptionItem) ? get_class($arrayOfPaymentMethodDescriptionPaymentMethodDescriptionItem) : sprintf('%s(%s)', gettype($arrayOfPaymentMethodDescriptionPaymentMethodDescriptionItem), var_export($arrayOfPaymentMethodDescriptionPaymentMethodDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentMethodDescription property can only contain items of type \patest\StructType\PaymentMethodDescription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentMethodDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\PaymentMethodDescription[] $paymentMethodDescription
     * @return \patest\ArrayType\ArrayOfPaymentMethodDescription
     */
    public function setPaymentMethodDescription(array $paymentMethodDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentMethodDescriptionArrayErrorMessage = self::validatePaymentMethodDescriptionForArrayConstraintsFromSetPaymentMethodDescription($paymentMethodDescription))) {
            throw new \InvalidArgumentException($paymentMethodDescriptionArrayErrorMessage, __LINE__);
        }
        if (is_null($paymentMethodDescription) || (is_array($paymentMethodDescription) && empty($paymentMethodDescription))) {
            unset($this->PaymentMethodDescription);
        } else {
            $this->PaymentMethodDescription = $paymentMethodDescription;
        }
        return $this;
    }
    /**
     * Add item to PaymentMethodDescription value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\PaymentMethodDescription $item
     * @return \patest\ArrayType\ArrayOfPaymentMethodDescription
     */
    public function addToPaymentMethodDescription(\patest\StructType\PaymentMethodDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\PaymentMethodDescription) {
            throw new \InvalidArgumentException(sprintf('The PaymentMethodDescription property can only contain items of type \patest\StructType\PaymentMethodDescription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentMethodDescription[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\PaymentMethodDescription|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\PaymentMethodDescription|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\PaymentMethodDescription|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\PaymentMethodDescription|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\PaymentMethodDescription|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentMethodDescription
     */
    public function getAttributeName()
    {
        return 'PaymentMethodDescription';
    }
}
