<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMerchandise.Product ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMerchandise.Product
 * @subpackage Arrays
 */
class ArrayOfMerchandise_Product extends AbstractStructArrayBase
{
    /**
     * The Merchandise_Product
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Merchandise_Product[]
     */
    public $Merchandise_Product;
    /**
     * Constructor method for ArrayOfMerchandise.Product
     * @uses ArrayOfMerchandise_Product::setMerchandise_Product()
     * @param \patest\StructType\Merchandise_Product[] $merchandise_Product
     */
    public function __construct(array $merchandise_Product = array())
    {
        $this
            ->setMerchandise_Product($merchandise_Product);
    }
    /**
     * Get Merchandise_Product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Merchandise_Product[]|null
     */
    public function getMerchandise_Product()
    {
        return isset($this->{'Merchandise.Product'}) ? $this->{'Merchandise.Product'} : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMerchandise_Product method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMerchandise_Product method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMerchandise_ProductForArrayConstraintsFromSetMerchandise_Product(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMerchandise_ProductMerchandise_ProductItem) {
            // validation for constraint: itemType
            if (!$arrayOfMerchandise_ProductMerchandise_ProductItem instanceof \patest\StructType\Merchandise_Product) {
                $invalidValues[] = is_object($arrayOfMerchandise_ProductMerchandise_ProductItem) ? get_class($arrayOfMerchandise_ProductMerchandise_ProductItem) : sprintf('%s(%s)', gettype($arrayOfMerchandise_ProductMerchandise_ProductItem), var_export($arrayOfMerchandise_ProductMerchandise_ProductItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Merchandise_Product property can only contain items of type \patest\StructType\Merchandise_Product, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Merchandise_Product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\Merchandise_Product[] $merchandise_Product
     * @return \patest\ArrayType\ArrayOfMerchandise_Product
     */
    public function setMerchandise_Product(array $merchandise_Product = array())
    {
        // validation for constraint: array
        if ('' !== ($merchandise_ProductArrayErrorMessage = self::validateMerchandise_ProductForArrayConstraintsFromSetMerchandise_Product($merchandise_Product))) {
            throw new \InvalidArgumentException($merchandise_ProductArrayErrorMessage, __LINE__);
        }
        if (is_null($merchandise_Product) || (is_array($merchandise_Product) && empty($merchandise_Product))) {
            unset($this->Merchandise_Product, $this->{'Merchandise.Product'});
        } else {
            $this->Merchandise_Product = $this->{'Merchandise.Product'} = $merchandise_Product;
        }
        return $this;
    }
    /**
     * Add item to Merchandise_Product value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\Merchandise_Product $item
     * @return \patest\ArrayType\ArrayOfMerchandise_Product
     */
    public function addToMerchandise_Product(\patest\StructType\Merchandise_Product $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\Merchandise_Product) {
            throw new \InvalidArgumentException(sprintf('The Merchandise_Product property can only contain items of type \patest\StructType\Merchandise_Product, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Merchandise_Product[] = $this->{'Merchandise.Product'}[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\Merchandise_Product|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\Merchandise_Product|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\Merchandise_Product|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\Merchandise_Product|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\Merchandise_Product|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Merchandise.Product
     */
    public function getAttributeName()
    {
        return 'Merchandise.Product';
    }
}
