<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMerchandiseSaleItem ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMerchandiseSaleItem
 * @subpackage Arrays
 */
class ArrayOfMerchandiseSaleItem extends AbstractStructArrayBase
{
    /**
     * The MerchandiseSaleItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\MerchandiseSaleItem[]
     */
    public $MerchandiseSaleItem;
    /**
     * Constructor method for ArrayOfMerchandiseSaleItem
     * @uses ArrayOfMerchandiseSaleItem::setMerchandiseSaleItem()
     * @param \patest\StructType\MerchandiseSaleItem[] $merchandiseSaleItem
     */
    public function __construct(array $merchandiseSaleItem = array())
    {
        $this
            ->setMerchandiseSaleItem($merchandiseSaleItem);
    }
    /**
     * Get MerchandiseSaleItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\MerchandiseSaleItem[]|null
     */
    public function getMerchandiseSaleItem()
    {
        return isset($this->MerchandiseSaleItem) ? $this->MerchandiseSaleItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMerchandiseSaleItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMerchandiseSaleItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMerchandiseSaleItemForArrayConstraintsFromSetMerchandiseSaleItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMerchandiseSaleItemMerchandiseSaleItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfMerchandiseSaleItemMerchandiseSaleItemItem instanceof \patest\StructType\MerchandiseSaleItem) {
                $invalidValues[] = is_object($arrayOfMerchandiseSaleItemMerchandiseSaleItemItem) ? get_class($arrayOfMerchandiseSaleItemMerchandiseSaleItemItem) : sprintf('%s(%s)', gettype($arrayOfMerchandiseSaleItemMerchandiseSaleItemItem), var_export($arrayOfMerchandiseSaleItemMerchandiseSaleItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MerchandiseSaleItem property can only contain items of type \patest\StructType\MerchandiseSaleItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MerchandiseSaleItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\MerchandiseSaleItem[] $merchandiseSaleItem
     * @return \patest\ArrayType\ArrayOfMerchandiseSaleItem
     */
    public function setMerchandiseSaleItem(array $merchandiseSaleItem = array())
    {
        // validation for constraint: array
        if ('' !== ($merchandiseSaleItemArrayErrorMessage = self::validateMerchandiseSaleItemForArrayConstraintsFromSetMerchandiseSaleItem($merchandiseSaleItem))) {
            throw new \InvalidArgumentException($merchandiseSaleItemArrayErrorMessage, __LINE__);
        }
        if (is_null($merchandiseSaleItem) || (is_array($merchandiseSaleItem) && empty($merchandiseSaleItem))) {
            unset($this->MerchandiseSaleItem);
        } else {
            $this->MerchandiseSaleItem = $merchandiseSaleItem;
        }
        return $this;
    }
    /**
     * Add item to MerchandiseSaleItem value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\MerchandiseSaleItem $item
     * @return \patest\ArrayType\ArrayOfMerchandiseSaleItem
     */
    public function addToMerchandiseSaleItem(\patest\StructType\MerchandiseSaleItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\MerchandiseSaleItem) {
            throw new \InvalidArgumentException(sprintf('The MerchandiseSaleItem property can only contain items of type \patest\StructType\MerchandiseSaleItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MerchandiseSaleItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\MerchandiseSaleItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\MerchandiseSaleItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\MerchandiseSaleItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\MerchandiseSaleItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\MerchandiseSaleItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MerchandiseSaleItem
     */
    public function getAttributeName()
    {
        return 'MerchandiseSaleItem';
    }
}
