<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMerchandiseDescription ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMerchandiseDescription
 * @subpackage Arrays
 */
class ArrayOfMerchandiseDescription extends AbstractStructArrayBase
{
    /**
     * The MerchandiseDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\MerchandiseDescription[]
     */
    public $MerchandiseDescription;
    /**
     * Constructor method for ArrayOfMerchandiseDescription
     * @uses ArrayOfMerchandiseDescription::setMerchandiseDescription()
     * @param \patest\StructType\MerchandiseDescription[] $merchandiseDescription
     */
    public function __construct(array $merchandiseDescription = array())
    {
        $this
            ->setMerchandiseDescription($merchandiseDescription);
    }
    /**
     * Get MerchandiseDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\MerchandiseDescription[]|null
     */
    public function getMerchandiseDescription()
    {
        return isset($this->MerchandiseDescription) ? $this->MerchandiseDescription : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMerchandiseDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMerchandiseDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMerchandiseDescriptionForArrayConstraintsFromSetMerchandiseDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMerchandiseDescriptionMerchandiseDescriptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfMerchandiseDescriptionMerchandiseDescriptionItem instanceof \patest\StructType\MerchandiseDescription) {
                $invalidValues[] = is_object($arrayOfMerchandiseDescriptionMerchandiseDescriptionItem) ? get_class($arrayOfMerchandiseDescriptionMerchandiseDescriptionItem) : sprintf('%s(%s)', gettype($arrayOfMerchandiseDescriptionMerchandiseDescriptionItem), var_export($arrayOfMerchandiseDescriptionMerchandiseDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MerchandiseDescription property can only contain items of type \patest\StructType\MerchandiseDescription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MerchandiseDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\MerchandiseDescription[] $merchandiseDescription
     * @return \patest\ArrayType\ArrayOfMerchandiseDescription
     */
    public function setMerchandiseDescription(array $merchandiseDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($merchandiseDescriptionArrayErrorMessage = self::validateMerchandiseDescriptionForArrayConstraintsFromSetMerchandiseDescription($merchandiseDescription))) {
            throw new \InvalidArgumentException($merchandiseDescriptionArrayErrorMessage, __LINE__);
        }
        if (is_null($merchandiseDescription) || (is_array($merchandiseDescription) && empty($merchandiseDescription))) {
            unset($this->MerchandiseDescription);
        } else {
            $this->MerchandiseDescription = $merchandiseDescription;
        }
        return $this;
    }
    /**
     * Add item to MerchandiseDescription value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\MerchandiseDescription $item
     * @return \patest\ArrayType\ArrayOfMerchandiseDescription
     */
    public function addToMerchandiseDescription(\patest\StructType\MerchandiseDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\MerchandiseDescription) {
            throw new \InvalidArgumentException(sprintf('The MerchandiseDescription property can only contain items of type \patest\StructType\MerchandiseDescription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MerchandiseDescription[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\MerchandiseDescription|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\MerchandiseDescription|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\MerchandiseDescription|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\MerchandiseDescription|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\MerchandiseDescription|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MerchandiseDescription
     */
    public function getAttributeName()
    {
        return 'MerchandiseDescription';
    }
}
