<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomService ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCustomService
 * @subpackage Arrays
 */
class ArrayOfCustomService extends AbstractStructArrayBase
{
    /**
     * The CustomService
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CustomService[]
     */
    public $CustomService;
    /**
     * Constructor method for ArrayOfCustomService
     * @uses ArrayOfCustomService::setCustomService()
     * @param \patest\StructType\CustomService[] $customService
     */
    public function __construct(array $customService = array())
    {
        $this
            ->setCustomService($customService);
    }
    /**
     * Get CustomService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CustomService[]|null
     */
    public function getCustomService()
    {
        return isset($this->CustomService) ? $this->CustomService : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomServiceForArrayConstraintsFromSetCustomService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomServiceCustomServiceItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomServiceCustomServiceItem instanceof \patest\StructType\CustomService) {
                $invalidValues[] = is_object($arrayOfCustomServiceCustomServiceItem) ? get_class($arrayOfCustomServiceCustomServiceItem) : sprintf('%s(%s)', gettype($arrayOfCustomServiceCustomServiceItem), var_export($arrayOfCustomServiceCustomServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomService property can only contain items of type \patest\StructType\CustomService, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\CustomService[] $customService
     * @return \patest\ArrayType\ArrayOfCustomService
     */
    public function setCustomService(array $customService = array())
    {
        // validation for constraint: array
        if ('' !== ($customServiceArrayErrorMessage = self::validateCustomServiceForArrayConstraintsFromSetCustomService($customService))) {
            throw new \InvalidArgumentException($customServiceArrayErrorMessage, __LINE__);
        }
        if (is_null($customService) || (is_array($customService) && empty($customService))) {
            unset($this->CustomService);
        } else {
            $this->CustomService = $customService;
        }
        return $this;
    }
    /**
     * Add item to CustomService value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\CustomService $item
     * @return \patest\ArrayType\ArrayOfCustomService
     */
    public function addToCustomService(\patest\StructType\CustomService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\CustomService) {
            throw new \InvalidArgumentException(sprintf('The CustomService property can only contain items of type \patest\StructType\CustomService, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomService[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\CustomService|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\CustomService|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\CustomService|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\CustomService|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\CustomService|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomService
     */
    public function getAttributeName()
    {
        return 'CustomService';
    }
}
