<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCodeResolution ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCodeResolution
 * @subpackage Arrays
 */
class ArrayOfCodeResolution extends AbstractStructArrayBase
{
    /**
     * The CodeResolution
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CodeResolution[]
     */
    public $CodeResolution;
    /**
     * Constructor method for ArrayOfCodeResolution
     * @uses ArrayOfCodeResolution::setCodeResolution()
     * @param \patest\StructType\CodeResolution[] $codeResolution
     */
    public function __construct(array $codeResolution = array())
    {
        $this
            ->setCodeResolution($codeResolution);
    }
    /**
     * Get CodeResolution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CodeResolution[]|null
     */
    public function getCodeResolution()
    {
        return isset($this->CodeResolution) ? $this->CodeResolution : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCodeResolution method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCodeResolution method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCodeResolutionForArrayConstraintsFromSetCodeResolution(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCodeResolutionCodeResolutionItem) {
            // validation for constraint: itemType
            if (!$arrayOfCodeResolutionCodeResolutionItem instanceof \patest\StructType\CodeResolution) {
                $invalidValues[] = is_object($arrayOfCodeResolutionCodeResolutionItem) ? get_class($arrayOfCodeResolutionCodeResolutionItem) : sprintf('%s(%s)', gettype($arrayOfCodeResolutionCodeResolutionItem), var_export($arrayOfCodeResolutionCodeResolutionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CodeResolution property can only contain items of type \patest\StructType\CodeResolution, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CodeResolution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\CodeResolution[] $codeResolution
     * @return \patest\ArrayType\ArrayOfCodeResolution
     */
    public function setCodeResolution(array $codeResolution = array())
    {
        // validation for constraint: array
        if ('' !== ($codeResolutionArrayErrorMessage = self::validateCodeResolutionForArrayConstraintsFromSetCodeResolution($codeResolution))) {
            throw new \InvalidArgumentException($codeResolutionArrayErrorMessage, __LINE__);
        }
        if (is_null($codeResolution) || (is_array($codeResolution) && empty($codeResolution))) {
            unset($this->CodeResolution);
        } else {
            $this->CodeResolution = $codeResolution;
        }
        return $this;
    }
    /**
     * Add item to CodeResolution value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\CodeResolution $item
     * @return \patest\ArrayType\ArrayOfCodeResolution
     */
    public function addToCodeResolution(\patest\StructType\CodeResolution $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\CodeResolution) {
            throw new \InvalidArgumentException(sprintf('The CodeResolution property can only contain items of type \patest\StructType\CodeResolution, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CodeResolution[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\CodeResolution|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\CodeResolution|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\CodeResolution|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\CodeResolution|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\CodeResolution|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CodeResolution
     */
    public function getAttributeName()
    {
        return 'CodeResolution';
    }
}
