<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClientTicket ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfClientTicket
 * @subpackage Arrays
 */
class ArrayOfClientTicket extends AbstractStructArrayBase
{
    /**
     * The ClientTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTicket[]
     */
    public $ClientTicket;
    /**
     * Constructor method for ArrayOfClientTicket
     * @uses ArrayOfClientTicket::setClientTicket()
     * @param \patest\StructType\ClientTicket[] $clientTicket
     */
    public function __construct(array $clientTicket = array())
    {
        $this
            ->setClientTicket($clientTicket);
    }
    /**
     * Get ClientTicket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTicket[]|null
     */
    public function getClientTicket()
    {
        return isset($this->ClientTicket) ? $this->ClientTicket : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClientTicket method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClientTicket method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClientTicketForArrayConstraintsFromSetClientTicket(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfClientTicketClientTicketItem) {
            // validation for constraint: itemType
            if (!$arrayOfClientTicketClientTicketItem instanceof \patest\StructType\ClientTicket) {
                $invalidValues[] = is_object($arrayOfClientTicketClientTicketItem) ? get_class($arrayOfClientTicketClientTicketItem) : sprintf('%s(%s)', gettype($arrayOfClientTicketClientTicketItem), var_export($arrayOfClientTicketClientTicketItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ClientTicket property can only contain items of type \patest\StructType\ClientTicket, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClientTicket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ClientTicket[] $clientTicket
     * @return \patest\ArrayType\ArrayOfClientTicket
     */
    public function setClientTicket(array $clientTicket = array())
    {
        // validation for constraint: array
        if ('' !== ($clientTicketArrayErrorMessage = self::validateClientTicketForArrayConstraintsFromSetClientTicket($clientTicket))) {
            throw new \InvalidArgumentException($clientTicketArrayErrorMessage, __LINE__);
        }
        if (is_null($clientTicket) || (is_array($clientTicket) && empty($clientTicket))) {
            unset($this->ClientTicket);
        } else {
            $this->ClientTicket = $clientTicket;
        }
        return $this;
    }
    /**
     * Add item to ClientTicket value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ClientTicket $item
     * @return \patest\ArrayType\ArrayOfClientTicket
     */
    public function addToClientTicket(\patest\StructType\ClientTicket $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\ClientTicket) {
            throw new \InvalidArgumentException(sprintf('The ClientTicket property can only contain items of type \patest\StructType\ClientTicket, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ClientTicket[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\ClientTicket|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\ClientTicket|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\ClientTicket|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\ClientTicket|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\ClientTicket|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ClientTicket
     */
    public function getAttributeName()
    {
        return 'ClientTicket';
    }
}
