<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClientEventInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfClientEventInfo
 * @subpackage Arrays
 */
class ArrayOfClientEventInfo extends AbstractStructArrayBase
{
    /**
     * The ClientEventInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientEventInfo[]
     */
    public $ClientEventInfo;
    /**
     * Constructor method for ArrayOfClientEventInfo
     * @uses ArrayOfClientEventInfo::setClientEventInfo()
     * @param \patest\StructType\ClientEventInfo[] $clientEventInfo
     */
    public function __construct(array $clientEventInfo = array())
    {
        $this
            ->setClientEventInfo($clientEventInfo);
    }
    /**
     * Get ClientEventInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientEventInfo[]|null
     */
    public function getClientEventInfo()
    {
        return isset($this->ClientEventInfo) ? $this->ClientEventInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClientEventInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClientEventInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClientEventInfoForArrayConstraintsFromSetClientEventInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfClientEventInfoClientEventInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfClientEventInfoClientEventInfoItem instanceof \patest\StructType\ClientEventInfo) {
                $invalidValues[] = is_object($arrayOfClientEventInfoClientEventInfoItem) ? get_class($arrayOfClientEventInfoClientEventInfoItem) : sprintf('%s(%s)', gettype($arrayOfClientEventInfoClientEventInfoItem), var_export($arrayOfClientEventInfoClientEventInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ClientEventInfo property can only contain items of type \patest\StructType\ClientEventInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClientEventInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ClientEventInfo[] $clientEventInfo
     * @return \patest\ArrayType\ArrayOfClientEventInfo
     */
    public function setClientEventInfo(array $clientEventInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($clientEventInfoArrayErrorMessage = self::validateClientEventInfoForArrayConstraintsFromSetClientEventInfo($clientEventInfo))) {
            throw new \InvalidArgumentException($clientEventInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($clientEventInfo) || (is_array($clientEventInfo) && empty($clientEventInfo))) {
            unset($this->ClientEventInfo);
        } else {
            $this->ClientEventInfo = $clientEventInfo;
        }
        return $this;
    }
    /**
     * Add item to ClientEventInfo value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ClientEventInfo $item
     * @return \patest\ArrayType\ArrayOfClientEventInfo
     */
    public function addToClientEventInfo(\patest\StructType\ClientEventInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\ClientEventInfo) {
            throw new \InvalidArgumentException(sprintf('The ClientEventInfo property can only contain items of type \patest\StructType\ClientEventInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ClientEventInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\ClientEventInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\ClientEventInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\ClientEventInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\ClientEventInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\ClientEventInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ClientEventInfo
     */
    public function getAttributeName()
    {
        return 'ClientEventInfo';
    }
}
