<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClassContent ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfClassContent
 * @subpackage Arrays
 */
class ArrayOfClassContent extends AbstractStructArrayBase
{
    /**
     * The ClassContent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClassContent[]
     */
    public $ClassContent;
    /**
     * Constructor method for ArrayOfClassContent
     * @uses ArrayOfClassContent::setClassContent()
     * @param \patest\StructType\ClassContent[] $classContent
     */
    public function __construct(array $classContent = array())
    {
        $this
            ->setClassContent($classContent);
    }
    /**
     * Get ClassContent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClassContent[]|null
     */
    public function getClassContent()
    {
        return isset($this->ClassContent) ? $this->ClassContent : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClassContent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClassContent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClassContentForArrayConstraintsFromSetClassContent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfClassContentClassContentItem) {
            // validation for constraint: itemType
            if (!$arrayOfClassContentClassContentItem instanceof \patest\StructType\ClassContent) {
                $invalidValues[] = is_object($arrayOfClassContentClassContentItem) ? get_class($arrayOfClassContentClassContentItem) : sprintf('%s(%s)', gettype($arrayOfClassContentClassContentItem), var_export($arrayOfClassContentClassContentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ClassContent property can only contain items of type \patest\StructType\ClassContent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClassContent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ClassContent[] $classContent
     * @return \patest\ArrayType\ArrayOfClassContent
     */
    public function setClassContent(array $classContent = array())
    {
        // validation for constraint: array
        if ('' !== ($classContentArrayErrorMessage = self::validateClassContentForArrayConstraintsFromSetClassContent($classContent))) {
            throw new \InvalidArgumentException($classContentArrayErrorMessage, __LINE__);
        }
        if (is_null($classContent) || (is_array($classContent) && empty($classContent))) {
            unset($this->ClassContent);
        } else {
            $this->ClassContent = $classContent;
        }
        return $this;
    }
    /**
     * Add item to ClassContent value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ClassContent $item
     * @return \patest\ArrayType\ArrayOfClassContent
     */
    public function addToClassContent(\patest\StructType\ClassContent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\ClassContent) {
            throw new \InvalidArgumentException(sprintf('The ClassContent property can only contain items of type \patest\StructType\ClassContent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ClassContent[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\ClassContent|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\ClassContent|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\ClassContent|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\ClassContent|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\ClassContent|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ClassContent
     */
    public function getAttributeName()
    {
        return 'ClassContent';
    }
}
