<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCatchSeatRequest ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCatchSeatRequest
 * @subpackage Arrays
 */
class ArrayOfCatchSeatRequest extends AbstractStructArrayBase
{
    /**
     * The CatchSeatRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CatchSeatRequest[]
     */
    public $CatchSeatRequest;
    /**
     * Constructor method for ArrayOfCatchSeatRequest
     * @uses ArrayOfCatchSeatRequest::setCatchSeatRequest()
     * @param \patest\StructType\CatchSeatRequest[] $catchSeatRequest
     */
    public function __construct(array $catchSeatRequest = array())
    {
        $this
            ->setCatchSeatRequest($catchSeatRequest);
    }
    /**
     * Get CatchSeatRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CatchSeatRequest[]|null
     */
    public function getCatchSeatRequest()
    {
        return isset($this->CatchSeatRequest) ? $this->CatchSeatRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCatchSeatRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatchSeatRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatchSeatRequestForArrayConstraintsFromSetCatchSeatRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCatchSeatRequestCatchSeatRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfCatchSeatRequestCatchSeatRequestItem instanceof \patest\StructType\CatchSeatRequest) {
                $invalidValues[] = is_object($arrayOfCatchSeatRequestCatchSeatRequestItem) ? get_class($arrayOfCatchSeatRequestCatchSeatRequestItem) : sprintf('%s(%s)', gettype($arrayOfCatchSeatRequestCatchSeatRequestItem), var_export($arrayOfCatchSeatRequestCatchSeatRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CatchSeatRequest property can only contain items of type \patest\StructType\CatchSeatRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CatchSeatRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\CatchSeatRequest[] $catchSeatRequest
     * @return \patest\ArrayType\ArrayOfCatchSeatRequest
     */
    public function setCatchSeatRequest(array $catchSeatRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($catchSeatRequestArrayErrorMessage = self::validateCatchSeatRequestForArrayConstraintsFromSetCatchSeatRequest($catchSeatRequest))) {
            throw new \InvalidArgumentException($catchSeatRequestArrayErrorMessage, __LINE__);
        }
        if (is_null($catchSeatRequest) || (is_array($catchSeatRequest) && empty($catchSeatRequest))) {
            unset($this->CatchSeatRequest);
        } else {
            $this->CatchSeatRequest = $catchSeatRequest;
        }
        return $this;
    }
    /**
     * Add item to CatchSeatRequest value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\CatchSeatRequest $item
     * @return \patest\ArrayType\ArrayOfCatchSeatRequest
     */
    public function addToCatchSeatRequest(\patest\StructType\CatchSeatRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\CatchSeatRequest) {
            throw new \InvalidArgumentException(sprintf('The CatchSeatRequest property can only contain items of type \patest\StructType\CatchSeatRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CatchSeatRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\CatchSeatRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\CatchSeatRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\CatchSeatRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\CatchSeatRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\CatchSeatRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CatchSeatRequest
     */
    public function getAttributeName()
    {
        return 'CatchSeatRequest';
    }
}
