<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBasketItemAccessControlData ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfBasketItemAccessControlData
 * @subpackage Arrays
 */
class ArrayOfBasketItemAccessControlData extends AbstractStructArrayBase
{
    /**
     * The BasketItemAccessControlData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BasketItemAccessControlData[]
     */
    public $BasketItemAccessControlData;
    /**
     * Constructor method for ArrayOfBasketItemAccessControlData
     * @uses ArrayOfBasketItemAccessControlData::setBasketItemAccessControlData()
     * @param \patest\StructType\BasketItemAccessControlData[] $basketItemAccessControlData
     */
    public function __construct(array $basketItemAccessControlData = array())
    {
        $this
            ->setBasketItemAccessControlData($basketItemAccessControlData);
    }
    /**
     * Get BasketItemAccessControlData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BasketItemAccessControlData[]|null
     */
    public function getBasketItemAccessControlData()
    {
        return isset($this->BasketItemAccessControlData) ? $this->BasketItemAccessControlData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBasketItemAccessControlData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasketItemAccessControlData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBasketItemAccessControlDataForArrayConstraintsFromSetBasketItemAccessControlData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBasketItemAccessControlDataBasketItemAccessControlDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfBasketItemAccessControlDataBasketItemAccessControlDataItem instanceof \patest\StructType\BasketItemAccessControlData) {
                $invalidValues[] = is_object($arrayOfBasketItemAccessControlDataBasketItemAccessControlDataItem) ? get_class($arrayOfBasketItemAccessControlDataBasketItemAccessControlDataItem) : sprintf('%s(%s)', gettype($arrayOfBasketItemAccessControlDataBasketItemAccessControlDataItem), var_export($arrayOfBasketItemAccessControlDataBasketItemAccessControlDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BasketItemAccessControlData property can only contain items of type \patest\StructType\BasketItemAccessControlData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BasketItemAccessControlData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\BasketItemAccessControlData[] $basketItemAccessControlData
     * @return \patest\ArrayType\ArrayOfBasketItemAccessControlData
     */
    public function setBasketItemAccessControlData(array $basketItemAccessControlData = array())
    {
        // validation for constraint: array
        if ('' !== ($basketItemAccessControlDataArrayErrorMessage = self::validateBasketItemAccessControlDataForArrayConstraintsFromSetBasketItemAccessControlData($basketItemAccessControlData))) {
            throw new \InvalidArgumentException($basketItemAccessControlDataArrayErrorMessage, __LINE__);
        }
        if (is_null($basketItemAccessControlData) || (is_array($basketItemAccessControlData) && empty($basketItemAccessControlData))) {
            unset($this->BasketItemAccessControlData);
        } else {
            $this->BasketItemAccessControlData = $basketItemAccessControlData;
        }
        return $this;
    }
    /**
     * Add item to BasketItemAccessControlData value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\BasketItemAccessControlData $item
     * @return \patest\ArrayType\ArrayOfBasketItemAccessControlData
     */
    public function addToBasketItemAccessControlData(\patest\StructType\BasketItemAccessControlData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\BasketItemAccessControlData) {
            throw new \InvalidArgumentException(sprintf('The BasketItemAccessControlData property can only contain items of type \patest\StructType\BasketItemAccessControlData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BasketItemAccessControlData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\BasketItemAccessControlData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\BasketItemAccessControlData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\BasketItemAccessControlData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\BasketItemAccessControlData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\BasketItemAccessControlData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BasketItemAccessControlData
     */
    public function getAttributeName()
    {
        return 'BasketItemAccessControlData';
    }
}
