<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAssetResource ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAssetResource
 * @subpackage Arrays
 */
class ArrayOfAssetResource extends AbstractStructArrayBase
{
    /**
     * The AssetResource
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AssetResource[]
     */
    public $AssetResource;
    /**
     * Constructor method for ArrayOfAssetResource
     * @uses ArrayOfAssetResource::setAssetResource()
     * @param \patest\StructType\AssetResource[] $assetResource
     */
    public function __construct(array $assetResource = array())
    {
        $this
            ->setAssetResource($assetResource);
    }
    /**
     * Get AssetResource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AssetResource[]|null
     */
    public function getAssetResource()
    {
        return isset($this->AssetResource) ? $this->AssetResource : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAssetResource method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssetResource method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssetResourceForArrayConstraintsFromSetAssetResource(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAssetResourceAssetResourceItem) {
            // validation for constraint: itemType
            if (!$arrayOfAssetResourceAssetResourceItem instanceof \patest\StructType\AssetResource) {
                $invalidValues[] = is_object($arrayOfAssetResourceAssetResourceItem) ? get_class($arrayOfAssetResourceAssetResourceItem) : sprintf('%s(%s)', gettype($arrayOfAssetResourceAssetResourceItem), var_export($arrayOfAssetResourceAssetResourceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AssetResource property can only contain items of type \patest\StructType\AssetResource, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AssetResource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\AssetResource[] $assetResource
     * @return \patest\ArrayType\ArrayOfAssetResource
     */
    public function setAssetResource(array $assetResource = array())
    {
        // validation for constraint: array
        if ('' !== ($assetResourceArrayErrorMessage = self::validateAssetResourceForArrayConstraintsFromSetAssetResource($assetResource))) {
            throw new \InvalidArgumentException($assetResourceArrayErrorMessage, __LINE__);
        }
        if (is_null($assetResource) || (is_array($assetResource) && empty($assetResource))) {
            unset($this->AssetResource);
        } else {
            $this->AssetResource = $assetResource;
        }
        return $this;
    }
    /**
     * Add item to AssetResource value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\AssetResource $item
     * @return \patest\ArrayType\ArrayOfAssetResource
     */
    public function addToAssetResource(\patest\StructType\AssetResource $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\AssetResource) {
            throw new \InvalidArgumentException(sprintf('The AssetResource property can only contain items of type \patest\StructType\AssetResource, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AssetResource[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\AssetResource|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\AssetResource|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\AssetResource|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\AssetResource|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\AssetResource|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AssetResource
     */
    public function getAttributeName()
    {
        return 'AssetResource';
    }
}
