<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAbstractItem ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAbstractItem
 * @subpackage Arrays
 */
class ArrayOfAbstractItem extends AbstractStructArrayBase
{
    /**
     * The AbstractItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AbstractItem[]
     */
    public $AbstractItem;
    /**
     * Constructor method for ArrayOfAbstractItem
     * @uses ArrayOfAbstractItem::setAbstractItem()
     * @param \patest\StructType\AbstractItem[] $abstractItem
     */
    public function __construct(array $abstractItem = array())
    {
        $this
            ->setAbstractItem($abstractItem);
    }
    /**
     * Get AbstractItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AbstractItem[]|null
     */
    public function getAbstractItem()
    {
        return isset($this->AbstractItem) ? $this->AbstractItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAbstractItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbstractItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbstractItemForArrayConstraintsFromSetAbstractItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAbstractItemAbstractItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfAbstractItemAbstractItemItem instanceof \patest\StructType\AbstractItem) {
                $invalidValues[] = is_object($arrayOfAbstractItemAbstractItemItem) ? get_class($arrayOfAbstractItemAbstractItemItem) : sprintf('%s(%s)', gettype($arrayOfAbstractItemAbstractItemItem), var_export($arrayOfAbstractItemAbstractItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AbstractItem property can only contain items of type \patest\StructType\AbstractItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AbstractItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\AbstractItem[] $abstractItem
     * @return \patest\ArrayType\ArrayOfAbstractItem
     */
    public function setAbstractItem(array $abstractItem = array())
    {
        // validation for constraint: array
        if ('' !== ($abstractItemArrayErrorMessage = self::validateAbstractItemForArrayConstraintsFromSetAbstractItem($abstractItem))) {
            throw new \InvalidArgumentException($abstractItemArrayErrorMessage, __LINE__);
        }
        if (is_null($abstractItem) || (is_array($abstractItem) && empty($abstractItem))) {
            unset($this->AbstractItem);
        } else {
            $this->AbstractItem = $abstractItem;
        }
        return $this;
    }
    /**
     * Add item to AbstractItem value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\AbstractItem $item
     * @return \patest\ArrayType\ArrayOfAbstractItem
     */
    public function addToAbstractItem(\patest\StructType\AbstractItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\AbstractItem) {
            throw new \InvalidArgumentException(sprintf('The AbstractItem property can only contain items of type \patest\StructType\AbstractItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AbstractItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\AbstractItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\AbstractItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\AbstractItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\AbstractItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\AbstractItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AbstractItem
     */
    public function getAttributeName()
    {
        return 'AbstractItem';
    }
}
