<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Watermark StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Watermark
 * @subpackage Structs
 */
class Watermark extends AbstractStructBase
{
    /**
     * The MaxRowVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxRowVersion;
    /**
     * The ToDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ToDateTime;
    /**
     * Constructor method for Watermark
     * @uses Watermark::setMaxRowVersion()
     * @uses Watermark::setToDateTime()
     * @param int $maxRowVersion
     * @param string $toDateTime
     */
    public function __construct($maxRowVersion = null, $toDateTime = null)
    {
        $this
            ->setMaxRowVersion($maxRowVersion)
            ->setToDateTime($toDateTime);
    }
    /**
     * Get MaxRowVersion value
     * @return int|null
     */
    public function getMaxRowVersion()
    {
        return $this->MaxRowVersion;
    }
    /**
     * Set MaxRowVersion value
     * @param int $maxRowVersion
     * @return \patest\StructType\Watermark
     */
    public function setMaxRowVersion($maxRowVersion = null)
    {
        // validation for constraint: int
        if (!is_null($maxRowVersion) && !(is_int($maxRowVersion) || ctype_digit($maxRowVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxRowVersion, true), gettype($maxRowVersion)), __LINE__);
        }
        $this->MaxRowVersion = $maxRowVersion;
        return $this;
    }
    /**
     * Get ToDateTime value
     * @return string|null
     */
    public function getToDateTime()
    {
        return $this->ToDateTime;
    }
    /**
     * Set ToDateTime value
     * @param string $toDateTime
     * @return \patest\StructType\Watermark
     */
    public function setToDateTime($toDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($toDateTime) && !is_string($toDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDateTime, true), gettype($toDateTime)), __LINE__);
        }
        $this->ToDateTime = $toDateTime;
        return $this;
    }
}
