<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerifyTicketIsForwardableToOwnerRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VerifyTicketIsForwardableToOwnerRequest
 * @subpackage Structs
 */
class VerifyTicketIsForwardableToOwnerRequest extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The SaleMode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleMode;
    /**
     * The TargetOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetOwnerId;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for VerifyTicketIsForwardableToOwnerRequest
     * @uses VerifyTicketIsForwardableToOwnerRequest::setClientId()
     * @uses VerifyTicketIsForwardableToOwnerRequest::setSaleMode()
     * @uses VerifyTicketIsForwardableToOwnerRequest::setTargetOwnerId()
     * @uses VerifyTicketIsForwardableToOwnerRequest::setTicketId()
     * @param string $clientId
     * @param string $saleMode
     * @param string $targetOwnerId
     * @param string $ticketId
     */
    public function __construct($clientId = null, $saleMode = null, $targetOwnerId = null, $ticketId = null)
    {
        $this
            ->setClientId($clientId)
            ->setSaleMode($saleMode)
            ->setTargetOwnerId($targetOwnerId)
            ->setTicketId($ticketId);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\VerifyTicketIsForwardableToOwnerRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get SaleMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleMode()
    {
        return isset($this->SaleMode) ? $this->SaleMode : null;
    }
    /**
     * Set SaleMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleMode
     * @return \patest\StructType\VerifyTicketIsForwardableToOwnerRequest
     */
    public function setSaleMode($saleMode = null)
    {
        // validation for constraint: string
        if (!is_null($saleMode) && !is_string($saleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleMode, true), gettype($saleMode)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleMode) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleMode, true)), __LINE__);
        }
        if (is_null($saleMode) || (is_array($saleMode) && empty($saleMode))) {
            unset($this->SaleMode);
        } else {
            $this->SaleMode = $saleMode;
        }
        return $this;
    }
    /**
     * Get TargetOwnerId value
     * @return string|null
     */
    public function getTargetOwnerId()
    {
        return $this->TargetOwnerId;
    }
    /**
     * Set TargetOwnerId value
     * @param string $targetOwnerId
     * @return \patest\StructType\VerifyTicketIsForwardableToOwnerRequest
     */
    public function setTargetOwnerId($targetOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($targetOwnerId) && !is_string($targetOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetOwnerId, true), gettype($targetOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetOwnerId, true)), __LINE__);
        }
        $this->TargetOwnerId = $targetOwnerId;
        return $this;
    }
    /**
     * Get TicketId value
     * @return string|null
     */
    public function getTicketId()
    {
        return $this->TicketId;
    }
    /**
     * Set TicketId value
     * @param string $ticketId
     * @return \patest\StructType\VerifyTicketIsForwardableToOwnerRequest
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        $this->TicketId = $ticketId;
        return $this;
    }
}
