<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValueGetterDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValueGetterDescription
 * @subpackage Structs
 */
class ValueGetterDescription extends AbstractStructBase
{
    /**
     * The DisplayInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DisplayInfo
     */
    public $DisplayInfo;
    /**
     * The EntityDescriptionPropertyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityDescriptionPropertyName;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The EntityValuePropertyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityValuePropertyName;
    /**
     * The HasTooManyValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasTooManyValues;
    /**
     * The HasValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasValues;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Id;
    /**
     * The IsValueTypeEnum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsValueTypeEnum;
    /**
     * The OperandType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OperandType;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The ValueTypeFullName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValueTypeFullName;
    /**
     * The Values
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfValueDescription
     */
    public $Values;
    /**
     * Constructor method for ValueGetterDescription
     * @uses ValueGetterDescription::setDisplayInfo()
     * @uses ValueGetterDescription::setEntityDescriptionPropertyName()
     * @uses ValueGetterDescription::setEntityName()
     * @uses ValueGetterDescription::setEntityValuePropertyName()
     * @uses ValueGetterDescription::setHasTooManyValues()
     * @uses ValueGetterDescription::setHasValues()
     * @uses ValueGetterDescription::setId()
     * @uses ValueGetterDescription::setIsValueTypeEnum()
     * @uses ValueGetterDescription::setOperandType()
     * @uses ValueGetterDescription::setTitle()
     * @uses ValueGetterDescription::setValueTypeFullName()
     * @uses ValueGetterDescription::setValues()
     * @param \patest\StructType\DisplayInfo $displayInfo
     * @param string $entityDescriptionPropertyName
     * @param string $entityName
     * @param string $entityValuePropertyName
     * @param bool $hasTooManyValues
     * @param bool $hasValues
     * @param string $id
     * @param bool $isValueTypeEnum
     * @param string $operandType
     * @param string $title
     * @param string $valueTypeFullName
     * @param \patest\ArrayType\ArrayOfValueDescription $values
     */
    public function __construct(\patest\StructType\DisplayInfo $displayInfo = null, $entityDescriptionPropertyName = null, $entityName = null, $entityValuePropertyName = null, $hasTooManyValues = null, $hasValues = null, $id = null, $isValueTypeEnum = null, $operandType = null, $title = null, $valueTypeFullName = null, \patest\ArrayType\ArrayOfValueDescription $values = null)
    {
        $this
            ->setDisplayInfo($displayInfo)
            ->setEntityDescriptionPropertyName($entityDescriptionPropertyName)
            ->setEntityName($entityName)
            ->setEntityValuePropertyName($entityValuePropertyName)
            ->setHasTooManyValues($hasTooManyValues)
            ->setHasValues($hasValues)
            ->setId($id)
            ->setIsValueTypeEnum($isValueTypeEnum)
            ->setOperandType($operandType)
            ->setTitle($title)
            ->setValueTypeFullName($valueTypeFullName)
            ->setValues($values);
    }
    /**
     * Get DisplayInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DisplayInfo|null
     */
    public function getDisplayInfo()
    {
        return isset($this->DisplayInfo) ? $this->DisplayInfo : null;
    }
    /**
     * Set DisplayInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DisplayInfo $displayInfo
     * @return \patest\StructType\ValueGetterDescription
     */
    public function setDisplayInfo(\patest\StructType\DisplayInfo $displayInfo = null)
    {
        if (is_null($displayInfo) || (is_array($displayInfo) && empty($displayInfo))) {
            unset($this->DisplayInfo);
        } else {
            $this->DisplayInfo = $displayInfo;
        }
        return $this;
    }
    /**
     * Get EntityDescriptionPropertyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityDescriptionPropertyName()
    {
        return isset($this->EntityDescriptionPropertyName) ? $this->EntityDescriptionPropertyName : null;
    }
    /**
     * Set EntityDescriptionPropertyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityDescriptionPropertyName
     * @return \patest\StructType\ValueGetterDescription
     */
    public function setEntityDescriptionPropertyName($entityDescriptionPropertyName = null)
    {
        // validation for constraint: string
        if (!is_null($entityDescriptionPropertyName) && !is_string($entityDescriptionPropertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityDescriptionPropertyName, true), gettype($entityDescriptionPropertyName)), __LINE__);
        }
        if (is_null($entityDescriptionPropertyName) || (is_array($entityDescriptionPropertyName) && empty($entityDescriptionPropertyName))) {
            unset($this->EntityDescriptionPropertyName);
        } else {
            $this->EntityDescriptionPropertyName = $entityDescriptionPropertyName;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\ValueGetterDescription
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get EntityValuePropertyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityValuePropertyName()
    {
        return isset($this->EntityValuePropertyName) ? $this->EntityValuePropertyName : null;
    }
    /**
     * Set EntityValuePropertyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityValuePropertyName
     * @return \patest\StructType\ValueGetterDescription
     */
    public function setEntityValuePropertyName($entityValuePropertyName = null)
    {
        // validation for constraint: string
        if (!is_null($entityValuePropertyName) && !is_string($entityValuePropertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityValuePropertyName, true), gettype($entityValuePropertyName)), __LINE__);
        }
        if (is_null($entityValuePropertyName) || (is_array($entityValuePropertyName) && empty($entityValuePropertyName))) {
            unset($this->EntityValuePropertyName);
        } else {
            $this->EntityValuePropertyName = $entityValuePropertyName;
        }
        return $this;
    }
    /**
     * Get HasTooManyValues value
     * @return bool|null
     */
    public function getHasTooManyValues()
    {
        return $this->HasTooManyValues;
    }
    /**
     * Set HasTooManyValues value
     * @param bool $hasTooManyValues
     * @return \patest\StructType\ValueGetterDescription
     */
    public function setHasTooManyValues($hasTooManyValues = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTooManyValues) && !is_bool($hasTooManyValues)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasTooManyValues, true), gettype($hasTooManyValues)), __LINE__);
        }
        $this->HasTooManyValues = $hasTooManyValues;
        return $this;
    }
    /**
     * Get HasValues value
     * @return bool|null
     */
    public function getHasValues()
    {
        return $this->HasValues;
    }
    /**
     * Set HasValues value
     * @param bool $hasValues
     * @return \patest\StructType\ValueGetterDescription
     */
    public function setHasValues($hasValues = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasValues) && !is_bool($hasValues)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasValues, true), gettype($hasValues)), __LINE__);
        }
        $this->HasValues = $hasValues;
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\ValueGetterDescription
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IsValueTypeEnum value
     * @return bool|null
     */
    public function getIsValueTypeEnum()
    {
        return $this->IsValueTypeEnum;
    }
    /**
     * Set IsValueTypeEnum value
     * @param bool $isValueTypeEnum
     * @return \patest\StructType\ValueGetterDescription
     */
    public function setIsValueTypeEnum($isValueTypeEnum = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValueTypeEnum) && !is_bool($isValueTypeEnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValueTypeEnum, true), gettype($isValueTypeEnum)), __LINE__);
        }
        $this->IsValueTypeEnum = $isValueTypeEnum;
        return $this;
    }
    /**
     * Get OperandType value
     * @return string|null
     */
    public function getOperandType()
    {
        return $this->OperandType;
    }
    /**
     * Set OperandType value
     * @uses \patest\EnumType\OperandType::valueIsValid()
     * @uses \patest\EnumType\OperandType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operandType
     * @return \patest\StructType\ValueGetterDescription
     */
    public function setOperandType($operandType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OperandType::valueIsValid($operandType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OperandType', is_array($operandType) ? implode(', ', $operandType) : var_export($operandType, true), implode(', ', \patest\EnumType\OperandType::getValidValues())), __LINE__);
        }
        $this->OperandType = $operandType;
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \patest\StructType\ValueGetterDescription
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get ValueTypeFullName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValueTypeFullName()
    {
        return isset($this->ValueTypeFullName) ? $this->ValueTypeFullName : null;
    }
    /**
     * Set ValueTypeFullName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valueTypeFullName
     * @return \patest\StructType\ValueGetterDescription
     */
    public function setValueTypeFullName($valueTypeFullName = null)
    {
        // validation for constraint: string
        if (!is_null($valueTypeFullName) && !is_string($valueTypeFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueTypeFullName, true), gettype($valueTypeFullName)), __LINE__);
        }
        if (is_null($valueTypeFullName) || (is_array($valueTypeFullName) && empty($valueTypeFullName))) {
            unset($this->ValueTypeFullName);
        } else {
            $this->ValueTypeFullName = $valueTypeFullName;
        }
        return $this;
    }
    /**
     * Get Values value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfValueDescription|null
     */
    public function getValues()
    {
        return isset($this->Values) ? $this->Values : null;
    }
    /**
     * Set Values value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfValueDescription $values
     * @return \patest\StructType\ValueGetterDescription
     */
    public function setValues(\patest\ArrayType\ArrayOfValueDescription $values = null)
    {
        if (is_null($values) || (is_array($values) && empty($values))) {
            unset($this->Values);
        } else {
            $this->Values = $values;
        }
        return $this;
    }
}
