<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateTransaction-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateTransaction-Response
 * @subpackage Structs
 */
class ValidateTransaction_Response extends ExtensibleDataContract
{
    /**
     * The FailureReasons
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTransactionMessageBase
     */
    public $FailureReasons;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsValid;
    /**
     * The TransactionSnapshot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionSnapshot
     */
    public $TransactionSnapshot;
    /**
     * Constructor method for ValidateTransaction-Response
     * @uses ValidateTransaction_Response::setFailureReasons()
     * @uses ValidateTransaction_Response::setIsValid()
     * @uses ValidateTransaction_Response::setTransactionSnapshot()
     * @param \patest\ArrayType\ArrayOfTransactionMessageBase $failureReasons
     * @param bool $isValid
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     */
    public function __construct(\patest\ArrayType\ArrayOfTransactionMessageBase $failureReasons = null, $isValid = null, \patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        $this
            ->setFailureReasons($failureReasons)
            ->setIsValid($isValid)
            ->setTransactionSnapshot($transactionSnapshot);
    }
    /**
     * Get FailureReasons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTransactionMessageBase|null
     */
    public function getFailureReasons()
    {
        return isset($this->FailureReasons) ? $this->FailureReasons : null;
    }
    /**
     * Set FailureReasons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTransactionMessageBase $failureReasons
     * @return \patest\StructType\ValidateTransaction_Response
     */
    public function setFailureReasons(\patest\ArrayType\ArrayOfTransactionMessageBase $failureReasons = null)
    {
        if (is_null($failureReasons) || (is_array($failureReasons) && empty($failureReasons))) {
            unset($this->FailureReasons);
        } else {
            $this->FailureReasons = $failureReasons;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * @return bool|null
     */
    public function getIsValid()
    {
        return $this->IsValid;
    }
    /**
     * Set IsValid value
     * @param bool $isValid
     * @return \patest\StructType\ValidateTransaction_Response
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        $this->IsValid = $isValid;
        return $this;
    }
    /**
     * Get TransactionSnapshot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionSnapshot|null
     */
    public function getTransactionSnapshot()
    {
        return isset($this->TransactionSnapshot) ? $this->TransactionSnapshot : null;
    }
    /**
     * Set TransactionSnapshot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     * @return \patest\StructType\ValidateTransaction_Response
     */
    public function setTransactionSnapshot(\patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        if (is_null($transactionSnapshot) || (is_array($transactionSnapshot) && empty($transactionSnapshot))) {
            unset($this->TransactionSnapshot);
        } else {
            $this->TransactionSnapshot = $transactionSnapshot;
        }
        return $this;
    }
}
