<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserMustChangePasswordSecurityFault StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UserMustChangePasswordSecurityFault
 * @subpackage Structs
 */
class UserMustChangePasswordSecurityFault extends SecurityFault
{
    /**
     * The PasswordValidityParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PasswordValidityParameters
     */
    public $PasswordValidityParameters;
    /**
     * The SalePointNotIdentified
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SalePointNotIdentified;
    /**
     * The SalePoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSalePointInfo
     */
    public $SalePoints;
    /**
     * Constructor method for UserMustChangePasswordSecurityFault
     * @uses UserMustChangePasswordSecurityFault::setPasswordValidityParameters()
     * @uses UserMustChangePasswordSecurityFault::setSalePointNotIdentified()
     * @uses UserMustChangePasswordSecurityFault::setSalePoints()
     * @param \patest\StructType\PasswordValidityParameters $passwordValidityParameters
     * @param bool $salePointNotIdentified
     * @param \patest\ArrayType\ArrayOfSalePointInfo $salePoints
     */
    public function __construct(\patest\StructType\PasswordValidityParameters $passwordValidityParameters = null, $salePointNotIdentified = null, \patest\ArrayType\ArrayOfSalePointInfo $salePoints = null)
    {
        $this
            ->setPasswordValidityParameters($passwordValidityParameters)
            ->setSalePointNotIdentified($salePointNotIdentified)
            ->setSalePoints($salePoints);
    }
    /**
     * Get PasswordValidityParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PasswordValidityParameters|null
     */
    public function getPasswordValidityParameters()
    {
        return isset($this->PasswordValidityParameters) ? $this->PasswordValidityParameters : null;
    }
    /**
     * Set PasswordValidityParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PasswordValidityParameters $passwordValidityParameters
     * @return \patest\StructType\UserMustChangePasswordSecurityFault
     */
    public function setPasswordValidityParameters(\patest\StructType\PasswordValidityParameters $passwordValidityParameters = null)
    {
        if (is_null($passwordValidityParameters) || (is_array($passwordValidityParameters) && empty($passwordValidityParameters))) {
            unset($this->PasswordValidityParameters);
        } else {
            $this->PasswordValidityParameters = $passwordValidityParameters;
        }
        return $this;
    }
    /**
     * Get SalePointNotIdentified value
     * @return bool|null
     */
    public function getSalePointNotIdentified()
    {
        return $this->SalePointNotIdentified;
    }
    /**
     * Set SalePointNotIdentified value
     * @param bool $salePointNotIdentified
     * @return \patest\StructType\UserMustChangePasswordSecurityFault
     */
    public function setSalePointNotIdentified($salePointNotIdentified = null)
    {
        // validation for constraint: boolean
        if (!is_null($salePointNotIdentified) && !is_bool($salePointNotIdentified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($salePointNotIdentified, true), gettype($salePointNotIdentified)), __LINE__);
        }
        $this->SalePointNotIdentified = $salePointNotIdentified;
        return $this;
    }
    /**
     * Get SalePoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSalePointInfo|null
     */
    public function getSalePoints()
    {
        return isset($this->SalePoints) ? $this->SalePoints : null;
    }
    /**
     * Set SalePoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSalePointInfo $salePoints
     * @return \patest\StructType\UserMustChangePasswordSecurityFault
     */
    public function setSalePoints(\patest\ArrayType\ArrayOfSalePointInfo $salePoints = null)
    {
        if (is_null($salePoints) || (is_array($salePoints) && empty($salePoints))) {
            unset($this->SalePoints);
        } else {
            $this->SalePoints = $salePoints;
        }
        return $this;
    }
}
