<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserInteractionRequiredMessage StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UserInteractionRequiredMessage
 * @subpackage Structs
 */
class UserInteractionRequiredMessage extends TransactionMessageBase
{
    /**
     * The InteractionDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\UserInteractionDetails
     */
    public $InteractionDetails;
    /**
     * The TransactionItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionItemId;
    /**
     * Constructor method for UserInteractionRequiredMessage
     * @uses UserInteractionRequiredMessage::setInteractionDetails()
     * @uses UserInteractionRequiredMessage::setTransactionItemId()
     * @param \patest\StructType\UserInteractionDetails $interactionDetails
     * @param int $transactionItemId
     */
    public function __construct(\patest\StructType\UserInteractionDetails $interactionDetails = null, $transactionItemId = null)
    {
        $this
            ->setInteractionDetails($interactionDetails)
            ->setTransactionItemId($transactionItemId);
    }
    /**
     * Get InteractionDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\UserInteractionDetails|null
     */
    public function getInteractionDetails()
    {
        return isset($this->InteractionDetails) ? $this->InteractionDetails : null;
    }
    /**
     * Set InteractionDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\UserInteractionDetails $interactionDetails
     * @return \patest\StructType\UserInteractionRequiredMessage
     */
    public function setInteractionDetails(\patest\StructType\UserInteractionDetails $interactionDetails = null)
    {
        if (is_null($interactionDetails) || (is_array($interactionDetails) && empty($interactionDetails))) {
            unset($this->InteractionDetails);
        } else {
            $this->InteractionDetails = $interactionDetails;
        }
        return $this;
    }
    /**
     * Get TransactionItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionItemId()
    {
        return isset($this->TransactionItemId) ? $this->TransactionItemId : null;
    }
    /**
     * Set TransactionItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionItemId
     * @return \patest\StructType\UserInteractionRequiredMessage
     */
    public function setTransactionItemId($transactionItemId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionItemId) && !(is_int($transactionItemId) || ctype_digit($transactionItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionItemId, true), gettype($transactionItemId)), __LINE__);
        }
        if (is_null($transactionItemId) || (is_array($transactionItemId) && empty($transactionItemId))) {
            unset($this->TransactionItemId);
        } else {
            $this->TransactionItemId = $transactionItemId;
        }
        return $this;
    }
}
