<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserAcknowledgementReaction StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UserAcknowledgementReaction
 * @subpackage Structs
 */
class UserAcknowledgementReaction extends ExtensibleDataContract
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Category;
    /**
     * The IsRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRequired;
    /**
     * The RichText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RichText;
    /**
     * The SeatGeekAcknowledgementId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatGeekAcknowledgementId;
    /**
     * The Slug
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Slug;
    /**
     * The UserReactionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UserReactionValue;
    /**
     * Constructor method for UserAcknowledgementReaction
     * @uses UserAcknowledgementReaction::setAction()
     * @uses UserAcknowledgementReaction::setCategory()
     * @uses UserAcknowledgementReaction::setIsRequired()
     * @uses UserAcknowledgementReaction::setRichText()
     * @uses UserAcknowledgementReaction::setSeatGeekAcknowledgementId()
     * @uses UserAcknowledgementReaction::setSlug()
     * @uses UserAcknowledgementReaction::setUserReactionValue()
     * @param string $action
     * @param string $category
     * @param bool $isRequired
     * @param string $richText
     * @param int $seatGeekAcknowledgementId
     * @param string $slug
     * @param bool $userReactionValue
     */
    public function __construct($action = null, $category = null, $isRequired = null, $richText = null, $seatGeekAcknowledgementId = null, $slug = null, $userReactionValue = null)
    {
        $this
            ->setAction($action)
            ->setCategory($category)
            ->setIsRequired($isRequired)
            ->setRichText($richText)
            ->setSeatGeekAcknowledgementId($seatGeekAcknowledgementId)
            ->setSlug($slug)
            ->setUserReactionValue($userReactionValue);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $action
     * @return \patest\StructType\UserAcknowledgementReaction
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get Category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategory()
    {
        return isset($this->Category) ? $this->Category : null;
    }
    /**
     * Set Category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $category
     * @return \patest\StructType\UserAcknowledgementReaction
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        if (is_null($category) || (is_array($category) && empty($category))) {
            unset($this->Category);
        } else {
            $this->Category = $category;
        }
        return $this;
    }
    /**
     * Get IsRequired value
     * @return bool|null
     */
    public function getIsRequired()
    {
        return $this->IsRequired;
    }
    /**
     * Set IsRequired value
     * @param bool $isRequired
     * @return \patest\StructType\UserAcknowledgementReaction
     */
    public function setIsRequired($isRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRequired) && !is_bool($isRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRequired, true), gettype($isRequired)), __LINE__);
        }
        $this->IsRequired = $isRequired;
        return $this;
    }
    /**
     * Get RichText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRichText()
    {
        return isset($this->RichText) ? $this->RichText : null;
    }
    /**
     * Set RichText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $richText
     * @return \patest\StructType\UserAcknowledgementReaction
     */
    public function setRichText($richText = null)
    {
        // validation for constraint: string
        if (!is_null($richText) && !is_string($richText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($richText, true), gettype($richText)), __LINE__);
        }
        if (is_null($richText) || (is_array($richText) && empty($richText))) {
            unset($this->RichText);
        } else {
            $this->RichText = $richText;
        }
        return $this;
    }
    /**
     * Get SeatGeekAcknowledgementId value
     * @return int|null
     */
    public function getSeatGeekAcknowledgementId()
    {
        return $this->SeatGeekAcknowledgementId;
    }
    /**
     * Set SeatGeekAcknowledgementId value
     * @param int $seatGeekAcknowledgementId
     * @return \patest\StructType\UserAcknowledgementReaction
     */
    public function setSeatGeekAcknowledgementId($seatGeekAcknowledgementId = null)
    {
        // validation for constraint: int
        if (!is_null($seatGeekAcknowledgementId) && !(is_int($seatGeekAcknowledgementId) || ctype_digit($seatGeekAcknowledgementId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatGeekAcknowledgementId, true), gettype($seatGeekAcknowledgementId)), __LINE__);
        }
        $this->SeatGeekAcknowledgementId = $seatGeekAcknowledgementId;
        return $this;
    }
    /**
     * Get Slug value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSlug()
    {
        return isset($this->Slug) ? $this->Slug : null;
    }
    /**
     * Set Slug value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $slug
     * @return \patest\StructType\UserAcknowledgementReaction
     */
    public function setSlug($slug = null)
    {
        // validation for constraint: string
        if (!is_null($slug) && !is_string($slug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($slug, true), gettype($slug)), __LINE__);
        }
        if (is_null($slug) || (is_array($slug) && empty($slug))) {
            unset($this->Slug);
        } else {
            $this->Slug = $slug;
        }
        return $this;
    }
    /**
     * Get UserReactionValue value
     * @return bool|null
     */
    public function getUserReactionValue()
    {
        return $this->UserReactionValue;
    }
    /**
     * Set UserReactionValue value
     * @param bool $userReactionValue
     * @return \patest\StructType\UserAcknowledgementReaction
     */
    public function setUserReactionValue($userReactionValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($userReactionValue) && !is_bool($userReactionValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($userReactionValue, true), gettype($userReactionValue)), __LINE__);
        }
        $this->UserReactionValue = $userReactionValue;
        return $this;
    }
}
