<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTransactionProperties-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateTransactionProperties-Request
 * @subpackage Structs
 */
class UpdateTransactionProperties_Request extends ExtensibleDataContract
{
    /**
     * The AccountContactPersonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountContactPersonId;
    /**
     * The AffectProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $AffectProperties;
    /**
     * The AgencyAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgencyAccountId;
    /**
     * The AgencyContactPersonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgencyContactPersonId;
    /**
     * The ClientDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionClientDetails
     */
    public $ClientDetails;
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExtraFields
     */
    public $ExtraInfo;
    /**
     * The ForeignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForeignId;
    /**
     * The InteractionChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InteractionChannel;
    /**
     * The SaleMode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleMode;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * The UseUnpublishedRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseUnpublishedRules;
    /**
     * Constructor method for UpdateTransactionProperties-Request
     * @uses UpdateTransactionProperties_Request::setAccountContactPersonId()
     * @uses UpdateTransactionProperties_Request::setAffectProperties()
     * @uses UpdateTransactionProperties_Request::setAgencyAccountId()
     * @uses UpdateTransactionProperties_Request::setAgencyContactPersonId()
     * @uses UpdateTransactionProperties_Request::setClientDetails()
     * @uses UpdateTransactionProperties_Request::setExtraInfo()
     * @uses UpdateTransactionProperties_Request::setForeignId()
     * @uses UpdateTransactionProperties_Request::setInteractionChannel()
     * @uses UpdateTransactionProperties_Request::setSaleMode()
     * @uses UpdateTransactionProperties_Request::setTransactionGuid()
     * @uses UpdateTransactionProperties_Request::setTransactionSnapshotType()
     * @uses UpdateTransactionProperties_Request::setUseUnpublishedRules()
     * @param string $accountContactPersonId
     * @param string[] $affectProperties
     * @param string $agencyAccountId
     * @param string $agencyContactPersonId
     * @param \patest\StructType\TransactionClientDetails $clientDetails
     * @param \patest\StructType\ExtraFields $extraInfo
     * @param string $foreignId
     * @param string $interactionChannel
     * @param string $saleMode
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     * @param bool $useUnpublishedRules
     */
    public function __construct($accountContactPersonId = null, array $affectProperties = array(), $agencyAccountId = null, $agencyContactPersonId = null, \patest\StructType\TransactionClientDetails $clientDetails = null, \patest\StructType\ExtraFields $extraInfo = null, $foreignId = null, $interactionChannel = null, $saleMode = null, $transactionGuid = null, $transactionSnapshotType = null, $useUnpublishedRules = null)
    {
        $this
            ->setAccountContactPersonId($accountContactPersonId)
            ->setAffectProperties($affectProperties)
            ->setAgencyAccountId($agencyAccountId)
            ->setAgencyContactPersonId($agencyContactPersonId)
            ->setClientDetails($clientDetails)
            ->setExtraInfo($extraInfo)
            ->setForeignId($foreignId)
            ->setInteractionChannel($interactionChannel)
            ->setSaleMode($saleMode)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType)
            ->setUseUnpublishedRules($useUnpublishedRules);
    }
    /**
     * Get AccountContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountContactPersonId()
    {
        return isset($this->AccountContactPersonId) ? $this->AccountContactPersonId : null;
    }
    /**
     * Set AccountContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountContactPersonId
     * @return \patest\StructType\UpdateTransactionProperties_Request
     */
    public function setAccountContactPersonId($accountContactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($accountContactPersonId) && !is_string($accountContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountContactPersonId, true), gettype($accountContactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountContactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountContactPersonId, true)), __LINE__);
        }
        if (is_null($accountContactPersonId) || (is_array($accountContactPersonId) && empty($accountContactPersonId))) {
            unset($this->AccountContactPersonId);
        } else {
            $this->AccountContactPersonId = $accountContactPersonId;
        }
        return $this;
    }
    /**
     * Get AffectProperties value
     * @return string[]|null
     */
    public function getAffectProperties()
    {
        return $this->AffectProperties;
    }
    /**
     * This method is responsible for validating the values passed to the setAffectProperties method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffectProperties method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAffectPropertiesForArrayConstraintsFromSetAffectProperties(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $updateTransactionProperties_RequestAffectPropertiesItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\TransactionProperties::valueIsValid($updateTransactionProperties_RequestAffectPropertiesItem)) {
                $invalidValues[] = is_object($updateTransactionProperties_RequestAffectPropertiesItem) ? get_class($updateTransactionProperties_RequestAffectPropertiesItem) : sprintf('%s(%s)', gettype($updateTransactionProperties_RequestAffectPropertiesItem), var_export($updateTransactionProperties_RequestAffectPropertiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionProperties', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\TransactionProperties::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AffectProperties value
     * @uses \patest\EnumType\TransactionProperties::valueIsValid()
     * @uses \patest\EnumType\TransactionProperties::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $affectProperties
     * @return \patest\StructType\UpdateTransactionProperties_Request
     */
    public function setAffectProperties(array $affectProperties = array())
    {
        // validation for constraint: list
        if ('' !== ($affectPropertiesArrayErrorMessage = self::validateAffectPropertiesForArrayConstraintsFromSetAffectProperties($affectProperties))) {
            throw new \InvalidArgumentException($affectPropertiesArrayErrorMessage, __LINE__);
        }
        $this->AffectProperties = is_array($affectProperties) ? implode(' ', $affectProperties) : null;
        return $this;
    }
    /**
     * Get AgencyAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyAccountId()
    {
        return isset($this->AgencyAccountId) ? $this->AgencyAccountId : null;
    }
    /**
     * Set AgencyAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyAccountId
     * @return \patest\StructType\UpdateTransactionProperties_Request
     */
    public function setAgencyAccountId($agencyAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($agencyAccountId) && !is_string($agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyAccountId, true), gettype($agencyAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agencyAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agencyAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agencyAccountId, true)), __LINE__);
        }
        if (is_null($agencyAccountId) || (is_array($agencyAccountId) && empty($agencyAccountId))) {
            unset($this->AgencyAccountId);
        } else {
            $this->AgencyAccountId = $agencyAccountId;
        }
        return $this;
    }
    /**
     * Get AgencyContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyContactPersonId()
    {
        return isset($this->AgencyContactPersonId) ? $this->AgencyContactPersonId : null;
    }
    /**
     * Set AgencyContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyContactPersonId
     * @return \patest\StructType\UpdateTransactionProperties_Request
     */
    public function setAgencyContactPersonId($agencyContactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($agencyContactPersonId) && !is_string($agencyContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyContactPersonId, true), gettype($agencyContactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agencyContactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agencyContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agencyContactPersonId, true)), __LINE__);
        }
        if (is_null($agencyContactPersonId) || (is_array($agencyContactPersonId) && empty($agencyContactPersonId))) {
            unset($this->AgencyContactPersonId);
        } else {
            $this->AgencyContactPersonId = $agencyContactPersonId;
        }
        return $this;
    }
    /**
     * Get ClientDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionClientDetails|null
     */
    public function getClientDetails()
    {
        return isset($this->ClientDetails) ? $this->ClientDetails : null;
    }
    /**
     * Set ClientDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionClientDetails $clientDetails
     * @return \patest\StructType\UpdateTransactionProperties_Request
     */
    public function setClientDetails(\patest\StructType\TransactionClientDetails $clientDetails = null)
    {
        if (is_null($clientDetails) || (is_array($clientDetails) && empty($clientDetails))) {
            unset($this->ClientDetails);
        } else {
            $this->ClientDetails = $clientDetails;
        }
        return $this;
    }
    /**
     * Get ExtraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExtraFields|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * Set ExtraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExtraFields $extraInfo
     * @return \patest\StructType\UpdateTransactionProperties_Request
     */
    public function setExtraInfo(\patest\StructType\ExtraFields $extraInfo = null)
    {
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Get ForeignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForeignId()
    {
        return isset($this->ForeignId) ? $this->ForeignId : null;
    }
    /**
     * Set ForeignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $foreignId
     * @return \patest\StructType\UpdateTransactionProperties_Request
     */
    public function setForeignId($foreignId = null)
    {
        // validation for constraint: string
        if (!is_null($foreignId) && !is_string($foreignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foreignId, true), gettype($foreignId)), __LINE__);
        }
        if (is_null($foreignId) || (is_array($foreignId) && empty($foreignId))) {
            unset($this->ForeignId);
        } else {
            $this->ForeignId = $foreignId;
        }
        return $this;
    }
    /**
     * Get InteractionChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInteractionChannel()
    {
        return isset($this->InteractionChannel) ? $this->InteractionChannel : null;
    }
    /**
     * Set InteractionChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionInteractionChannel::valueIsValid()
     * @uses \patest\EnumType\TransactionInteractionChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interactionChannel
     * @return \patest\StructType\UpdateTransactionProperties_Request
     */
    public function setInteractionChannel($interactionChannel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionInteractionChannel::valueIsValid($interactionChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionInteractionChannel', is_array($interactionChannel) ? implode(', ', $interactionChannel) : var_export($interactionChannel, true), implode(', ', \patest\EnumType\TransactionInteractionChannel::getValidValues())), __LINE__);
        }
        if (is_null($interactionChannel) || (is_array($interactionChannel) && empty($interactionChannel))) {
            unset($this->InteractionChannel);
        } else {
            $this->InteractionChannel = $interactionChannel;
        }
        return $this;
    }
    /**
     * Get SaleMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleMode()
    {
        return isset($this->SaleMode) ? $this->SaleMode : null;
    }
    /**
     * Set SaleMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleMode
     * @return \patest\StructType\UpdateTransactionProperties_Request
     */
    public function setSaleMode($saleMode = null)
    {
        // validation for constraint: string
        if (!is_null($saleMode) && !is_string($saleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleMode, true), gettype($saleMode)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleMode) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleMode, true)), __LINE__);
        }
        if (is_null($saleMode) || (is_array($saleMode) && empty($saleMode))) {
            unset($this->SaleMode);
        } else {
            $this->SaleMode = $saleMode;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\UpdateTransactionProperties_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\UpdateTransactionProperties_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
    /**
     * Get UseUnpublishedRules value
     * @return bool|null
     */
    public function getUseUnpublishedRules()
    {
        return $this->UseUnpublishedRules;
    }
    /**
     * Set UseUnpublishedRules value
     * @param bool $useUnpublishedRules
     * @return \patest\StructType\UpdateTransactionProperties_Request
     */
    public function setUseUnpublishedRules($useUnpublishedRules = null)
    {
        // validation for constraint: boolean
        if (!is_null($useUnpublishedRules) && !is_bool($useUnpublishedRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useUnpublishedRules, true), gettype($useUnpublishedRules)), __LINE__);
        }
        $this->UseUnpublishedRules = $useUnpublishedRules;
        return $this;
    }
}
