<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePaymentItemProviderSpecificPropertiesRequest
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdatePaymentItemProviderSpecificPropertiesRequest
 * @subpackage Structs
 */
class UpdatePaymentItemProviderSpecificPropertiesRequest extends AbstractStructBase
{
    /**
     * The NewProviderSpecificData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $NewProviderSpecificData;
    /**
     * The PaymentItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentItemId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for UpdatePaymentItemProviderSpecificPropertiesRequest
     * @uses UpdatePaymentItemProviderSpecificPropertiesRequest::setNewProviderSpecificData()
     * @uses UpdatePaymentItemProviderSpecificPropertiesRequest::setPaymentItemId()
     * @uses UpdatePaymentItemProviderSpecificPropertiesRequest::setTransactionGuid()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $newProviderSpecificData
     * @param string $paymentItemId
     * @param string $transactionGuid
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfstringstring $newProviderSpecificData = null, $paymentItemId = null, $transactionGuid = null)
    {
        $this
            ->setNewProviderSpecificData($newProviderSpecificData)
            ->setPaymentItemId($paymentItemId)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get NewProviderSpecificData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getNewProviderSpecificData()
    {
        return isset($this->NewProviderSpecificData) ? $this->NewProviderSpecificData : null;
    }
    /**
     * Set NewProviderSpecificData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $newProviderSpecificData
     * @return \patest\StructType\UpdatePaymentItemProviderSpecificPropertiesRequest
     */
    public function setNewProviderSpecificData(\patest\ArrayType\ArrayOfKeyValueOfstringstring $newProviderSpecificData = null)
    {
        if (is_null($newProviderSpecificData) || (is_array($newProviderSpecificData) && empty($newProviderSpecificData))) {
            unset($this->NewProviderSpecificData);
        } else {
            $this->NewProviderSpecificData = $newProviderSpecificData;
        }
        return $this;
    }
    /**
     * Get PaymentItemId value
     * @return string|null
     */
    public function getPaymentItemId()
    {
        return $this->PaymentItemId;
    }
    /**
     * Set PaymentItemId value
     * @param string $paymentItemId
     * @return \patest\StructType\UpdatePaymentItemProviderSpecificPropertiesRequest
     */
    public function setPaymentItemId($paymentItemId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemId) && !is_string($paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemId, true), gettype($paymentItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentItemId, true)), __LINE__);
        }
        $this->PaymentItemId = $paymentItemId;
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\UpdatePaymentItemProviderSpecificPropertiesRequest
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
}
