<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateOfClientApprovalOfEnrollment-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateOfClientApprovalOfEnrollment-Request
 * @subpackage Structs
 */
class UpdateOfClientApprovalOfEnrollment_Request extends ExtensibleDataContract
{
    /**
     * The Approve
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Approve;
    /**
     * The EnrollmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EnrollmentId;
    /**
     * The TicketSchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketSchemeId;
    /**
     * Constructor method for UpdateOfClientApprovalOfEnrollment-Request
     * @uses UpdateOfClientApprovalOfEnrollment_Request::setApprove()
     * @uses UpdateOfClientApprovalOfEnrollment_Request::setEnrollmentId()
     * @uses UpdateOfClientApprovalOfEnrollment_Request::setTicketSchemeId()
     * @param bool $approve
     * @param string $enrollmentId
     * @param string $ticketSchemeId
     */
    public function __construct($approve = null, $enrollmentId = null, $ticketSchemeId = null)
    {
        $this
            ->setApprove($approve)
            ->setEnrollmentId($enrollmentId)
            ->setTicketSchemeId($ticketSchemeId);
    }
    /**
     * Get Approve value
     * @return bool|null
     */
    public function getApprove()
    {
        return $this->Approve;
    }
    /**
     * Set Approve value
     * @param bool $approve
     * @return \patest\StructType\UpdateOfClientApprovalOfEnrollment_Request
     */
    public function setApprove($approve = null)
    {
        // validation for constraint: boolean
        if (!is_null($approve) && !is_bool($approve)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($approve, true), gettype($approve)), __LINE__);
        }
        $this->Approve = $approve;
        return $this;
    }
    /**
     * Get EnrollmentId value
     * @return string|null
     */
    public function getEnrollmentId()
    {
        return $this->EnrollmentId;
    }
    /**
     * Set EnrollmentId value
     * @param string $enrollmentId
     * @return \patest\StructType\UpdateOfClientApprovalOfEnrollment_Request
     */
    public function setEnrollmentId($enrollmentId = null)
    {
        // validation for constraint: string
        if (!is_null($enrollmentId) && !is_string($enrollmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enrollmentId, true), gettype($enrollmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($enrollmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $enrollmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($enrollmentId, true)), __LINE__);
        }
        $this->EnrollmentId = $enrollmentId;
        return $this;
    }
    /**
     * Get TicketSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSchemeId()
    {
        return isset($this->TicketSchemeId) ? $this->TicketSchemeId : null;
    }
    /**
     * Set TicketSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSchemeId
     * @return \patest\StructType\UpdateOfClientApprovalOfEnrollment_Request
     */
    public function setTicketSchemeId($ticketSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSchemeId) && !is_string($ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSchemeId, true), gettype($ticketSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketSchemeId, true)), __LINE__);
        }
        if (is_null($ticketSchemeId) || (is_array($ticketSchemeId) && empty($ticketSchemeId))) {
            unset($this->TicketSchemeId);
        } else {
            $this->TicketSchemeId = $ticketSchemeId;
        }
        return $this;
    }
}
