<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMembershipItemProperties-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateMembershipItemProperties-Request
 * @subpackage Structs
 */
class UpdateMembershipItemProperties_Request extends ExtensibleDataContract
{
    /**
     * The AffectProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $AffectProperties;
    /**
     * The ItemIdsToUpdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfOverridableMembershipItemProperties
     */
    public $ItemIdsToUpdate;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * The ItemOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTransactionClientDetails
     */
    public $ItemOwners;
    /**
     * Constructor method for UpdateMembershipItemProperties-Request
     * @uses UpdateMembershipItemProperties_Request::setAffectProperties()
     * @uses UpdateMembershipItemProperties_Request::setItemIdsToUpdate()
     * @uses UpdateMembershipItemProperties_Request::setTransactionGuid()
     * @uses UpdateMembershipItemProperties_Request::setTransactionSnapshotType()
     * @uses UpdateMembershipItemProperties_Request::setItemOwners()
     * @param string[] $affectProperties
     * @param \patest\ArrayType\ArrayOfOverridableMembershipItemProperties $itemIdsToUpdate
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     * @param \patest\ArrayType\ArrayOfTransactionClientDetails $itemOwners
     */
    public function __construct(array $affectProperties = array(), \patest\ArrayType\ArrayOfOverridableMembershipItemProperties $itemIdsToUpdate = null, $transactionGuid = null, $transactionSnapshotType = null, \patest\ArrayType\ArrayOfTransactionClientDetails $itemOwners = null)
    {
        $this
            ->setAffectProperties($affectProperties)
            ->setItemIdsToUpdate($itemIdsToUpdate)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType)
            ->setItemOwners($itemOwners);
    }
    /**
     * Get AffectProperties value
     * @return string[]|null
     */
    public function getAffectProperties()
    {
        return $this->AffectProperties;
    }
    /**
     * This method is responsible for validating the values passed to the setAffectProperties method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffectProperties method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAffectPropertiesForArrayConstraintsFromSetAffectProperties(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $updateMembershipItemProperties_RequestAffectPropertiesItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OverridableAffectMembershipItemProperties::valueIsValid($updateMembershipItemProperties_RequestAffectPropertiesItem)) {
                $invalidValues[] = is_object($updateMembershipItemProperties_RequestAffectPropertiesItem) ? get_class($updateMembershipItemProperties_RequestAffectPropertiesItem) : sprintf('%s(%s)', gettype($updateMembershipItemProperties_RequestAffectPropertiesItem), var_export($updateMembershipItemProperties_RequestAffectPropertiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OverridableAffectMembershipItemProperties', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OverridableAffectMembershipItemProperties::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AffectProperties value
     * @uses \patest\EnumType\OverridableAffectMembershipItemProperties::valueIsValid()
     * @uses \patest\EnumType\OverridableAffectMembershipItemProperties::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $affectProperties
     * @return \patest\StructType\UpdateMembershipItemProperties_Request
     */
    public function setAffectProperties(array $affectProperties = array())
    {
        // validation for constraint: list
        if ('' !== ($affectPropertiesArrayErrorMessage = self::validateAffectPropertiesForArrayConstraintsFromSetAffectProperties($affectProperties))) {
            throw new \InvalidArgumentException($affectPropertiesArrayErrorMessage, __LINE__);
        }
        $this->AffectProperties = is_array($affectProperties) ? implode(' ', $affectProperties) : null;
        return $this;
    }
    /**
     * Get ItemIdsToUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfOverridableMembershipItemProperties|null
     */
    public function getItemIdsToUpdate()
    {
        return isset($this->ItemIdsToUpdate) ? $this->ItemIdsToUpdate : null;
    }
    /**
     * Set ItemIdsToUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfOverridableMembershipItemProperties $itemIdsToUpdate
     * @return \patest\StructType\UpdateMembershipItemProperties_Request
     */
    public function setItemIdsToUpdate(\patest\ArrayType\ArrayOfOverridableMembershipItemProperties $itemIdsToUpdate = null)
    {
        if (is_null($itemIdsToUpdate) || (is_array($itemIdsToUpdate) && empty($itemIdsToUpdate))) {
            unset($this->ItemIdsToUpdate);
        } else {
            $this->ItemIdsToUpdate = $itemIdsToUpdate;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\UpdateMembershipItemProperties_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\UpdateMembershipItemProperties_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
    /**
     * Get ItemOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTransactionClientDetails|null
     */
    public function getItemOwners()
    {
        return isset($this->ItemOwners) ? $this->ItemOwners : null;
    }
    /**
     * Set ItemOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTransactionClientDetails $itemOwners
     * @return \patest\StructType\UpdateMembershipItemProperties_Request
     */
    public function setItemOwners(\patest\ArrayType\ArrayOfTransactionClientDetails $itemOwners = null)
    {
        if (is_null($itemOwners) || (is_array($itemOwners) && empty($itemOwners))) {
            unset($this->ItemOwners);
        } else {
            $this->ItemOwners = $itemOwners;
        }
        return $this;
    }
}
