<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateEventTicketViewConfiguration-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateEventTicketViewConfiguration-Response
 * @subpackage Structs
 */
class UpdateEventTicketViewConfiguration_Response extends AbstractStructBase
{
    /**
     * The TicketViewConfigurationsEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TicketViewConfigurationsEnabled;
    /**
     * The TicketViewConfigurationsTesterClientType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketViewConfigurationsTesterClientType;
    /**
     * The TicketViewConfigurationsTesterClientTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketViewConfigurationsTesterClientTypeName;
    /**
     * Constructor method for UpdateEventTicketViewConfiguration-Response
     * @uses UpdateEventTicketViewConfiguration_Response::setTicketViewConfigurationsEnabled()
     * @uses UpdateEventTicketViewConfiguration_Response::setTicketViewConfigurationsTesterClientType()
     * @uses UpdateEventTicketViewConfiguration_Response::setTicketViewConfigurationsTesterClientTypeName()
     * @param bool $ticketViewConfigurationsEnabled
     * @param string $ticketViewConfigurationsTesterClientType
     * @param string $ticketViewConfigurationsTesterClientTypeName
     */
    public function __construct($ticketViewConfigurationsEnabled = null, $ticketViewConfigurationsTesterClientType = null, $ticketViewConfigurationsTesterClientTypeName = null)
    {
        $this
            ->setTicketViewConfigurationsEnabled($ticketViewConfigurationsEnabled)
            ->setTicketViewConfigurationsTesterClientType($ticketViewConfigurationsTesterClientType)
            ->setTicketViewConfigurationsTesterClientTypeName($ticketViewConfigurationsTesterClientTypeName);
    }
    /**
     * Get TicketViewConfigurationsEnabled value
     * @return bool|null
     */
    public function getTicketViewConfigurationsEnabled()
    {
        return $this->TicketViewConfigurationsEnabled;
    }
    /**
     * Set TicketViewConfigurationsEnabled value
     * @param bool $ticketViewConfigurationsEnabled
     * @return \patest\StructType\UpdateEventTicketViewConfiguration_Response
     */
    public function setTicketViewConfigurationsEnabled($ticketViewConfigurationsEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($ticketViewConfigurationsEnabled) && !is_bool($ticketViewConfigurationsEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ticketViewConfigurationsEnabled, true), gettype($ticketViewConfigurationsEnabled)), __LINE__);
        }
        $this->TicketViewConfigurationsEnabled = $ticketViewConfigurationsEnabled;
        return $this;
    }
    /**
     * Get TicketViewConfigurationsTesterClientType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketViewConfigurationsTesterClientType()
    {
        return isset($this->TicketViewConfigurationsTesterClientType) ? $this->TicketViewConfigurationsTesterClientType : null;
    }
    /**
     * Set TicketViewConfigurationsTesterClientType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketViewConfigurationsTesterClientType
     * @return \patest\StructType\UpdateEventTicketViewConfiguration_Response
     */
    public function setTicketViewConfigurationsTesterClientType($ticketViewConfigurationsTesterClientType = null)
    {
        // validation for constraint: string
        if (!is_null($ticketViewConfigurationsTesterClientType) && !is_string($ticketViewConfigurationsTesterClientType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketViewConfigurationsTesterClientType, true), gettype($ticketViewConfigurationsTesterClientType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketViewConfigurationsTesterClientType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketViewConfigurationsTesterClientType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketViewConfigurationsTesterClientType, true)), __LINE__);
        }
        if (is_null($ticketViewConfigurationsTesterClientType) || (is_array($ticketViewConfigurationsTesterClientType) && empty($ticketViewConfigurationsTesterClientType))) {
            unset($this->TicketViewConfigurationsTesterClientType);
        } else {
            $this->TicketViewConfigurationsTesterClientType = $ticketViewConfigurationsTesterClientType;
        }
        return $this;
    }
    /**
     * Get TicketViewConfigurationsTesterClientTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketViewConfigurationsTesterClientTypeName()
    {
        return isset($this->TicketViewConfigurationsTesterClientTypeName) ? $this->TicketViewConfigurationsTesterClientTypeName : null;
    }
    /**
     * Set TicketViewConfigurationsTesterClientTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketViewConfigurationsTesterClientTypeName
     * @return \patest\StructType\UpdateEventTicketViewConfiguration_Response
     */
    public function setTicketViewConfigurationsTesterClientTypeName($ticketViewConfigurationsTesterClientTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($ticketViewConfigurationsTesterClientTypeName) && !is_string($ticketViewConfigurationsTesterClientTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketViewConfigurationsTesterClientTypeName, true), gettype($ticketViewConfigurationsTesterClientTypeName)), __LINE__);
        }
        if (is_null($ticketViewConfigurationsTesterClientTypeName) || (is_array($ticketViewConfigurationsTesterClientTypeName) && empty($ticketViewConfigurationsTesterClientTypeName))) {
            unset($this->TicketViewConfigurationsTesterClientTypeName);
        } else {
            $this->TicketViewConfigurationsTesterClientTypeName = $ticketViewConfigurationsTesterClientTypeName;
        }
        return $this;
    }
}
