<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCommittedTransactionProperties-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateCommittedTransactionProperties-Request
 * @subpackage Structs
 */
class UpdateCommittedTransactionProperties_Request extends ExtensibleDataContract
{
    /**
     * The AccountContactPersonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountContactPersonId;
    /**
     * The AffectProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $AffectProperties;
    /**
     * The AgencyContactPersonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgencyContactPersonId;
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ExtraFields
     */
    public $ExtraInfo;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for UpdateCommittedTransactionProperties-Request
     * @uses UpdateCommittedTransactionProperties_Request::setAccountContactPersonId()
     * @uses UpdateCommittedTransactionProperties_Request::setAffectProperties()
     * @uses UpdateCommittedTransactionProperties_Request::setAgencyContactPersonId()
     * @uses UpdateCommittedTransactionProperties_Request::setExtraInfo()
     * @uses UpdateCommittedTransactionProperties_Request::setTransactionGuid()
     * @uses UpdateCommittedTransactionProperties_Request::setTransactionNumber()
     * @param string $accountContactPersonId
     * @param string[] $affectProperties
     * @param string $agencyContactPersonId
     * @param \patest\StructType\ExtraFields $extraInfo
     * @param string $transactionGuid
     * @param int $transactionNumber
     */
    public function __construct($accountContactPersonId = null, array $affectProperties = array(), $agencyContactPersonId = null, \patest\StructType\ExtraFields $extraInfo = null, $transactionGuid = null, $transactionNumber = null)
    {
        $this
            ->setAccountContactPersonId($accountContactPersonId)
            ->setAffectProperties($affectProperties)
            ->setAgencyContactPersonId($agencyContactPersonId)
            ->setExtraInfo($extraInfo)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get AccountContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountContactPersonId()
    {
        return isset($this->AccountContactPersonId) ? $this->AccountContactPersonId : null;
    }
    /**
     * Set AccountContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountContactPersonId
     * @return \patest\StructType\UpdateCommittedTransactionProperties_Request
     */
    public function setAccountContactPersonId($accountContactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($accountContactPersonId) && !is_string($accountContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountContactPersonId, true), gettype($accountContactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountContactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountContactPersonId, true)), __LINE__);
        }
        if (is_null($accountContactPersonId) || (is_array($accountContactPersonId) && empty($accountContactPersonId))) {
            unset($this->AccountContactPersonId);
        } else {
            $this->AccountContactPersonId = $accountContactPersonId;
        }
        return $this;
    }
    /**
     * Get AffectProperties value
     * @return string[]|null
     */
    public function getAffectProperties()
    {
        return $this->AffectProperties;
    }
    /**
     * This method is responsible for validating the values passed to the setAffectProperties method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffectProperties method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAffectPropertiesForArrayConstraintsFromSetAffectProperties(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $updateCommittedTransactionProperties_RequestAffectPropertiesItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CommittedTransactionProperties::valueIsValid($updateCommittedTransactionProperties_RequestAffectPropertiesItem)) {
                $invalidValues[] = is_object($updateCommittedTransactionProperties_RequestAffectPropertiesItem) ? get_class($updateCommittedTransactionProperties_RequestAffectPropertiesItem) : sprintf('%s(%s)', gettype($updateCommittedTransactionProperties_RequestAffectPropertiesItem), var_export($updateCommittedTransactionProperties_RequestAffectPropertiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CommittedTransactionProperties', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CommittedTransactionProperties::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AffectProperties value
     * @uses \patest\EnumType\CommittedTransactionProperties::valueIsValid()
     * @uses \patest\EnumType\CommittedTransactionProperties::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $affectProperties
     * @return \patest\StructType\UpdateCommittedTransactionProperties_Request
     */
    public function setAffectProperties(array $affectProperties = array())
    {
        // validation for constraint: list
        if ('' !== ($affectPropertiesArrayErrorMessage = self::validateAffectPropertiesForArrayConstraintsFromSetAffectProperties($affectProperties))) {
            throw new \InvalidArgumentException($affectPropertiesArrayErrorMessage, __LINE__);
        }
        $this->AffectProperties = is_array($affectProperties) ? implode(' ', $affectProperties) : null;
        return $this;
    }
    /**
     * Get AgencyContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyContactPersonId()
    {
        return isset($this->AgencyContactPersonId) ? $this->AgencyContactPersonId : null;
    }
    /**
     * Set AgencyContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyContactPersonId
     * @return \patest\StructType\UpdateCommittedTransactionProperties_Request
     */
    public function setAgencyContactPersonId($agencyContactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($agencyContactPersonId) && !is_string($agencyContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyContactPersonId, true), gettype($agencyContactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agencyContactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agencyContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agencyContactPersonId, true)), __LINE__);
        }
        if (is_null($agencyContactPersonId) || (is_array($agencyContactPersonId) && empty($agencyContactPersonId))) {
            unset($this->AgencyContactPersonId);
        } else {
            $this->AgencyContactPersonId = $agencyContactPersonId;
        }
        return $this;
    }
    /**
     * Get ExtraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ExtraFields|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * Set ExtraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ExtraFields $extraInfo
     * @return \patest\StructType\UpdateCommittedTransactionProperties_Request
     */
    public function setExtraInfo(\patest\StructType\ExtraFields $extraInfo = null)
    {
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\UpdateCommittedTransactionProperties_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\UpdateCommittedTransactionProperties_Request
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
