<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionValidationMessage StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionValidationMessage
 * @subpackage Structs
 */
class TransactionValidationMessage extends TransactionMessageBase
{
    /**
     * The FaultCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FaultCode;
    /**
     * The FaultDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FaultDescription;
    /**
     * The TransactionItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionItemId;
    /**
     * The ExtraData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $ExtraData;
    /**
     * Constructor method for TransactionValidationMessage
     * @uses TransactionValidationMessage::setFaultCode()
     * @uses TransactionValidationMessage::setFaultDescription()
     * @uses TransactionValidationMessage::setTransactionItemId()
     * @uses TransactionValidationMessage::setExtraData()
     * @param string $faultCode
     * @param string $faultDescription
     * @param int $transactionItemId
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData
     */
    public function __construct($faultCode = null, $faultDescription = null, $transactionItemId = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData = null)
    {
        $this
            ->setFaultCode($faultCode)
            ->setFaultDescription($faultDescription)
            ->setTransactionItemId($transactionItemId)
            ->setExtraData($extraData);
    }
    /**
     * Get FaultCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaultCode()
    {
        return isset($this->FaultCode) ? $this->FaultCode : null;
    }
    /**
     * Set FaultCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faultCode
     * @return \patest\StructType\TransactionValidationMessage
     */
    public function setFaultCode($faultCode = null)
    {
        // validation for constraint: string
        if (!is_null($faultCode) && !is_string($faultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultCode, true), gettype($faultCode)), __LINE__);
        }
        if (is_null($faultCode) || (is_array($faultCode) && empty($faultCode))) {
            unset($this->FaultCode);
        } else {
            $this->FaultCode = $faultCode;
        }
        return $this;
    }
    /**
     * Get FaultDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaultDescription()
    {
        return isset($this->FaultDescription) ? $this->FaultDescription : null;
    }
    /**
     * Set FaultDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faultDescription
     * @return \patest\StructType\TransactionValidationMessage
     */
    public function setFaultDescription($faultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($faultDescription) && !is_string($faultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultDescription, true), gettype($faultDescription)), __LINE__);
        }
        if (is_null($faultDescription) || (is_array($faultDescription) && empty($faultDescription))) {
            unset($this->FaultDescription);
        } else {
            $this->FaultDescription = $faultDescription;
        }
        return $this;
    }
    /**
     * Get TransactionItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionItemId()
    {
        return isset($this->TransactionItemId) ? $this->TransactionItemId : null;
    }
    /**
     * Set TransactionItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionItemId
     * @return \patest\StructType\TransactionValidationMessage
     */
    public function setTransactionItemId($transactionItemId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionItemId) && !(is_int($transactionItemId) || ctype_digit($transactionItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionItemId, true), gettype($transactionItemId)), __LINE__);
        }
        if (is_null($transactionItemId) || (is_array($transactionItemId) && empty($transactionItemId))) {
            unset($this->TransactionItemId);
        } else {
            $this->TransactionItemId = $transactionItemId;
        }
        return $this;
    }
    /**
     * Get ExtraData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getExtraData()
    {
        return isset($this->ExtraData) ? $this->ExtraData : null;
    }
    /**
     * Set ExtraData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData
     * @return \patest\StructType\TransactionValidationMessage
     */
    public function setExtraData(\patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData = null)
    {
        if (is_null($extraData) || (is_array($extraData) && empty($extraData))) {
            unset($this->ExtraData);
        } else {
            $this->ExtraData = $extraData;
        }
        return $this;
    }
}
