<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionSaleMode StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionSaleMode
 * @subpackage Structs
 */
class TransactionSaleMode extends AbstractStructBase
{
    /**
     * The AccountTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AccountTypeIds;
    /**
     * The AgencyMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AgencyMode;
    /**
     * The ClientDetailsPopupMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClientDetailsPopupMode;
    /**
     * The ClientDetailsScreenId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientDetailsScreenId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ExtraDataScreenId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraDataScreenId;
    /**
     * The GenerateCustomerOrderForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GenerateCustomerOrderForm;
    /**
     * The HighlightColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HighlightColor;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The InteractionChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InteractionChannel;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OnBehalfOfAccountRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OnBehalfOfAccountRequired;
    /**
     * The SellTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SellTo;
    /**
     * The SellToAccountMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SellToAccountMode;
    /**
     * The SuppressPopupAlerts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SuppressPopupAlerts;
    /**
     * The SuppressTransactionValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SuppressTransactionValidation;
    /**
     * Constructor method for TransactionSaleMode
     * @uses TransactionSaleMode::setAccountTypeIds()
     * @uses TransactionSaleMode::setAgencyMode()
     * @uses TransactionSaleMode::setClientDetailsPopupMode()
     * @uses TransactionSaleMode::setClientDetailsScreenId()
     * @uses TransactionSaleMode::setDescription()
     * @uses TransactionSaleMode::setExtraDataScreenId()
     * @uses TransactionSaleMode::setGenerateCustomerOrderForm()
     * @uses TransactionSaleMode::setHighlightColor()
     * @uses TransactionSaleMode::setId()
     * @uses TransactionSaleMode::setInteractionChannel()
     * @uses TransactionSaleMode::setIsActive()
     * @uses TransactionSaleMode::setName()
     * @uses TransactionSaleMode::setOnBehalfOfAccountRequired()
     * @uses TransactionSaleMode::setSellTo()
     * @uses TransactionSaleMode::setSellToAccountMode()
     * @uses TransactionSaleMode::setSuppressPopupAlerts()
     * @uses TransactionSaleMode::setSuppressTransactionValidation()
     * @param \patest\ArrayType\ArrayOfguid $accountTypeIds
     * @param string $agencyMode
     * @param string $clientDetailsPopupMode
     * @param string $clientDetailsScreenId
     * @param string $description
     * @param string $extraDataScreenId
     * @param bool $generateCustomerOrderForm
     * @param string $highlightColor
     * @param string $id
     * @param string $interactionChannel
     * @param bool $isActive
     * @param string $name
     * @param bool $onBehalfOfAccountRequired
     * @param string $sellTo
     * @param string $sellToAccountMode
     * @param bool $suppressPopupAlerts
     * @param bool $suppressTransactionValidation
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $accountTypeIds = null, $agencyMode = null, $clientDetailsPopupMode = null, $clientDetailsScreenId = null, $description = null, $extraDataScreenId = null, $generateCustomerOrderForm = null, $highlightColor = null, $id = null, $interactionChannel = null, $isActive = null, $name = null, $onBehalfOfAccountRequired = null, $sellTo = null, $sellToAccountMode = null, $suppressPopupAlerts = null, $suppressTransactionValidation = null)
    {
        $this
            ->setAccountTypeIds($accountTypeIds)
            ->setAgencyMode($agencyMode)
            ->setClientDetailsPopupMode($clientDetailsPopupMode)
            ->setClientDetailsScreenId($clientDetailsScreenId)
            ->setDescription($description)
            ->setExtraDataScreenId($extraDataScreenId)
            ->setGenerateCustomerOrderForm($generateCustomerOrderForm)
            ->setHighlightColor($highlightColor)
            ->setId($id)
            ->setInteractionChannel($interactionChannel)
            ->setIsActive($isActive)
            ->setName($name)
            ->setOnBehalfOfAccountRequired($onBehalfOfAccountRequired)
            ->setSellTo($sellTo)
            ->setSellToAccountMode($sellToAccountMode)
            ->setSuppressPopupAlerts($suppressPopupAlerts)
            ->setSuppressTransactionValidation($suppressTransactionValidation);
    }
    /**
     * Get AccountTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAccountTypeIds()
    {
        return isset($this->AccountTypeIds) ? $this->AccountTypeIds : null;
    }
    /**
     * Set AccountTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $accountTypeIds
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setAccountTypeIds(\patest\ArrayType\ArrayOfguid $accountTypeIds = null)
    {
        if (is_null($accountTypeIds) || (is_array($accountTypeIds) && empty($accountTypeIds))) {
            unset($this->AccountTypeIds);
        } else {
            $this->AccountTypeIds = $accountTypeIds;
        }
        return $this;
    }
    /**
     * Get AgencyMode value
     * @return string|null
     */
    public function getAgencyMode()
    {
        return $this->AgencyMode;
    }
    /**
     * Set AgencyMode value
     * @uses \patest\EnumType\AgencySelectionMode::valueIsValid()
     * @uses \patest\EnumType\AgencySelectionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $agencyMode
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setAgencyMode($agencyMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AgencySelectionMode::valueIsValid($agencyMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AgencySelectionMode', is_array($agencyMode) ? implode(', ', $agencyMode) : var_export($agencyMode, true), implode(', ', \patest\EnumType\AgencySelectionMode::getValidValues())), __LINE__);
        }
        $this->AgencyMode = $agencyMode;
        return $this;
    }
    /**
     * Get ClientDetailsPopupMode value
     * @return string|null
     */
    public function getClientDetailsPopupMode()
    {
        return $this->ClientDetailsPopupMode;
    }
    /**
     * Set ClientDetailsPopupMode value
     * @uses \patest\EnumType\ClientDetailsPopupMode::valueIsValid()
     * @uses \patest\EnumType\ClientDetailsPopupMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientDetailsPopupMode
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setClientDetailsPopupMode($clientDetailsPopupMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ClientDetailsPopupMode::valueIsValid($clientDetailsPopupMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClientDetailsPopupMode', is_array($clientDetailsPopupMode) ? implode(', ', $clientDetailsPopupMode) : var_export($clientDetailsPopupMode, true), implode(', ', \patest\EnumType\ClientDetailsPopupMode::getValidValues())), __LINE__);
        }
        $this->ClientDetailsPopupMode = $clientDetailsPopupMode;
        return $this;
    }
    /**
     * Get ClientDetailsScreenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientDetailsScreenId()
    {
        return isset($this->ClientDetailsScreenId) ? $this->ClientDetailsScreenId : null;
    }
    /**
     * Set ClientDetailsScreenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientDetailsScreenId
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setClientDetailsScreenId($clientDetailsScreenId = null)
    {
        // validation for constraint: string
        if (!is_null($clientDetailsScreenId) && !is_string($clientDetailsScreenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientDetailsScreenId, true), gettype($clientDetailsScreenId)), __LINE__);
        }
        if (is_null($clientDetailsScreenId) || (is_array($clientDetailsScreenId) && empty($clientDetailsScreenId))) {
            unset($this->ClientDetailsScreenId);
        } else {
            $this->ClientDetailsScreenId = $clientDetailsScreenId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExtraDataScreenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraDataScreenId()
    {
        return isset($this->ExtraDataScreenId) ? $this->ExtraDataScreenId : null;
    }
    /**
     * Set ExtraDataScreenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraDataScreenId
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setExtraDataScreenId($extraDataScreenId = null)
    {
        // validation for constraint: string
        if (!is_null($extraDataScreenId) && !is_string($extraDataScreenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraDataScreenId, true), gettype($extraDataScreenId)), __LINE__);
        }
        if (is_null($extraDataScreenId) || (is_array($extraDataScreenId) && empty($extraDataScreenId))) {
            unset($this->ExtraDataScreenId);
        } else {
            $this->ExtraDataScreenId = $extraDataScreenId;
        }
        return $this;
    }
    /**
     * Get GenerateCustomerOrderForm value
     * @return bool|null
     */
    public function getGenerateCustomerOrderForm()
    {
        return $this->GenerateCustomerOrderForm;
    }
    /**
     * Set GenerateCustomerOrderForm value
     * @param bool $generateCustomerOrderForm
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setGenerateCustomerOrderForm($generateCustomerOrderForm = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateCustomerOrderForm) && !is_bool($generateCustomerOrderForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateCustomerOrderForm, true), gettype($generateCustomerOrderForm)), __LINE__);
        }
        $this->GenerateCustomerOrderForm = $generateCustomerOrderForm;
        return $this;
    }
    /**
     * Get HighlightColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHighlightColor()
    {
        return isset($this->HighlightColor) ? $this->HighlightColor : null;
    }
    /**
     * Set HighlightColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $highlightColor
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setHighlightColor($highlightColor = null)
    {
        // validation for constraint: string
        if (!is_null($highlightColor) && !is_string($highlightColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($highlightColor, true), gettype($highlightColor)), __LINE__);
        }
        if (is_null($highlightColor) || (is_array($highlightColor) && empty($highlightColor))) {
            unset($this->HighlightColor);
        } else {
            $this->HighlightColor = $highlightColor;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get InteractionChannel value
     * @return string|null
     */
    public function getInteractionChannel()
    {
        return $this->InteractionChannel;
    }
    /**
     * Set InteractionChannel value
     * @uses \patest\EnumType\TransactionInteractionChannel::valueIsValid()
     * @uses \patest\EnumType\TransactionInteractionChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interactionChannel
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setInteractionChannel($interactionChannel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionInteractionChannel::valueIsValid($interactionChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionInteractionChannel', is_array($interactionChannel) ? implode(', ', $interactionChannel) : var_export($interactionChannel, true), implode(', ', \patest\EnumType\TransactionInteractionChannel::getValidValues())), __LINE__);
        }
        $this->InteractionChannel = $interactionChannel;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OnBehalfOfAccountRequired value
     * @return bool|null
     */
    public function getOnBehalfOfAccountRequired()
    {
        return $this->OnBehalfOfAccountRequired;
    }
    /**
     * Set OnBehalfOfAccountRequired value
     * @param bool $onBehalfOfAccountRequired
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setOnBehalfOfAccountRequired($onBehalfOfAccountRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($onBehalfOfAccountRequired) && !is_bool($onBehalfOfAccountRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onBehalfOfAccountRequired, true), gettype($onBehalfOfAccountRequired)), __LINE__);
        }
        $this->OnBehalfOfAccountRequired = $onBehalfOfAccountRequired;
        return $this;
    }
    /**
     * Get SellTo value
     * @return string|null
     */
    public function getSellTo()
    {
        return $this->SellTo;
    }
    /**
     * Set SellTo value
     * @uses \patest\EnumType\SellTo::valueIsValid()
     * @uses \patest\EnumType\SellTo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sellTo
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setSellTo($sellTo = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SellTo::valueIsValid($sellTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SellTo', is_array($sellTo) ? implode(', ', $sellTo) : var_export($sellTo, true), implode(', ', \patest\EnumType\SellTo::getValidValues())), __LINE__);
        }
        $this->SellTo = $sellTo;
        return $this;
    }
    /**
     * Get SellToAccountMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellToAccountMode()
    {
        return isset($this->SellToAccountMode) ? $this->SellToAccountMode : null;
    }
    /**
     * Set SellToAccountMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SellToAccountMode::valueIsValid()
     * @uses \patest\EnumType\SellToAccountMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sellToAccountMode
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setSellToAccountMode($sellToAccountMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SellToAccountMode::valueIsValid($sellToAccountMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SellToAccountMode', is_array($sellToAccountMode) ? implode(', ', $sellToAccountMode) : var_export($sellToAccountMode, true), implode(', ', \patest\EnumType\SellToAccountMode::getValidValues())), __LINE__);
        }
        if (is_null($sellToAccountMode) || (is_array($sellToAccountMode) && empty($sellToAccountMode))) {
            unset($this->SellToAccountMode);
        } else {
            $this->SellToAccountMode = $sellToAccountMode;
        }
        return $this;
    }
    /**
     * Get SuppressPopupAlerts value
     * @return bool|null
     */
    public function getSuppressPopupAlerts()
    {
        return $this->SuppressPopupAlerts;
    }
    /**
     * Set SuppressPopupAlerts value
     * @param bool $suppressPopupAlerts
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setSuppressPopupAlerts($suppressPopupAlerts = null)
    {
        // validation for constraint: boolean
        if (!is_null($suppressPopupAlerts) && !is_bool($suppressPopupAlerts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($suppressPopupAlerts, true), gettype($suppressPopupAlerts)), __LINE__);
        }
        $this->SuppressPopupAlerts = $suppressPopupAlerts;
        return $this;
    }
    /**
     * Get SuppressTransactionValidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSuppressTransactionValidation()
    {
        return isset($this->SuppressTransactionValidation) ? $this->SuppressTransactionValidation : null;
    }
    /**
     * Set SuppressTransactionValidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $suppressTransactionValidation
     * @return \patest\StructType\TransactionSaleMode
     */
    public function setSuppressTransactionValidation($suppressTransactionValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($suppressTransactionValidation) && !is_bool($suppressTransactionValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($suppressTransactionValidation, true), gettype($suppressTransactionValidation)), __LINE__);
        }
        if (is_null($suppressTransactionValidation) || (is_array($suppressTransactionValidation) && empty($suppressTransactionValidation))) {
            unset($this->SuppressTransactionValidation);
        } else {
            $this->SuppressTransactionValidation = $suppressTransactionValidation;
        }
        return $this;
    }
}
