<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionElementFinancialJournalInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionElementFinancialJournalInfo
 * @subpackage Structs
 */
class TransactionElementFinancialJournalInfo extends AbstractStructBase
{
    /**
     * The CreditAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $CreditAmount;
    /**
     * The DebitAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $DebitAmount;
    /**
     * The DebitQty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DebitQty;
    /**
     * The IsTargetAmendment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsTargetAmendment;
    /**
     * The TargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetId;
    /**
     * The TargetKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TargetKind;
    /**
     * The UnpaidInstallmentsAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $UnpaidInstallmentsAmount;
    /**
     * The SubTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubTargetId;
    /**
     * Constructor method for TransactionElementFinancialJournalInfo
     * @uses TransactionElementFinancialJournalInfo::setCreditAmount()
     * @uses TransactionElementFinancialJournalInfo::setDebitAmount()
     * @uses TransactionElementFinancialJournalInfo::setDebitQty()
     * @uses TransactionElementFinancialJournalInfo::setIsTargetAmendment()
     * @uses TransactionElementFinancialJournalInfo::setTargetId()
     * @uses TransactionElementFinancialJournalInfo::setTargetKind()
     * @uses TransactionElementFinancialJournalInfo::setUnpaidInstallmentsAmount()
     * @uses TransactionElementFinancialJournalInfo::setSubTargetId()
     * @param \patest\StructType\Money $creditAmount
     * @param \patest\StructType\Money $debitAmount
     * @param int $debitQty
     * @param bool $isTargetAmendment
     * @param string $targetId
     * @param string $targetKind
     * @param \patest\StructType\Money $unpaidInstallmentsAmount
     * @param string $subTargetId
     */
    public function __construct(\patest\StructType\Money $creditAmount = null, \patest\StructType\Money $debitAmount = null, $debitQty = null, $isTargetAmendment = null, $targetId = null, $targetKind = null, \patest\StructType\Money $unpaidInstallmentsAmount = null, $subTargetId = null)
    {
        $this
            ->setCreditAmount($creditAmount)
            ->setDebitAmount($debitAmount)
            ->setDebitQty($debitQty)
            ->setIsTargetAmendment($isTargetAmendment)
            ->setTargetId($targetId)
            ->setTargetKind($targetKind)
            ->setUnpaidInstallmentsAmount($unpaidInstallmentsAmount)
            ->setSubTargetId($subTargetId);
    }
    /**
     * Get CreditAmount value
     * @return \patest\StructType\Money|null
     */
    public function getCreditAmount()
    {
        return $this->CreditAmount;
    }
    /**
     * Set CreditAmount value
     * @param \patest\StructType\Money $creditAmount
     * @return \patest\StructType\TransactionElementFinancialJournalInfo
     */
    public function setCreditAmount(\patest\StructType\Money $creditAmount = null)
    {
        $this->CreditAmount = $creditAmount;
        return $this;
    }
    /**
     * Get DebitAmount value
     * @return \patest\StructType\Money|null
     */
    public function getDebitAmount()
    {
        return $this->DebitAmount;
    }
    /**
     * Set DebitAmount value
     * @param \patest\StructType\Money $debitAmount
     * @return \patest\StructType\TransactionElementFinancialJournalInfo
     */
    public function setDebitAmount(\patest\StructType\Money $debitAmount = null)
    {
        $this->DebitAmount = $debitAmount;
        return $this;
    }
    /**
     * Get DebitQty value
     * @return int|null
     */
    public function getDebitQty()
    {
        return $this->DebitQty;
    }
    /**
     * Set DebitQty value
     * @param int $debitQty
     * @return \patest\StructType\TransactionElementFinancialJournalInfo
     */
    public function setDebitQty($debitQty = null)
    {
        // validation for constraint: int
        if (!is_null($debitQty) && !(is_int($debitQty) || ctype_digit($debitQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($debitQty, true), gettype($debitQty)), __LINE__);
        }
        $this->DebitQty = $debitQty;
        return $this;
    }
    /**
     * Get IsTargetAmendment value
     * @return bool|null
     */
    public function getIsTargetAmendment()
    {
        return $this->IsTargetAmendment;
    }
    /**
     * Set IsTargetAmendment value
     * @param bool $isTargetAmendment
     * @return \patest\StructType\TransactionElementFinancialJournalInfo
     */
    public function setIsTargetAmendment($isTargetAmendment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTargetAmendment) && !is_bool($isTargetAmendment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTargetAmendment, true), gettype($isTargetAmendment)), __LINE__);
        }
        $this->IsTargetAmendment = $isTargetAmendment;
        return $this;
    }
    /**
     * Get TargetId value
     * @return string|null
     */
    public function getTargetId()
    {
        return $this->TargetId;
    }
    /**
     * Set TargetId value
     * @param string $targetId
     * @return \patest\StructType\TransactionElementFinancialJournalInfo
     */
    public function setTargetId($targetId = null)
    {
        // validation for constraint: string
        if (!is_null($targetId) && !is_string($targetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetId, true), gettype($targetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetId, true)), __LINE__);
        }
        $this->TargetId = $targetId;
        return $this;
    }
    /**
     * Get TargetKind value
     * @return string|null
     */
    public function getTargetKind()
    {
        return $this->TargetKind;
    }
    /**
     * Set TargetKind value
     * @uses \patest\EnumType\FinancialJournalTargetKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalTargetKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $targetKind
     * @return \patest\StructType\TransactionElementFinancialJournalInfo
     */
    public function setTargetKind($targetKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalTargetKind::valueIsValid($targetKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalTargetKind', is_array($targetKind) ? implode(', ', $targetKind) : var_export($targetKind, true), implode(', ', \patest\EnumType\FinancialJournalTargetKind::getValidValues())), __LINE__);
        }
        $this->TargetKind = $targetKind;
        return $this;
    }
    /**
     * Get UnpaidInstallmentsAmount value
     * @return \patest\StructType\Money|null
     */
    public function getUnpaidInstallmentsAmount()
    {
        return $this->UnpaidInstallmentsAmount;
    }
    /**
     * Set UnpaidInstallmentsAmount value
     * @param \patest\StructType\Money $unpaidInstallmentsAmount
     * @return \patest\StructType\TransactionElementFinancialJournalInfo
     */
    public function setUnpaidInstallmentsAmount(\patest\StructType\Money $unpaidInstallmentsAmount = null)
    {
        $this->UnpaidInstallmentsAmount = $unpaidInstallmentsAmount;
        return $this;
    }
    /**
     * Get SubTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubTargetId()
    {
        return isset($this->SubTargetId) ? $this->SubTargetId : null;
    }
    /**
     * Set SubTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subTargetId
     * @return \patest\StructType\TransactionElementFinancialJournalInfo
     */
    public function setSubTargetId($subTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($subTargetId) && !is_string($subTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subTargetId, true), gettype($subTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subTargetId, true)), __LINE__);
        }
        if (is_null($subTargetId) || (is_array($subTargetId) && empty($subTargetId))) {
            unset($this->SubTargetId);
        } else {
            $this->SubTargetId = $subTargetId;
        }
        return $this;
    }
}
