<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionCompletionMessage StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionCompletionMessage
 * @subpackage Structs
 */
class TransactionCompletionMessage extends TransactionMessageBase
{
    /**
     * The AlwaysPopupForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AlwaysPopupForm;
    /**
     * The ExtraData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $ExtraData;
    /**
     * The InfoExists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $InfoExists;
    /**
     * The InfoRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $InfoRequired;
    /**
     * The InfoType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InfoType;
    /**
     * The TransactionItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionItemId;
    /**
     * Constructor method for TransactionCompletionMessage
     * @uses TransactionCompletionMessage::setAlwaysPopupForm()
     * @uses TransactionCompletionMessage::setExtraData()
     * @uses TransactionCompletionMessage::setInfoExists()
     * @uses TransactionCompletionMessage::setInfoRequired()
     * @uses TransactionCompletionMessage::setInfoType()
     * @uses TransactionCompletionMessage::setTransactionItemId()
     * @param bool $alwaysPopupForm
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData
     * @param bool $infoExists
     * @param bool $infoRequired
     * @param string $infoType
     * @param int $transactionItemId
     */
    public function __construct($alwaysPopupForm = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData = null, $infoExists = null, $infoRequired = null, $infoType = null, $transactionItemId = null)
    {
        $this
            ->setAlwaysPopupForm($alwaysPopupForm)
            ->setExtraData($extraData)
            ->setInfoExists($infoExists)
            ->setInfoRequired($infoRequired)
            ->setInfoType($infoType)
            ->setTransactionItemId($transactionItemId);
    }
    /**
     * Get AlwaysPopupForm value
     * @return bool|null
     */
    public function getAlwaysPopupForm()
    {
        return $this->AlwaysPopupForm;
    }
    /**
     * Set AlwaysPopupForm value
     * @param bool $alwaysPopupForm
     * @return \patest\StructType\TransactionCompletionMessage
     */
    public function setAlwaysPopupForm($alwaysPopupForm = null)
    {
        // validation for constraint: boolean
        if (!is_null($alwaysPopupForm) && !is_bool($alwaysPopupForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alwaysPopupForm, true), gettype($alwaysPopupForm)), __LINE__);
        }
        $this->AlwaysPopupForm = $alwaysPopupForm;
        return $this;
    }
    /**
     * Get ExtraData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getExtraData()
    {
        return isset($this->ExtraData) ? $this->ExtraData : null;
    }
    /**
     * Set ExtraData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData
     * @return \patest\StructType\TransactionCompletionMessage
     */
    public function setExtraData(\patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData = null)
    {
        if (is_null($extraData) || (is_array($extraData) && empty($extraData))) {
            unset($this->ExtraData);
        } else {
            $this->ExtraData = $extraData;
        }
        return $this;
    }
    /**
     * Get InfoExists value
     * @return bool|null
     */
    public function getInfoExists()
    {
        return $this->InfoExists;
    }
    /**
     * Set InfoExists value
     * @param bool $infoExists
     * @return \patest\StructType\TransactionCompletionMessage
     */
    public function setInfoExists($infoExists = null)
    {
        // validation for constraint: boolean
        if (!is_null($infoExists) && !is_bool($infoExists)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($infoExists, true), gettype($infoExists)), __LINE__);
        }
        $this->InfoExists = $infoExists;
        return $this;
    }
    /**
     * Get InfoRequired value
     * @return bool|null
     */
    public function getInfoRequired()
    {
        return $this->InfoRequired;
    }
    /**
     * Set InfoRequired value
     * @param bool $infoRequired
     * @return \patest\StructType\TransactionCompletionMessage
     */
    public function setInfoRequired($infoRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($infoRequired) && !is_bool($infoRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($infoRequired, true), gettype($infoRequired)), __LINE__);
        }
        $this->InfoRequired = $infoRequired;
        return $this;
    }
    /**
     * Get InfoType value
     * @return string|null
     */
    public function getInfoType()
    {
        return $this->InfoType;
    }
    /**
     * Set InfoType value
     * @uses \patest\EnumType\TransactionMessageInfoType::valueIsValid()
     * @uses \patest\EnumType\TransactionMessageInfoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $infoType
     * @return \patest\StructType\TransactionCompletionMessage
     */
    public function setInfoType($infoType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionMessageInfoType::valueIsValid($infoType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionMessageInfoType', is_array($infoType) ? implode(', ', $infoType) : var_export($infoType, true), implode(', ', \patest\EnumType\TransactionMessageInfoType::getValidValues())), __LINE__);
        }
        $this->InfoType = $infoType;
        return $this;
    }
    /**
     * Get TransactionItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionItemId()
    {
        return isset($this->TransactionItemId) ? $this->TransactionItemId : null;
    }
    /**
     * Set TransactionItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionItemId
     * @return \patest\StructType\TransactionCompletionMessage
     */
    public function setTransactionItemId($transactionItemId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionItemId) && !(is_int($transactionItemId) || ctype_digit($transactionItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionItemId, true), gettype($transactionItemId)), __LINE__);
        }
        if (is_null($transactionItemId) || (is_array($transactionItemId) && empty($transactionItemId))) {
            unset($this->TransactionItemId);
        } else {
            $this->TransactionItemId = $transactionItemId;
        }
        return $this;
    }
}
