<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TillShift StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TillShift
 * @subpackage Structs
 */
class TillShift extends AbstractStructBase
{
    /**
     * The HasOpenShift
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasOpenShift;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OldestOpenedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\DateTimeOffset
     */
    public $OldestOpenedDate;
    /**
     * The OpenShiftId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OpenShiftId;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ShiftGlobalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ShiftGlobalNumber;
    /**
     * The UserNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $UserNames;
    /**
     * Constructor method for TillShift
     * @uses TillShift::setHasOpenShift()
     * @uses TillShift::setId()
     * @uses TillShift::setName()
     * @uses TillShift::setOldestOpenedDate()
     * @uses TillShift::setOpenShiftId()
     * @uses TillShift::setOrganizationUnitId()
     * @uses TillShift::setShiftGlobalNumber()
     * @uses TillShift::setUserNames()
     * @param bool $hasOpenShift
     * @param string $id
     * @param string $name
     * @param \patest\StructType\DateTimeOffset $oldestOpenedDate
     * @param int $openShiftId
     * @param string $organizationUnitId
     * @param int $shiftGlobalNumber
     * @param \patest\ArrayType\ArrayOfstring $userNames
     */
    public function __construct($hasOpenShift = null, $id = null, $name = null, \patest\StructType\DateTimeOffset $oldestOpenedDate = null, $openShiftId = null, $organizationUnitId = null, $shiftGlobalNumber = null, \patest\ArrayType\ArrayOfstring $userNames = null)
    {
        $this
            ->setHasOpenShift($hasOpenShift)
            ->setId($id)
            ->setName($name)
            ->setOldestOpenedDate($oldestOpenedDate)
            ->setOpenShiftId($openShiftId)
            ->setOrganizationUnitId($organizationUnitId)
            ->setShiftGlobalNumber($shiftGlobalNumber)
            ->setUserNames($userNames);
    }
    /**
     * Get HasOpenShift value
     * @return bool|null
     */
    public function getHasOpenShift()
    {
        return $this->HasOpenShift;
    }
    /**
     * Set HasOpenShift value
     * @param bool $hasOpenShift
     * @return \patest\StructType\TillShift
     */
    public function setHasOpenShift($hasOpenShift = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasOpenShift) && !is_bool($hasOpenShift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasOpenShift, true), gettype($hasOpenShift)), __LINE__);
        }
        $this->HasOpenShift = $hasOpenShift;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\TillShift
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\TillShift
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OldestOpenedDate value
     * @return \patest\StructType\DateTimeOffset|null
     */
    public function getOldestOpenedDate()
    {
        return $this->OldestOpenedDate;
    }
    /**
     * Set OldestOpenedDate value
     * @param \patest\StructType\DateTimeOffset $oldestOpenedDate
     * @return \patest\StructType\TillShift
     */
    public function setOldestOpenedDate(\patest\StructType\DateTimeOffset $oldestOpenedDate = null)
    {
        $this->OldestOpenedDate = $oldestOpenedDate;
        return $this;
    }
    /**
     * Get OpenShiftId value
     * @return int|null
     */
    public function getOpenShiftId()
    {
        return $this->OpenShiftId;
    }
    /**
     * Set OpenShiftId value
     * @param int $openShiftId
     * @return \patest\StructType\TillShift
     */
    public function setOpenShiftId($openShiftId = null)
    {
        // validation for constraint: int
        if (!is_null($openShiftId) && !(is_int($openShiftId) || ctype_digit($openShiftId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($openShiftId, true), gettype($openShiftId)), __LINE__);
        }
        $this->OpenShiftId = $openShiftId;
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return $this->OrganizationUnitId;
    }
    /**
     * Set OrganizationUnitId value
     * @param string $organizationUnitId
     * @return \patest\StructType\TillShift
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        $this->OrganizationUnitId = $organizationUnitId;
        return $this;
    }
    /**
     * Get ShiftGlobalNumber value
     * @return int|null
     */
    public function getShiftGlobalNumber()
    {
        return $this->ShiftGlobalNumber;
    }
    /**
     * Set ShiftGlobalNumber value
     * @param int $shiftGlobalNumber
     * @return \patest\StructType\TillShift
     */
    public function setShiftGlobalNumber($shiftGlobalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($shiftGlobalNumber) && !(is_int($shiftGlobalNumber) || ctype_digit($shiftGlobalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shiftGlobalNumber, true), gettype($shiftGlobalNumber)), __LINE__);
        }
        $this->ShiftGlobalNumber = $shiftGlobalNumber;
        return $this;
    }
    /**
     * Get UserNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getUserNames()
    {
        return isset($this->UserNames) ? $this->UserNames : null;
    }
    /**
     * Set UserNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $userNames
     * @return \patest\StructType\TillShift
     */
    public function setUserNames(\patest\ArrayType\ArrayOfstring $userNames = null)
    {
        if (is_null($userNames) || (is_array($userNames) && empty($userNames))) {
            unset($this->UserNames);
        } else {
            $this->UserNames = $userNames;
        }
        return $this;
    }
}
