<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketsToReturn StructType
 * @subpackage Structs
 */
class Ticketing_TicketsToReturn extends AnyEntity
{
    /**
     * The AllItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllItems;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaSeatingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaSeatingType;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventPriceTypeGuids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventPriceTypeGuids;
    /**
     * The FromSeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromSeatName;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SectorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectorId;
    /**
     * The TicketsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketsCount;
    /**
     * The ToSeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToSeatName;
    /**
     * Constructor method for Ticketing.TicketsToReturn
     * @uses Ticketing_TicketsToReturn::setAllItems()
     * @uses Ticketing_TicketsToReturn::setAreaId()
     * @uses Ticketing_TicketsToReturn::setAreaSeatingType()
     * @uses Ticketing_TicketsToReturn::setClientId()
     * @uses Ticketing_TicketsToReturn::setEventId()
     * @uses Ticketing_TicketsToReturn::setEventPriceTypeGuids()
     * @uses Ticketing_TicketsToReturn::setFromSeatName()
     * @uses Ticketing_TicketsToReturn::setPriceTypeId()
     * @uses Ticketing_TicketsToReturn::setRowName()
     * @uses Ticketing_TicketsToReturn::setSectorId()
     * @uses Ticketing_TicketsToReturn::setTicketsCount()
     * @uses Ticketing_TicketsToReturn::setToSeatName()
     * @param string $allItems
     * @param string $areaId
     * @param string $areaSeatingType
     * @param string $clientId
     * @param string $eventId
     * @param string $eventPriceTypeGuids
     * @param string $fromSeatName
     * @param string $priceTypeId
     * @param string $rowName
     * @param string $sectorId
     * @param int $ticketsCount
     * @param string $toSeatName
     */
    public function __construct($allItems = null, $areaId = null, $areaSeatingType = null, $clientId = null, $eventId = null, $eventPriceTypeGuids = null, $fromSeatName = null, $priceTypeId = null, $rowName = null, $sectorId = null, $ticketsCount = null, $toSeatName = null)
    {
        $this
            ->setAllItems($allItems)
            ->setAreaId($areaId)
            ->setAreaSeatingType($areaSeatingType)
            ->setClientId($clientId)
            ->setEventId($eventId)
            ->setEventPriceTypeGuids($eventPriceTypeGuids)
            ->setFromSeatName($fromSeatName)
            ->setPriceTypeId($priceTypeId)
            ->setRowName($rowName)
            ->setSectorId($sectorId)
            ->setTicketsCount($ticketsCount)
            ->setToSeatName($toSeatName);
    }
    /**
     * Get AllItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllItems()
    {
        return isset($this->AllItems) ? $this->AllItems : null;
    }
    /**
     * Set AllItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allItems
     * @return \patest\StructType\Ticketing_TicketsToReturn
     */
    public function setAllItems($allItems = null)
    {
        // validation for constraint: string
        if (!is_null($allItems) && !is_string($allItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allItems, true), gettype($allItems)), __LINE__);
        }
        if (is_null($allItems) || (is_array($allItems) && empty($allItems))) {
            unset($this->AllItems);
        } else {
            $this->AllItems = $allItems;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_TicketsToReturn
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaSeatingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaSeatingType()
    {
        return isset($this->AreaSeatingType) ? $this->AreaSeatingType : null;
    }
    /**
     * Set AreaSeatingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaSeatingType::valueIsValid()
     * @uses \patest\EnumType\AreaSeatingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $areaSeatingType
     * @return \patest\StructType\Ticketing_TicketsToReturn
     */
    public function setAreaSeatingType($areaSeatingType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaSeatingType::valueIsValid($areaSeatingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaSeatingType', is_array($areaSeatingType) ? implode(', ', $areaSeatingType) : var_export($areaSeatingType, true), implode(', ', \patest\EnumType\AreaSeatingType::getValidValues())), __LINE__);
        }
        if (is_null($areaSeatingType) || (is_array($areaSeatingType) && empty($areaSeatingType))) {
            unset($this->AreaSeatingType);
        } else {
            $this->AreaSeatingType = $areaSeatingType;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_TicketsToReturn
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_TicketsToReturn
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get EventPriceTypeGuids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventPriceTypeGuids()
    {
        return isset($this->EventPriceTypeGuids) ? $this->EventPriceTypeGuids : null;
    }
    /**
     * Set EventPriceTypeGuids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventPriceTypeGuids
     * @return \patest\StructType\Ticketing_TicketsToReturn
     */
    public function setEventPriceTypeGuids($eventPriceTypeGuids = null)
    {
        // validation for constraint: string
        if (!is_null($eventPriceTypeGuids) && !is_string($eventPriceTypeGuids)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventPriceTypeGuids, true), gettype($eventPriceTypeGuids)), __LINE__);
        }
        if (is_null($eventPriceTypeGuids) || (is_array($eventPriceTypeGuids) && empty($eventPriceTypeGuids))) {
            unset($this->EventPriceTypeGuids);
        } else {
            $this->EventPriceTypeGuids = $eventPriceTypeGuids;
        }
        return $this;
    }
    /**
     * Get FromSeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromSeatName()
    {
        return isset($this->FromSeatName) ? $this->FromSeatName : null;
    }
    /**
     * Set FromSeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromSeatName
     * @return \patest\StructType\Ticketing_TicketsToReturn
     */
    public function setFromSeatName($fromSeatName = null)
    {
        // validation for constraint: string
        if (!is_null($fromSeatName) && !is_string($fromSeatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromSeatName, true), gettype($fromSeatName)), __LINE__);
        }
        if (is_null($fromSeatName) || (is_array($fromSeatName) && empty($fromSeatName))) {
            unset($this->FromSeatName);
        } else {
            $this->FromSeatName = $fromSeatName;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Ticketing_TicketsToReturn
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_TicketsToReturn
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorId()
    {
        return isset($this->SectorId) ? $this->SectorId : null;
    }
    /**
     * Set SectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorId
     * @return \patest\StructType\Ticketing_TicketsToReturn
     */
    public function setSectorId($sectorId = null)
    {
        // validation for constraint: string
        if (!is_null($sectorId) && !is_string($sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorId, true), gettype($sectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectorId, true)), __LINE__);
        }
        if (is_null($sectorId) || (is_array($sectorId) && empty($sectorId))) {
            unset($this->SectorId);
        } else {
            $this->SectorId = $sectorId;
        }
        return $this;
    }
    /**
     * Get TicketsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketsCount()
    {
        return isset($this->TicketsCount) ? $this->TicketsCount : null;
    }
    /**
     * Set TicketsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketsCount
     * @return \patest\StructType\Ticketing_TicketsToReturn
     */
    public function setTicketsCount($ticketsCount = null)
    {
        // validation for constraint: int
        if (!is_null($ticketsCount) && !(is_int($ticketsCount) || ctype_digit($ticketsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketsCount, true), gettype($ticketsCount)), __LINE__);
        }
        if (is_null($ticketsCount) || (is_array($ticketsCount) && empty($ticketsCount))) {
            unset($this->TicketsCount);
        } else {
            $this->TicketsCount = $ticketsCount;
        }
        return $this;
    }
    /**
     * Get ToSeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToSeatName()
    {
        return isset($this->ToSeatName) ? $this->ToSeatName : null;
    }
    /**
     * Set ToSeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toSeatName
     * @return \patest\StructType\Ticketing_TicketsToReturn
     */
    public function setToSeatName($toSeatName = null)
    {
        // validation for constraint: string
        if (!is_null($toSeatName) && !is_string($toSeatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toSeatName, true), gettype($toSeatName)), __LINE__);
        }
        if (is_null($toSeatName) || (is_array($toSeatName) && empty($toSeatName))) {
            unset($this->ToSeatName);
        } else {
            $this->ToSeatName = $toSeatName;
        }
        return $this;
    }
}
