<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketWithVersionsAndPurchasers StructType
 * @subpackage Structs
 */
class Ticketing_TicketWithVersionsAndPurchasers extends Ticketing_TicketWithVersions
{
    /**
     * The AreaReference
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaReference;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The PurchaserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserId;
    /**
     * The TicketViewConfigurationsEnabled
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TicketViewConfigurationsEnabled;
    /**
     * The TicketViewConfigurationsTesterClientType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketViewConfigurationsTesterClientType;
    /**
     * The TotalActualPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalActualPayment;
    /**
     * The TotalTransactionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalTransactionValue;
    /**
     * Constructor method for Ticketing.TicketWithVersionsAndPurchasers
     * @uses Ticketing_TicketWithVersionsAndPurchasers::setAreaReference()
     * @uses Ticketing_TicketWithVersionsAndPurchasers::setHallVersionId()
     * @uses Ticketing_TicketWithVersionsAndPurchasers::setPurchaserId()
     * @uses Ticketing_TicketWithVersionsAndPurchasers::setTicketViewConfigurationsEnabled()
     * @uses Ticketing_TicketWithVersionsAndPurchasers::setTicketViewConfigurationsTesterClientType()
     * @uses Ticketing_TicketWithVersionsAndPurchasers::setTotalActualPayment()
     * @uses Ticketing_TicketWithVersionsAndPurchasers::setTotalTransactionValue()
     * @param string $areaReference
     * @param string $hallVersionId
     * @param string $purchaserId
     * @param bool $ticketViewConfigurationsEnabled
     * @param string $ticketViewConfigurationsTesterClientType
     * @param \patest\StructType\Money $totalActualPayment
     * @param \patest\StructType\Money $totalTransactionValue
     */
    public function __construct($areaReference = null, $hallVersionId = null, $purchaserId = null, $ticketViewConfigurationsEnabled = null, $ticketViewConfigurationsTesterClientType = null, \patest\StructType\Money $totalActualPayment = null, \patest\StructType\Money $totalTransactionValue = null)
    {
        $this
            ->setAreaReference($areaReference)
            ->setHallVersionId($hallVersionId)
            ->setPurchaserId($purchaserId)
            ->setTicketViewConfigurationsEnabled($ticketViewConfigurationsEnabled)
            ->setTicketViewConfigurationsTesterClientType($ticketViewConfigurationsTesterClientType)
            ->setTotalActualPayment($totalActualPayment)
            ->setTotalTransactionValue($totalTransactionValue);
    }
    /**
     * Get AreaReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaReference()
    {
        return isset($this->AreaReference) ? $this->AreaReference : null;
    }
    /**
     * Set AreaReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaReference
     * @return \patest\StructType\Ticketing_TicketWithVersionsAndPurchasers
     */
    public function setAreaReference($areaReference = null)
    {
        // validation for constraint: string
        if (!is_null($areaReference) && !is_string($areaReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaReference, true), gettype($areaReference)), __LINE__);
        }
        if (is_null($areaReference) || (is_array($areaReference) && empty($areaReference))) {
            unset($this->AreaReference);
        } else {
            $this->AreaReference = $areaReference;
        }
        return $this;
    }
    /**
     * Get HallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionId()
    {
        return isset($this->HallVersionId) ? $this->HallVersionId : null;
    }
    /**
     * Set HallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionId
     * @return \patest\StructType\Ticketing_TicketWithVersionsAndPurchasers
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        if (is_null($hallVersionId) || (is_array($hallVersionId) && empty($hallVersionId))) {
            unset($this->HallVersionId);
        } else {
            $this->HallVersionId = $hallVersionId;
        }
        return $this;
    }
    /**
     * Get PurchaserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserId()
    {
        return isset($this->PurchaserId) ? $this->PurchaserId : null;
    }
    /**
     * Set PurchaserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserId
     * @return \patest\StructType\Ticketing_TicketWithVersionsAndPurchasers
     */
    public function setPurchaserId($purchaserId = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserId) && !is_string($purchaserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserId, true), gettype($purchaserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserId, true)), __LINE__);
        }
        if (is_null($purchaserId) || (is_array($purchaserId) && empty($purchaserId))) {
            unset($this->PurchaserId);
        } else {
            $this->PurchaserId = $purchaserId;
        }
        return $this;
    }
    /**
     * Get TicketViewConfigurationsEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTicketViewConfigurationsEnabled()
    {
        return isset($this->TicketViewConfigurationsEnabled) ? $this->TicketViewConfigurationsEnabled : null;
    }
    /**
     * Set TicketViewConfigurationsEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ticketViewConfigurationsEnabled
     * @return \patest\StructType\Ticketing_TicketWithVersionsAndPurchasers
     */
    public function setTicketViewConfigurationsEnabled($ticketViewConfigurationsEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($ticketViewConfigurationsEnabled) && !is_bool($ticketViewConfigurationsEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ticketViewConfigurationsEnabled, true), gettype($ticketViewConfigurationsEnabled)), __LINE__);
        }
        if (is_null($ticketViewConfigurationsEnabled) || (is_array($ticketViewConfigurationsEnabled) && empty($ticketViewConfigurationsEnabled))) {
            unset($this->TicketViewConfigurationsEnabled);
        } else {
            $this->TicketViewConfigurationsEnabled = $ticketViewConfigurationsEnabled;
        }
        return $this;
    }
    /**
     * Get TicketViewConfigurationsTesterClientType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketViewConfigurationsTesterClientType()
    {
        return isset($this->TicketViewConfigurationsTesterClientType) ? $this->TicketViewConfigurationsTesterClientType : null;
    }
    /**
     * Set TicketViewConfigurationsTesterClientType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketViewConfigurationsTesterClientType
     * @return \patest\StructType\Ticketing_TicketWithVersionsAndPurchasers
     */
    public function setTicketViewConfigurationsTesterClientType($ticketViewConfigurationsTesterClientType = null)
    {
        // validation for constraint: string
        if (!is_null($ticketViewConfigurationsTesterClientType) && !is_string($ticketViewConfigurationsTesterClientType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketViewConfigurationsTesterClientType, true), gettype($ticketViewConfigurationsTesterClientType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketViewConfigurationsTesterClientType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketViewConfigurationsTesterClientType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketViewConfigurationsTesterClientType, true)), __LINE__);
        }
        if (is_null($ticketViewConfigurationsTesterClientType) || (is_array($ticketViewConfigurationsTesterClientType) && empty($ticketViewConfigurationsTesterClientType))) {
            unset($this->TicketViewConfigurationsTesterClientType);
        } else {
            $this->TicketViewConfigurationsTesterClientType = $ticketViewConfigurationsTesterClientType;
        }
        return $this;
    }
    /**
     * Get TotalActualPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalActualPayment()
    {
        return isset($this->TotalActualPayment) ? $this->TotalActualPayment : null;
    }
    /**
     * Set TotalActualPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalActualPayment
     * @return \patest\StructType\Ticketing_TicketWithVersionsAndPurchasers
     */
    public function setTotalActualPayment(\patest\StructType\Money $totalActualPayment = null)
    {
        if (is_null($totalActualPayment) || (is_array($totalActualPayment) && empty($totalActualPayment))) {
            unset($this->TotalActualPayment);
        } else {
            $this->TotalActualPayment = $totalActualPayment;
        }
        return $this;
    }
    /**
     * Get TotalTransactionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalTransactionValue()
    {
        return isset($this->TotalTransactionValue) ? $this->TotalTransactionValue : null;
    }
    /**
     * Set TotalTransactionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalTransactionValue
     * @return \patest\StructType\Ticketing_TicketWithVersionsAndPurchasers
     */
    public function setTotalTransactionValue(\patest\StructType\Money $totalTransactionValue = null)
    {
        if (is_null($totalTransactionValue) || (is_array($totalTransactionValue) && empty($totalTransactionValue))) {
            unset($this->TotalTransactionValue);
        } else {
            $this->TotalTransactionValue = $totalTransactionValue;
        }
        return $this;
    }
}
