<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketViewTemplateAssociation StructType
 * @subpackage Structs
 */
class Ticketing_TicketViewTemplateAssociation extends PersistableEntity
{
    /**
     * The ApplicationLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationLevel;
    /**
     * The ApplicationObjectIdentifier
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ApplicationObjectIdentifier;
    /**
     * The ComponentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComponentType;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The Criteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Criteria;
    /**
     * The Criterion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_TicketViewTemplateAssociationCriteria
     */
    public $Criterion;
    /**
     * The GeneratedBy
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GeneratedBy;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHidden;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The StaffTesterOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $StaffTesterOnly;
    /**
     * The TicketViewComponent
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_TicketViewComponent
     */
    public $TicketViewComponent;
    /**
     * The TicketViewComponentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketViewComponentId;
    /**
     * Constructor method for Ticketing.TicketViewTemplateAssociation
     * @uses Ticketing_TicketViewTemplateAssociation::setApplicationLevel()
     * @uses Ticketing_TicketViewTemplateAssociation::setApplicationObjectIdentifier()
     * @uses Ticketing_TicketViewTemplateAssociation::setComponentType()
     * @uses Ticketing_TicketViewTemplateAssociation::setCreationDateTime()
     * @uses Ticketing_TicketViewTemplateAssociation::setCriteria()
     * @uses Ticketing_TicketViewTemplateAssociation::setCriterion()
     * @uses Ticketing_TicketViewTemplateAssociation::setGeneratedBy()
     * @uses Ticketing_TicketViewTemplateAssociation::setIsActive()
     * @uses Ticketing_TicketViewTemplateAssociation::setIsHidden()
     * @uses Ticketing_TicketViewTemplateAssociation::setLastUpdateDateTime()
     * @uses Ticketing_TicketViewTemplateAssociation::setName()
     * @uses Ticketing_TicketViewTemplateAssociation::setPriority()
     * @uses Ticketing_TicketViewTemplateAssociation::setStaffTesterOnly()
     * @uses Ticketing_TicketViewTemplateAssociation::setTicketViewComponent()
     * @uses Ticketing_TicketViewTemplateAssociation::setTicketViewComponentId()
     * @param string $applicationLevel
     * @param string $applicationObjectIdentifier
     * @param string $componentType
     * @param string $creationDateTime
     * @param string $criteria
     * @param \patest\StructType\RecordSetOfTicketing_TicketViewTemplateAssociationCriteria $criterion
     * @param string $generatedBy
     * @param bool $isActive
     * @param bool $isHidden
     * @param string $lastUpdateDateTime
     * @param string $name
     * @param int $priority
     * @param bool $staffTesterOnly
     * @param \patest\StructType\Ticketing_TicketViewComponent $ticketViewComponent
     * @param string $ticketViewComponentId
     */
    public function __construct($applicationLevel = null, $applicationObjectIdentifier = null, $componentType = null, $creationDateTime = null, $criteria = null, \patest\StructType\RecordSetOfTicketing_TicketViewTemplateAssociationCriteria $criterion = null, $generatedBy = null, $isActive = null, $isHidden = null, $lastUpdateDateTime = null, $name = null, $priority = null, $staffTesterOnly = null, \patest\StructType\Ticketing_TicketViewComponent $ticketViewComponent = null, $ticketViewComponentId = null)
    {
        $this
            ->setApplicationLevel($applicationLevel)
            ->setApplicationObjectIdentifier($applicationObjectIdentifier)
            ->setComponentType($componentType)
            ->setCreationDateTime($creationDateTime)
            ->setCriteria($criteria)
            ->setCriterion($criterion)
            ->setGeneratedBy($generatedBy)
            ->setIsActive($isActive)
            ->setIsHidden($isHidden)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setName($name)
            ->setPriority($priority)
            ->setStaffTesterOnly($staffTesterOnly)
            ->setTicketViewComponent($ticketViewComponent)
            ->setTicketViewComponentId($ticketViewComponentId);
    }
    /**
     * Get ApplicationLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationLevel()
    {
        return isset($this->ApplicationLevel) ? $this->ApplicationLevel : null;
    }
    /**
     * Set ApplicationLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketConfigurationApplicationLevel::valueIsValid()
     * @uses \patest\EnumType\TicketConfigurationApplicationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $applicationLevel
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setApplicationLevel($applicationLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketConfigurationApplicationLevel::valueIsValid($applicationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketConfigurationApplicationLevel', is_array($applicationLevel) ? implode(', ', $applicationLevel) : var_export($applicationLevel, true), implode(', ', \patest\EnumType\TicketConfigurationApplicationLevel::getValidValues())), __LINE__);
        }
        if (is_null($applicationLevel) || (is_array($applicationLevel) && empty($applicationLevel))) {
            unset($this->ApplicationLevel);
        } else {
            $this->ApplicationLevel = $applicationLevel;
        }
        return $this;
    }
    /**
     * Get ApplicationObjectIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationObjectIdentifier()
    {
        return isset($this->ApplicationObjectIdentifier) ? $this->ApplicationObjectIdentifier : null;
    }
    /**
     * Set ApplicationObjectIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationObjectIdentifier
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setApplicationObjectIdentifier($applicationObjectIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($applicationObjectIdentifier) && !is_string($applicationObjectIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationObjectIdentifier, true), gettype($applicationObjectIdentifier)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($applicationObjectIdentifier) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $applicationObjectIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($applicationObjectIdentifier, true)), __LINE__);
        }
        if (is_null($applicationObjectIdentifier) || (is_array($applicationObjectIdentifier) && empty($applicationObjectIdentifier))) {
            unset($this->ApplicationObjectIdentifier);
        } else {
            $this->ApplicationObjectIdentifier = $applicationObjectIdentifier;
        }
        return $this;
    }
    /**
     * Get ComponentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComponentType()
    {
        return isset($this->ComponentType) ? $this->ComponentType : null;
    }
    /**
     * Set ComponentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketConfigurationComponentType::valueIsValid()
     * @uses \patest\EnumType\TicketConfigurationComponentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $componentType
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setComponentType($componentType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketConfigurationComponentType::valueIsValid($componentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketConfigurationComponentType', is_array($componentType) ? implode(', ', $componentType) : var_export($componentType, true), implode(', ', \patest\EnumType\TicketConfigurationComponentType::getValidValues())), __LINE__);
        }
        if (is_null($componentType) || (is_array($componentType) && empty($componentType))) {
            unset($this->ComponentType);
        } else {
            $this->ComponentType = $componentType;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get Criteria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCriteria()
    {
        return isset($this->Criteria) ? $this->Criteria : null;
    }
    /**
     * Set Criteria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $criteria
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setCriteria($criteria = null)
    {
        // validation for constraint: string
        if (!is_null($criteria) && !is_string($criteria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($criteria, true), gettype($criteria)), __LINE__);
        }
        if (is_null($criteria) || (is_array($criteria) && empty($criteria))) {
            unset($this->Criteria);
        } else {
            $this->Criteria = $criteria;
        }
        return $this;
    }
    /**
     * Get Criterion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_TicketViewTemplateAssociationCriteria|null
     */
    public function getCriterion()
    {
        return isset($this->Criterion) ? $this->Criterion : null;
    }
    /**
     * Set Criterion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_TicketViewTemplateAssociationCriteria $criterion
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setCriterion(\patest\StructType\RecordSetOfTicketing_TicketViewTemplateAssociationCriteria $criterion = null)
    {
        if (is_null($criterion) || (is_array($criterion) && empty($criterion))) {
            unset($this->Criterion);
        } else {
            $this->Criterion = $criterion;
        }
        return $this;
    }
    /**
     * Get GeneratedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeneratedBy()
    {
        return isset($this->GeneratedBy) ? $this->GeneratedBy : null;
    }
    /**
     * Set GeneratedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generatedBy
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setGeneratedBy($generatedBy = null)
    {
        // validation for constraint: string
        if (!is_null($generatedBy) && !is_string($generatedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generatedBy, true), gettype($generatedBy)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($generatedBy) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $generatedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($generatedBy, true)), __LINE__);
        }
        if (is_null($generatedBy) || (is_array($generatedBy) && empty($generatedBy))) {
            unset($this->GeneratedBy);
        } else {
            $this->GeneratedBy = $generatedBy;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsHidden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHidden()
    {
        return isset($this->IsHidden) ? $this->IsHidden : null;
    }
    /**
     * Set IsHidden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHidden
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHidden) && !is_bool($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHidden, true), gettype($isHidden)), __LINE__);
        }
        if (is_null($isHidden) || (is_array($isHidden) && empty($isHidden))) {
            unset($this->IsHidden);
        } else {
            $this->IsHidden = $isHidden;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get StaffTesterOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getStaffTesterOnly()
    {
        return isset($this->StaffTesterOnly) ? $this->StaffTesterOnly : null;
    }
    /**
     * Set StaffTesterOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $staffTesterOnly
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setStaffTesterOnly($staffTesterOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($staffTesterOnly) && !is_bool($staffTesterOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($staffTesterOnly, true), gettype($staffTesterOnly)), __LINE__);
        }
        if (is_null($staffTesterOnly) || (is_array($staffTesterOnly) && empty($staffTesterOnly))) {
            unset($this->StaffTesterOnly);
        } else {
            $this->StaffTesterOnly = $staffTesterOnly;
        }
        return $this;
    }
    /**
     * Get TicketViewComponent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_TicketViewComponent|null
     */
    public function getTicketViewComponent()
    {
        return isset($this->TicketViewComponent) ? $this->TicketViewComponent : null;
    }
    /**
     * Set TicketViewComponent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_TicketViewComponent $ticketViewComponent
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setTicketViewComponent(\patest\StructType\Ticketing_TicketViewComponent $ticketViewComponent = null)
    {
        if (is_null($ticketViewComponent) || (is_array($ticketViewComponent) && empty($ticketViewComponent))) {
            unset($this->TicketViewComponent);
        } else {
            $this->TicketViewComponent = $ticketViewComponent;
        }
        return $this;
    }
    /**
     * Get TicketViewComponentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketViewComponentId()
    {
        return isset($this->TicketViewComponentId) ? $this->TicketViewComponentId : null;
    }
    /**
     * Set TicketViewComponentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketViewComponentId
     * @return \patest\StructType\Ticketing_TicketViewTemplateAssociation
     */
    public function setTicketViewComponentId($ticketViewComponentId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketViewComponentId) && !is_string($ticketViewComponentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketViewComponentId, true), gettype($ticketViewComponentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketViewComponentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketViewComponentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketViewComponentId, true)), __LINE__);
        }
        if (is_null($ticketViewComponentId) || (is_array($ticketViewComponentId) && empty($ticketViewComponentId))) {
            unset($this->TicketViewComponentId);
        } else {
            $this->TicketViewComponentId = $ticketViewComponentId;
        }
        return $this;
    }
}
