<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketSchemeFulfillmentFilter StructType
 * @subpackage Structs
 */
class Ticketing_TicketSchemeFulfillmentFilter extends FilterEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The FulfillmentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FulfillmentDate;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SubscriptionNumber;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The ViewErrorsOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ViewErrorsOnly;
    /**
     * Constructor method for Ticketing.TicketSchemeFulfillmentFilter
     * @uses Ticketing_TicketSchemeFulfillmentFilter::setClientId()
     * @uses Ticketing_TicketSchemeFulfillmentFilter::setFulfillmentDate()
     * @uses Ticketing_TicketSchemeFulfillmentFilter::setPaymentMethodId()
     * @uses Ticketing_TicketSchemeFulfillmentFilter::setRemark()
     * @uses Ticketing_TicketSchemeFulfillmentFilter::setState()
     * @uses Ticketing_TicketSchemeFulfillmentFilter::setSubscriptionNumber()
     * @uses Ticketing_TicketSchemeFulfillmentFilter::setTransactionNumber()
     * @uses Ticketing_TicketSchemeFulfillmentFilter::setViewErrorsOnly()
     * @param string $clientId
     * @param string $fulfillmentDate
     * @param string $paymentMethodId
     * @param string $remark
     * @param string $state
     * @param int $subscriptionNumber
     * @param int $transactionNumber
     * @param bool $viewErrorsOnly
     */
    public function __construct($clientId = null, $fulfillmentDate = null, $paymentMethodId = null, $remark = null, $state = null, $subscriptionNumber = null, $transactionNumber = null, $viewErrorsOnly = null)
    {
        $this
            ->setClientId($clientId)
            ->setFulfillmentDate($fulfillmentDate)
            ->setPaymentMethodId($paymentMethodId)
            ->setRemark($remark)
            ->setState($state)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setTransactionNumber($transactionNumber)
            ->setViewErrorsOnly($viewErrorsOnly);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_TicketSchemeFulfillmentFilter
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get FulfillmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFulfillmentDate()
    {
        return isset($this->FulfillmentDate) ? $this->FulfillmentDate : null;
    }
    /**
     * Set FulfillmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fulfillmentDate
     * @return \patest\StructType\Ticketing_TicketSchemeFulfillmentFilter
     */
    public function setFulfillmentDate($fulfillmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($fulfillmentDate) && !is_string($fulfillmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fulfillmentDate, true), gettype($fulfillmentDate)), __LINE__);
        }
        if (is_null($fulfillmentDate) || (is_array($fulfillmentDate) && empty($fulfillmentDate))) {
            unset($this->FulfillmentDate);
        } else {
            $this->FulfillmentDate = $fulfillmentDate;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Ticketing_TicketSchemeFulfillmentFilter
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \patest\StructType\Ticketing_TicketSchemeFulfillmentFilter
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \patest\StructType\Ticketing_TicketSchemeFulfillmentFilter
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $subscriptionNumber
     * @return \patest\StructType\Ticketing_TicketSchemeFulfillmentFilter
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($subscriptionNumber) && !(is_int($subscriptionNumber) || ctype_digit($subscriptionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Ticketing_TicketSchemeFulfillmentFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get ViewErrorsOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getViewErrorsOnly()
    {
        return isset($this->ViewErrorsOnly) ? $this->ViewErrorsOnly : null;
    }
    /**
     * Set ViewErrorsOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $viewErrorsOnly
     * @return \patest\StructType\Ticketing_TicketSchemeFulfillmentFilter
     */
    public function setViewErrorsOnly($viewErrorsOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($viewErrorsOnly) && !is_bool($viewErrorsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($viewErrorsOnly, true), gettype($viewErrorsOnly)), __LINE__);
        }
        if (is_null($viewErrorsOnly) || (is_array($viewErrorsOnly) && empty($viewErrorsOnly))) {
            unset($this->ViewErrorsOnly);
        } else {
            $this->ViewErrorsOnly = $viewErrorsOnly;
        }
        return $this;
    }
}
