<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketResaleRequest StructType
 * @subpackage Structs
 */
class Ticketing_TicketResaleRequest extends DistributableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DestinationClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DestinationClientId;
    /**
     * The DestinationClientInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationClientInfo;
    /**
     * The DestinationClientInfoKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationClientInfoKind;
    /**
     * The ExternalOriginator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalOriginator;
    /**
     * The IsObsolete
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsObsolete;
    /**
     * The LastNewTicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastNewTicketId;
    /**
     * The NewTicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewTicketId;
    /**
     * The NewVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewVersionId;
    /**
     * The OriginalVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalVersionId;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTokenId;
    /**
     * The RefundAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RefundAmount;
    /**
     * The RefundDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefundDate;
    /**
     * The RefundReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefundReferenceNumber;
    /**
     * The RequestCanceledByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestCanceledByUserId;
    /**
     * The RequestCreatedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestCreatedByUserId;
    /**
     * The RequestDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestDate;
    /**
     * The RequestedPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RequestedPrice;
    /**
     * The RequestGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestGroupId;
    /**
     * The ResaleFee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ResaleFee;
    /**
     * The ResaleMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleMethod;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The StatusDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusDetails;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for Ticketing.TicketResaleRequest
     * @uses Ticketing_TicketResaleRequest::setClientId()
     * @uses Ticketing_TicketResaleRequest::setDestinationClientId()
     * @uses Ticketing_TicketResaleRequest::setDestinationClientInfo()
     * @uses Ticketing_TicketResaleRequest::setDestinationClientInfoKind()
     * @uses Ticketing_TicketResaleRequest::setExternalOriginator()
     * @uses Ticketing_TicketResaleRequest::setIsObsolete()
     * @uses Ticketing_TicketResaleRequest::setLastNewTicketId()
     * @uses Ticketing_TicketResaleRequest::setNewTicketId()
     * @uses Ticketing_TicketResaleRequest::setNewVersionId()
     * @uses Ticketing_TicketResaleRequest::setOriginalVersionId()
     * @uses Ticketing_TicketResaleRequest::setPaymentMethodId()
     * @uses Ticketing_TicketResaleRequest::setPaymentTokenId()
     * @uses Ticketing_TicketResaleRequest::setRefundAmount()
     * @uses Ticketing_TicketResaleRequest::setRefundDate()
     * @uses Ticketing_TicketResaleRequest::setRefundReferenceNumber()
     * @uses Ticketing_TicketResaleRequest::setRequestCanceledByUserId()
     * @uses Ticketing_TicketResaleRequest::setRequestCreatedByUserId()
     * @uses Ticketing_TicketResaleRequest::setRequestDate()
     * @uses Ticketing_TicketResaleRequest::setRequestedPrice()
     * @uses Ticketing_TicketResaleRequest::setRequestGroupId()
     * @uses Ticketing_TicketResaleRequest::setResaleFee()
     * @uses Ticketing_TicketResaleRequest::setResaleMethod()
     * @uses Ticketing_TicketResaleRequest::setStatus()
     * @uses Ticketing_TicketResaleRequest::setStatusDetails()
     * @uses Ticketing_TicketResaleRequest::setTicketId()
     * @param string $clientId
     * @param string $destinationClientId
     * @param string $destinationClientInfo
     * @param string $destinationClientInfoKind
     * @param string $externalOriginator
     * @param bool $isObsolete
     * @param string $lastNewTicketId
     * @param string $newTicketId
     * @param string $newVersionId
     * @param string $originalVersionId
     * @param string $paymentMethodId
     * @param string $paymentTokenId
     * @param \patest\StructType\Money $refundAmount
     * @param string $refundDate
     * @param string $refundReferenceNumber
     * @param string $requestCanceledByUserId
     * @param string $requestCreatedByUserId
     * @param string $requestDate
     * @param \patest\StructType\Money $requestedPrice
     * @param string $requestGroupId
     * @param \patest\StructType\Money $resaleFee
     * @param string $resaleMethod
     * @param string $status
     * @param string $statusDetails
     * @param string $ticketId
     */
    public function __construct($clientId = null, $destinationClientId = null, $destinationClientInfo = null, $destinationClientInfoKind = null, $externalOriginator = null, $isObsolete = null, $lastNewTicketId = null, $newTicketId = null, $newVersionId = null, $originalVersionId = null, $paymentMethodId = null, $paymentTokenId = null, \patest\StructType\Money $refundAmount = null, $refundDate = null, $refundReferenceNumber = null, $requestCanceledByUserId = null, $requestCreatedByUserId = null, $requestDate = null, \patest\StructType\Money $requestedPrice = null, $requestGroupId = null, \patest\StructType\Money $resaleFee = null, $resaleMethod = null, $status = null, $statusDetails = null, $ticketId = null)
    {
        $this
            ->setClientId($clientId)
            ->setDestinationClientId($destinationClientId)
            ->setDestinationClientInfo($destinationClientInfo)
            ->setDestinationClientInfoKind($destinationClientInfoKind)
            ->setExternalOriginator($externalOriginator)
            ->setIsObsolete($isObsolete)
            ->setLastNewTicketId($lastNewTicketId)
            ->setNewTicketId($newTicketId)
            ->setNewVersionId($newVersionId)
            ->setOriginalVersionId($originalVersionId)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentTokenId($paymentTokenId)
            ->setRefundAmount($refundAmount)
            ->setRefundDate($refundDate)
            ->setRefundReferenceNumber($refundReferenceNumber)
            ->setRequestCanceledByUserId($requestCanceledByUserId)
            ->setRequestCreatedByUserId($requestCreatedByUserId)
            ->setRequestDate($requestDate)
            ->setRequestedPrice($requestedPrice)
            ->setRequestGroupId($requestGroupId)
            ->setResaleFee($resaleFee)
            ->setResaleMethod($resaleMethod)
            ->setStatus($status)
            ->setStatusDetails($statusDetails)
            ->setTicketId($ticketId);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DestinationClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationClientId()
    {
        return isset($this->DestinationClientId) ? $this->DestinationClientId : null;
    }
    /**
     * Set DestinationClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationClientId
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setDestinationClientId($destinationClientId = null)
    {
        // validation for constraint: string
        if (!is_null($destinationClientId) && !is_string($destinationClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationClientId, true), gettype($destinationClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($destinationClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $destinationClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($destinationClientId, true)), __LINE__);
        }
        if (is_null($destinationClientId) || (is_array($destinationClientId) && empty($destinationClientId))) {
            unset($this->DestinationClientId);
        } else {
            $this->DestinationClientId = $destinationClientId;
        }
        return $this;
    }
    /**
     * Get DestinationClientInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationClientInfo()
    {
        return isset($this->DestinationClientInfo) ? $this->DestinationClientInfo : null;
    }
    /**
     * Set DestinationClientInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationClientInfo
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setDestinationClientInfo($destinationClientInfo = null)
    {
        // validation for constraint: string
        if (!is_null($destinationClientInfo) && !is_string($destinationClientInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationClientInfo, true), gettype($destinationClientInfo)), __LINE__);
        }
        if (is_null($destinationClientInfo) || (is_array($destinationClientInfo) && empty($destinationClientInfo))) {
            unset($this->DestinationClientInfo);
        } else {
            $this->DestinationClientInfo = $destinationClientInfo;
        }
        return $this;
    }
    /**
     * Get DestinationClientInfoKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationClientInfoKind()
    {
        return isset($this->DestinationClientInfoKind) ? $this->DestinationClientInfoKind : null;
    }
    /**
     * Set DestinationClientInfoKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PendingTransferClientInfoKind::valueIsValid()
     * @uses \patest\EnumType\PendingTransferClientInfoKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $destinationClientInfoKind
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setDestinationClientInfoKind($destinationClientInfoKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PendingTransferClientInfoKind::valueIsValid($destinationClientInfoKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PendingTransferClientInfoKind', is_array($destinationClientInfoKind) ? implode(', ', $destinationClientInfoKind) : var_export($destinationClientInfoKind, true), implode(', ', \patest\EnumType\PendingTransferClientInfoKind::getValidValues())), __LINE__);
        }
        if (is_null($destinationClientInfoKind) || (is_array($destinationClientInfoKind) && empty($destinationClientInfoKind))) {
            unset($this->DestinationClientInfoKind);
        } else {
            $this->DestinationClientInfoKind = $destinationClientInfoKind;
        }
        return $this;
    }
    /**
     * Get ExternalOriginator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalOriginator()
    {
        return isset($this->ExternalOriginator) ? $this->ExternalOriginator : null;
    }
    /**
     * Set ExternalOriginator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalOriginator
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setExternalOriginator($externalOriginator = null)
    {
        // validation for constraint: string
        if (!is_null($externalOriginator) && !is_string($externalOriginator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalOriginator, true), gettype($externalOriginator)), __LINE__);
        }
        if (is_null($externalOriginator) || (is_array($externalOriginator) && empty($externalOriginator))) {
            unset($this->ExternalOriginator);
        } else {
            $this->ExternalOriginator = $externalOriginator;
        }
        return $this;
    }
    /**
     * Get IsObsolete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsObsolete()
    {
        return isset($this->IsObsolete) ? $this->IsObsolete : null;
    }
    /**
     * Set IsObsolete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isObsolete
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setIsObsolete($isObsolete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isObsolete) && !is_bool($isObsolete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isObsolete, true), gettype($isObsolete)), __LINE__);
        }
        if (is_null($isObsolete) || (is_array($isObsolete) && empty($isObsolete))) {
            unset($this->IsObsolete);
        } else {
            $this->IsObsolete = $isObsolete;
        }
        return $this;
    }
    /**
     * Get LastNewTicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastNewTicketId()
    {
        return isset($this->LastNewTicketId) ? $this->LastNewTicketId : null;
    }
    /**
     * Set LastNewTicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastNewTicketId
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setLastNewTicketId($lastNewTicketId = null)
    {
        // validation for constraint: string
        if (!is_null($lastNewTicketId) && !is_string($lastNewTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastNewTicketId, true), gettype($lastNewTicketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lastNewTicketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastNewTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lastNewTicketId, true)), __LINE__);
        }
        if (is_null($lastNewTicketId) || (is_array($lastNewTicketId) && empty($lastNewTicketId))) {
            unset($this->LastNewTicketId);
        } else {
            $this->LastNewTicketId = $lastNewTicketId;
        }
        return $this;
    }
    /**
     * Get NewTicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewTicketId()
    {
        return isset($this->NewTicketId) ? $this->NewTicketId : null;
    }
    /**
     * Set NewTicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newTicketId
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setNewTicketId($newTicketId = null)
    {
        // validation for constraint: string
        if (!is_null($newTicketId) && !is_string($newTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newTicketId, true), gettype($newTicketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newTicketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newTicketId, true)), __LINE__);
        }
        if (is_null($newTicketId) || (is_array($newTicketId) && empty($newTicketId))) {
            unset($this->NewTicketId);
        } else {
            $this->NewTicketId = $newTicketId;
        }
        return $this;
    }
    /**
     * Get NewVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewVersionId()
    {
        return isset($this->NewVersionId) ? $this->NewVersionId : null;
    }
    /**
     * Set NewVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newVersionId
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setNewVersionId($newVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($newVersionId) && !is_string($newVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newVersionId, true), gettype($newVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newVersionId, true)), __LINE__);
        }
        if (is_null($newVersionId) || (is_array($newVersionId) && empty($newVersionId))) {
            unset($this->NewVersionId);
        } else {
            $this->NewVersionId = $newVersionId;
        }
        return $this;
    }
    /**
     * Get OriginalVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalVersionId()
    {
        return isset($this->OriginalVersionId) ? $this->OriginalVersionId : null;
    }
    /**
     * Set OriginalVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalVersionId
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setOriginalVersionId($originalVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($originalVersionId) && !is_string($originalVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalVersionId, true), gettype($originalVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalVersionId, true)), __LINE__);
        }
        if (is_null($originalVersionId) || (is_array($originalVersionId) && empty($originalVersionId))) {
            unset($this->OriginalVersionId);
        } else {
            $this->OriginalVersionId = $originalVersionId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenId()
    {
        return isset($this->PaymentTokenId) ? $this->PaymentTokenId : null;
    }
    /**
     * Set PaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenId
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setPaymentTokenId($paymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenId) && !is_string($paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenId, true), gettype($paymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTokenId, true)), __LINE__);
        }
        if (is_null($paymentTokenId) || (is_array($paymentTokenId) && empty($paymentTokenId))) {
            unset($this->PaymentTokenId);
        } else {
            $this->PaymentTokenId = $paymentTokenId;
        }
        return $this;
    }
    /**
     * Get RefundAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRefundAmount()
    {
        return isset($this->RefundAmount) ? $this->RefundAmount : null;
    }
    /**
     * Set RefundAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $refundAmount
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setRefundAmount(\patest\StructType\Money $refundAmount = null)
    {
        if (is_null($refundAmount) || (is_array($refundAmount) && empty($refundAmount))) {
            unset($this->RefundAmount);
        } else {
            $this->RefundAmount = $refundAmount;
        }
        return $this;
    }
    /**
     * Get RefundDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefundDate()
    {
        return isset($this->RefundDate) ? $this->RefundDate : null;
    }
    /**
     * Set RefundDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refundDate
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setRefundDate($refundDate = null)
    {
        // validation for constraint: string
        if (!is_null($refundDate) && !is_string($refundDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refundDate, true), gettype($refundDate)), __LINE__);
        }
        if (is_null($refundDate) || (is_array($refundDate) && empty($refundDate))) {
            unset($this->RefundDate);
        } else {
            $this->RefundDate = $refundDate;
        }
        return $this;
    }
    /**
     * Get RefundReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefundReferenceNumber()
    {
        return isset($this->RefundReferenceNumber) ? $this->RefundReferenceNumber : null;
    }
    /**
     * Set RefundReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refundReferenceNumber
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setRefundReferenceNumber($refundReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($refundReferenceNumber) && !is_string($refundReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refundReferenceNumber, true), gettype($refundReferenceNumber)), __LINE__);
        }
        if (is_null($refundReferenceNumber) || (is_array($refundReferenceNumber) && empty($refundReferenceNumber))) {
            unset($this->RefundReferenceNumber);
        } else {
            $this->RefundReferenceNumber = $refundReferenceNumber;
        }
        return $this;
    }
    /**
     * Get RequestCanceledByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestCanceledByUserId()
    {
        return isset($this->RequestCanceledByUserId) ? $this->RequestCanceledByUserId : null;
    }
    /**
     * Set RequestCanceledByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestCanceledByUserId
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setRequestCanceledByUserId($requestCanceledByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($requestCanceledByUserId) && !is_string($requestCanceledByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestCanceledByUserId, true), gettype($requestCanceledByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestCanceledByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestCanceledByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestCanceledByUserId, true)), __LINE__);
        }
        if (is_null($requestCanceledByUserId) || (is_array($requestCanceledByUserId) && empty($requestCanceledByUserId))) {
            unset($this->RequestCanceledByUserId);
        } else {
            $this->RequestCanceledByUserId = $requestCanceledByUserId;
        }
        return $this;
    }
    /**
     * Get RequestCreatedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestCreatedByUserId()
    {
        return isset($this->RequestCreatedByUserId) ? $this->RequestCreatedByUserId : null;
    }
    /**
     * Set RequestCreatedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestCreatedByUserId
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setRequestCreatedByUserId($requestCreatedByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($requestCreatedByUserId) && !is_string($requestCreatedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestCreatedByUserId, true), gettype($requestCreatedByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestCreatedByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestCreatedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestCreatedByUserId, true)), __LINE__);
        }
        if (is_null($requestCreatedByUserId) || (is_array($requestCreatedByUserId) && empty($requestCreatedByUserId))) {
            unset($this->RequestCreatedByUserId);
        } else {
            $this->RequestCreatedByUserId = $requestCreatedByUserId;
        }
        return $this;
    }
    /**
     * Get RequestDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestDate()
    {
        return isset($this->RequestDate) ? $this->RequestDate : null;
    }
    /**
     * Set RequestDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestDate
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setRequestDate($requestDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestDate) && !is_string($requestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestDate, true), gettype($requestDate)), __LINE__);
        }
        if (is_null($requestDate) || (is_array($requestDate) && empty($requestDate))) {
            unset($this->RequestDate);
        } else {
            $this->RequestDate = $requestDate;
        }
        return $this;
    }
    /**
     * Get RequestedPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRequestedPrice()
    {
        return isset($this->RequestedPrice) ? $this->RequestedPrice : null;
    }
    /**
     * Set RequestedPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $requestedPrice
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setRequestedPrice(\patest\StructType\Money $requestedPrice = null)
    {
        if (is_null($requestedPrice) || (is_array($requestedPrice) && empty($requestedPrice))) {
            unset($this->RequestedPrice);
        } else {
            $this->RequestedPrice = $requestedPrice;
        }
        return $this;
    }
    /**
     * Get RequestGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestGroupId()
    {
        return isset($this->RequestGroupId) ? $this->RequestGroupId : null;
    }
    /**
     * Set RequestGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestGroupId
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setRequestGroupId($requestGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($requestGroupId) && !is_string($requestGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestGroupId, true), gettype($requestGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestGroupId, true)), __LINE__);
        }
        if (is_null($requestGroupId) || (is_array($requestGroupId) && empty($requestGroupId))) {
            unset($this->RequestGroupId);
        } else {
            $this->RequestGroupId = $requestGroupId;
        }
        return $this;
    }
    /**
     * Get ResaleFee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getResaleFee()
    {
        return isset($this->ResaleFee) ? $this->ResaleFee : null;
    }
    /**
     * Set ResaleFee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $resaleFee
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setResaleFee(\patest\StructType\Money $resaleFee = null)
    {
        if (is_null($resaleFee) || (is_array($resaleFee) && empty($resaleFee))) {
            unset($this->ResaleFee);
        } else {
            $this->ResaleFee = $resaleFee;
        }
        return $this;
    }
    /**
     * Get ResaleMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleMethod()
    {
        return isset($this->ResaleMethod) ? $this->ResaleMethod : null;
    }
    /**
     * Set ResaleMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketResaleMethod::valueIsValid()
     * @uses \patest\EnumType\TicketResaleMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resaleMethod
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setResaleMethod($resaleMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketResaleMethod::valueIsValid($resaleMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketResaleMethod', is_array($resaleMethod) ? implode(', ', $resaleMethod) : var_export($resaleMethod, true), implode(', ', \patest\EnumType\TicketResaleMethod::getValidValues())), __LINE__);
        }
        if (is_null($resaleMethod) || (is_array($resaleMethod) && empty($resaleMethod))) {
            unset($this->ResaleMethod);
        } else {
            $this->ResaleMethod = $resaleMethod;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ResaleStatus::valueIsValid()
     * @uses \patest\EnumType\ResaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ResaleStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ResaleStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\ResaleStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get StatusDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusDetails()
    {
        return isset($this->StatusDetails) ? $this->StatusDetails : null;
    }
    /**
     * Set StatusDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusDetails
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setStatusDetails($statusDetails = null)
    {
        // validation for constraint: string
        if (!is_null($statusDetails) && !is_string($statusDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDetails, true), gettype($statusDetails)), __LINE__);
        }
        if (is_null($statusDetails) || (is_array($statusDetails) && empty($statusDetails))) {
            unset($this->StatusDetails);
        } else {
            $this->StatusDetails = $statusDetails;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketId()
    {
        return isset($this->TicketId) ? $this->TicketId : null;
    }
    /**
     * Set TicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketId
     * @return \patest\StructType\Ticketing_TicketResaleRequest
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        if (is_null($ticketId) || (is_array($ticketId) && empty($ticketId))) {
            unset($this->TicketId);
        } else {
            $this->TicketId = $ticketId;
        }
        return $this;
    }
}
