<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.TicketForClientIdentificationUpdate StructType
 * @subpackage Structs
 */
class Ticketing_TicketForClientIdentificationUpdate extends AnyEntity
{
    /**
     * The ClientIdentification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClientIdentification;
    /**
     * The HolderCompany
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompany;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Ticketing.TicketForClientIdentificationUpdate
     * @uses Ticketing_TicketForClientIdentificationUpdate::setClientIdentification()
     * @uses Ticketing_TicketForClientIdentificationUpdate::setHolderCompany()
     * @uses Ticketing_TicketForClientIdentificationUpdate::setId()
     * @param int $clientIdentification
     * @param int $holderCompany
     * @param string $id
     */
    public function __construct($clientIdentification = null, $holderCompany = null, $id = null)
    {
        $this
            ->setClientIdentification($clientIdentification)
            ->setHolderCompany($holderCompany)
            ->setId($id);
    }
    /**
     * Get ClientIdentification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClientIdentification()
    {
        return isset($this->ClientIdentification) ? $this->ClientIdentification : null;
    }
    /**
     * Set ClientIdentification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $clientIdentification
     * @return \patest\StructType\Ticketing_TicketForClientIdentificationUpdate
     */
    public function setClientIdentification($clientIdentification = null)
    {
        // validation for constraint: int
        if (!is_null($clientIdentification) && !(is_int($clientIdentification) || ctype_digit($clientIdentification))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientIdentification, true), gettype($clientIdentification)), __LINE__);
        }
        if (is_null($clientIdentification) || (is_array($clientIdentification) && empty($clientIdentification))) {
            unset($this->ClientIdentification);
        } else {
            $this->ClientIdentification = $clientIdentification;
        }
        return $this;
    }
    /**
     * Get HolderCompany value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompany()
    {
        return isset($this->HolderCompany) ? $this->HolderCompany : null;
    }
    /**
     * Set HolderCompany value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompany
     * @return \patest\StructType\Ticketing_TicketForClientIdentificationUpdate
     */
    public function setHolderCompany($holderCompany = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompany) && !(is_int($holderCompany) || ctype_digit($holderCompany))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompany, true), gettype($holderCompany)), __LINE__);
        }
        if (is_null($holderCompany) || (is_array($holderCompany) && empty($holderCompany))) {
            unset($this->HolderCompany);
        } else {
            $this->HolderCompany = $holderCompany;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Ticketing_TicketForClientIdentificationUpdate
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
}
