<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SubscriptionTransactionItem StructType
 * @subpackage Structs
 */
class Ticketing_SubscriptionTransactionItem extends PersistableEntity
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The PrevSubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrevSubscriptionInstanceId;
    /**
     * The SubscriptionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionId;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for Ticketing.SubscriptionTransactionItem
     * @uses Ticketing_SubscriptionTransactionItem::setAction()
     * @uses Ticketing_SubscriptionTransactionItem::setPrevSubscriptionInstanceId()
     * @uses Ticketing_SubscriptionTransactionItem::setSubscriptionId()
     * @uses Ticketing_SubscriptionTransactionItem::setSubscriptionInstanceId()
     * @uses Ticketing_SubscriptionTransactionItem::setTransactionGuid()
     * @param string $action
     * @param string $prevSubscriptionInstanceId
     * @param string $subscriptionId
     * @param string $subscriptionInstanceId
     * @param string $transactionGuid
     */
    public function __construct($action = null, $prevSubscriptionInstanceId = null, $subscriptionId = null, $subscriptionInstanceId = null, $transactionGuid = null)
    {
        $this
            ->setAction($action)
            ->setPrevSubscriptionInstanceId($prevSubscriptionInstanceId)
            ->setSubscriptionId($subscriptionId)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionAction::valueIsValid()
     * @uses \patest\EnumType\SubscriptionAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\Ticketing_SubscriptionTransactionItem
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\SubscriptionAction::getValidValues())), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get PrevSubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrevSubscriptionInstanceId()
    {
        return isset($this->PrevSubscriptionInstanceId) ? $this->PrevSubscriptionInstanceId : null;
    }
    /**
     * Set PrevSubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prevSubscriptionInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionTransactionItem
     */
    public function setPrevSubscriptionInstanceId($prevSubscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($prevSubscriptionInstanceId) && !is_string($prevSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prevSubscriptionInstanceId, true), gettype($prevSubscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($prevSubscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $prevSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($prevSubscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($prevSubscriptionInstanceId) || (is_array($prevSubscriptionInstanceId) && empty($prevSubscriptionInstanceId))) {
            unset($this->PrevSubscriptionInstanceId);
        } else {
            $this->PrevSubscriptionInstanceId = $prevSubscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get SubscriptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return isset($this->SubscriptionId) ? $this->SubscriptionId : null;
    }
    /**
     * Set SubscriptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionId
     * @return \patest\StructType\Ticketing_SubscriptionTransactionItem
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionId, true)), __LINE__);
        }
        if (is_null($subscriptionId) || (is_array($subscriptionId) && empty($subscriptionId))) {
            unset($this->SubscriptionId);
        } else {
            $this->SubscriptionId = $subscriptionId;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionTransactionItem
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Ticketing_SubscriptionTransactionItem
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
