<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SubscriptionBasketItemData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ticketing.SubscriptionBasketItemData
 * @subpackage Structs
 */
class Ticketing_SubscriptionBasketItemData extends Sales_AbstractItemDetails
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The BonusEventCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BonusEventCount;
    /**
     * The BonusTicketCountPassedOnReplace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BonusTicketCountPassedOnReplace;
    /**
     * The BucketsInfoAtPurchase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BucketsInfoAtPurchase;
    /**
     * The CurrentSubscriptionInstanceStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentSubscriptionInstanceStatus;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The EventCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventCount;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallName;
    /**
     * The IsAutoRenewRequested
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoRenewRequested;
    /**
     * The IsHospitality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHospitality;
    /**
     * The IsPartialEventBased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPartialEventBased;
    /**
     * The IsPricingPerSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPricingPerSeries;
    /**
     * The PartOfSeriesGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PartOfSeriesGroupId;
    /**
     * The PartOfSeriesGroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartOfSeriesGroupName;
    /**
     * The PrevSubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrevSubscriptionInstanceId;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelName;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The Seasonality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seasonality;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The SeatingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatingType;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectorName;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesName;
    /**
     * The SkipAutoRenewValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipAutoRenewValidation;
    /**
     * The StandId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StandId;
    /**
     * The StandName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $StandName;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The SubscriptionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionId;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The TicketCountPassedOnReplace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketCountPassedOnReplace;
    /**
     * The TicketSchemesToEnroll
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_AddSubscriptionTicketSchemeDetails
     */
    public $TicketSchemesToEnroll;
    /**
     * The WaitMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WaitMode;
    /**
     * Constructor method for Ticketing.SubscriptionBasketItemData
     * @uses Ticketing_SubscriptionBasketItemData::setAction()
     * @uses Ticketing_SubscriptionBasketItemData::setAreaId()
     * @uses Ticketing_SubscriptionBasketItemData::setAreaName()
     * @uses Ticketing_SubscriptionBasketItemData::setBonusEventCount()
     * @uses Ticketing_SubscriptionBasketItemData::setBonusTicketCountPassedOnReplace()
     * @uses Ticketing_SubscriptionBasketItemData::setBucketsInfoAtPurchase()
     * @uses Ticketing_SubscriptionBasketItemData::setCurrentSubscriptionInstanceStatus()
     * @uses Ticketing_SubscriptionBasketItemData::setEndDate()
     * @uses Ticketing_SubscriptionBasketItemData::setEventCount()
     * @uses Ticketing_SubscriptionBasketItemData::setHallId()
     * @uses Ticketing_SubscriptionBasketItemData::setHallName()
     * @uses Ticketing_SubscriptionBasketItemData::setIsAutoRenewRequested()
     * @uses Ticketing_SubscriptionBasketItemData::setIsHospitality()
     * @uses Ticketing_SubscriptionBasketItemData::setIsPartialEventBased()
     * @uses Ticketing_SubscriptionBasketItemData::setIsPricingPerSeries()
     * @uses Ticketing_SubscriptionBasketItemData::setPartOfSeriesGroupId()
     * @uses Ticketing_SubscriptionBasketItemData::setPartOfSeriesGroupName()
     * @uses Ticketing_SubscriptionBasketItemData::setPrevSubscriptionInstanceId()
     * @uses Ticketing_SubscriptionBasketItemData::setPriceLevelId()
     * @uses Ticketing_SubscriptionBasketItemData::setPriceLevelName()
     * @uses Ticketing_SubscriptionBasketItemData::setRowName()
     * @uses Ticketing_SubscriptionBasketItemData::setSeasonality()
     * @uses Ticketing_SubscriptionBasketItemData::setSeatIdInAreaMap()
     * @uses Ticketing_SubscriptionBasketItemData::setSeatingType()
     * @uses Ticketing_SubscriptionBasketItemData::setSeatName()
     * @uses Ticketing_SubscriptionBasketItemData::setSectorName()
     * @uses Ticketing_SubscriptionBasketItemData::setSeriesId()
     * @uses Ticketing_SubscriptionBasketItemData::setSeriesName()
     * @uses Ticketing_SubscriptionBasketItemData::setSkipAutoRenewValidation()
     * @uses Ticketing_SubscriptionBasketItemData::setStandId()
     * @uses Ticketing_SubscriptionBasketItemData::setStandName()
     * @uses Ticketing_SubscriptionBasketItemData::setStartDate()
     * @uses Ticketing_SubscriptionBasketItemData::setSubscriptionId()
     * @uses Ticketing_SubscriptionBasketItemData::setSubscriptionInstanceId()
     * @uses Ticketing_SubscriptionBasketItemData::setSubscriptionNumber()
     * @uses Ticketing_SubscriptionBasketItemData::setTicketCountPassedOnReplace()
     * @uses Ticketing_SubscriptionBasketItemData::setTicketSchemesToEnroll()
     * @uses Ticketing_SubscriptionBasketItemData::setWaitMode()
     * @param string $action
     * @param string $areaId
     * @param string $areaName
     * @param int $bonusEventCount
     * @param int $bonusTicketCountPassedOnReplace
     * @param string $bucketsInfoAtPurchase
     * @param string $currentSubscriptionInstanceStatus
     * @param string $endDate
     * @param int $eventCount
     * @param string $hallId
     * @param string $hallName
     * @param bool $isAutoRenewRequested
     * @param bool $isHospitality
     * @param bool $isPartialEventBased
     * @param bool $isPricingPerSeries
     * @param string $partOfSeriesGroupId
     * @param string $partOfSeriesGroupName
     * @param string $prevSubscriptionInstanceId
     * @param string $priceLevelId
     * @param string $priceLevelName
     * @param string $rowName
     * @param string $seasonality
     * @param int $seatIdInAreaMap
     * @param string $seatingType
     * @param string $seatName
     * @param string $sectorName
     * @param string $seriesId
     * @param string $seriesName
     * @param bool $skipAutoRenewValidation
     * @param string $standId
     * @param \patest\StructType\GlobalString $standName
     * @param string $startDate
     * @param string $subscriptionId
     * @param string $subscriptionInstanceId
     * @param string $subscriptionNumber
     * @param int $ticketCountPassedOnReplace
     * @param \patest\StructType\RecordSetOfTicketing_AddSubscriptionTicketSchemeDetails $ticketSchemesToEnroll
     * @param string $waitMode
     */
    public function __construct($action = null, $areaId = null, $areaName = null, $bonusEventCount = null, $bonusTicketCountPassedOnReplace = null, $bucketsInfoAtPurchase = null, $currentSubscriptionInstanceStatus = null, $endDate = null, $eventCount = null, $hallId = null, $hallName = null, $isAutoRenewRequested = null, $isHospitality = null, $isPartialEventBased = null, $isPricingPerSeries = null, $partOfSeriesGroupId = null, $partOfSeriesGroupName = null, $prevSubscriptionInstanceId = null, $priceLevelId = null, $priceLevelName = null, $rowName = null, $seasonality = null, $seatIdInAreaMap = null, $seatingType = null, $seatName = null, $sectorName = null, $seriesId = null, $seriesName = null, $skipAutoRenewValidation = null, $standId = null, \patest\StructType\GlobalString $standName = null, $startDate = null, $subscriptionId = null, $subscriptionInstanceId = null, $subscriptionNumber = null, $ticketCountPassedOnReplace = null, \patest\StructType\RecordSetOfTicketing_AddSubscriptionTicketSchemeDetails $ticketSchemesToEnroll = null, $waitMode = null)
    {
        $this
            ->setAction($action)
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setBonusEventCount($bonusEventCount)
            ->setBonusTicketCountPassedOnReplace($bonusTicketCountPassedOnReplace)
            ->setBucketsInfoAtPurchase($bucketsInfoAtPurchase)
            ->setCurrentSubscriptionInstanceStatus($currentSubscriptionInstanceStatus)
            ->setEndDate($endDate)
            ->setEventCount($eventCount)
            ->setHallId($hallId)
            ->setHallName($hallName)
            ->setIsAutoRenewRequested($isAutoRenewRequested)
            ->setIsHospitality($isHospitality)
            ->setIsPartialEventBased($isPartialEventBased)
            ->setIsPricingPerSeries($isPricingPerSeries)
            ->setPartOfSeriesGroupId($partOfSeriesGroupId)
            ->setPartOfSeriesGroupName($partOfSeriesGroupName)
            ->setPrevSubscriptionInstanceId($prevSubscriptionInstanceId)
            ->setPriceLevelId($priceLevelId)
            ->setPriceLevelName($priceLevelName)
            ->setRowName($rowName)
            ->setSeasonality($seasonality)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setSeatingType($seatingType)
            ->setSeatName($seatName)
            ->setSectorName($sectorName)
            ->setSeriesId($seriesId)
            ->setSeriesName($seriesName)
            ->setSkipAutoRenewValidation($skipAutoRenewValidation)
            ->setStandId($standId)
            ->setStandName($standName)
            ->setStartDate($startDate)
            ->setSubscriptionId($subscriptionId)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setTicketCountPassedOnReplace($ticketCountPassedOnReplace)
            ->setTicketSchemesToEnroll($ticketSchemesToEnroll)
            ->setWaitMode($waitMode);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionAction::valueIsValid()
     * @uses \patest\EnumType\SubscriptionAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\SubscriptionAction::getValidValues())), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get BonusEventCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBonusEventCount()
    {
        return isset($this->BonusEventCount) ? $this->BonusEventCount : null;
    }
    /**
     * Set BonusEventCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bonusEventCount
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setBonusEventCount($bonusEventCount = null)
    {
        // validation for constraint: int
        if (!is_null($bonusEventCount) && !(is_int($bonusEventCount) || ctype_digit($bonusEventCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bonusEventCount, true), gettype($bonusEventCount)), __LINE__);
        }
        if (is_null($bonusEventCount) || (is_array($bonusEventCount) && empty($bonusEventCount))) {
            unset($this->BonusEventCount);
        } else {
            $this->BonusEventCount = $bonusEventCount;
        }
        return $this;
    }
    /**
     * Get BonusTicketCountPassedOnReplace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBonusTicketCountPassedOnReplace()
    {
        return isset($this->BonusTicketCountPassedOnReplace) ? $this->BonusTicketCountPassedOnReplace : null;
    }
    /**
     * Set BonusTicketCountPassedOnReplace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bonusTicketCountPassedOnReplace
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setBonusTicketCountPassedOnReplace($bonusTicketCountPassedOnReplace = null)
    {
        // validation for constraint: int
        if (!is_null($bonusTicketCountPassedOnReplace) && !(is_int($bonusTicketCountPassedOnReplace) || ctype_digit($bonusTicketCountPassedOnReplace))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bonusTicketCountPassedOnReplace, true), gettype($bonusTicketCountPassedOnReplace)), __LINE__);
        }
        if (is_null($bonusTicketCountPassedOnReplace) || (is_array($bonusTicketCountPassedOnReplace) && empty($bonusTicketCountPassedOnReplace))) {
            unset($this->BonusTicketCountPassedOnReplace);
        } else {
            $this->BonusTicketCountPassedOnReplace = $bonusTicketCountPassedOnReplace;
        }
        return $this;
    }
    /**
     * Get BucketsInfoAtPurchase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBucketsInfoAtPurchase()
    {
        return isset($this->BucketsInfoAtPurchase) ? $this->BucketsInfoAtPurchase : null;
    }
    /**
     * Set BucketsInfoAtPurchase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bucketsInfoAtPurchase
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setBucketsInfoAtPurchase($bucketsInfoAtPurchase = null)
    {
        // validation for constraint: string
        if (!is_null($bucketsInfoAtPurchase) && !is_string($bucketsInfoAtPurchase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bucketsInfoAtPurchase, true), gettype($bucketsInfoAtPurchase)), __LINE__);
        }
        if (is_null($bucketsInfoAtPurchase) || (is_array($bucketsInfoAtPurchase) && empty($bucketsInfoAtPurchase))) {
            unset($this->BucketsInfoAtPurchase);
        } else {
            $this->BucketsInfoAtPurchase = $bucketsInfoAtPurchase;
        }
        return $this;
    }
    /**
     * Get CurrentSubscriptionInstanceStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentSubscriptionInstanceStatus()
    {
        return isset($this->CurrentSubscriptionInstanceStatus) ? $this->CurrentSubscriptionInstanceStatus : null;
    }
    /**
     * Set CurrentSubscriptionInstanceStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionStatus::valueIsValid()
     * @uses \patest\EnumType\SubscriptionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currentSubscriptionInstanceStatus
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setCurrentSubscriptionInstanceStatus($currentSubscriptionInstanceStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionStatus::valueIsValid($currentSubscriptionInstanceStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionStatus', is_array($currentSubscriptionInstanceStatus) ? implode(', ', $currentSubscriptionInstanceStatus) : var_export($currentSubscriptionInstanceStatus, true), implode(', ', \patest\EnumType\SubscriptionStatus::getValidValues())), __LINE__);
        }
        if (is_null($currentSubscriptionInstanceStatus) || (is_array($currentSubscriptionInstanceStatus) && empty($currentSubscriptionInstanceStatus))) {
            unset($this->CurrentSubscriptionInstanceStatus);
        } else {
            $this->CurrentSubscriptionInstanceStatus = $currentSubscriptionInstanceStatus;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get EventCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventCount()
    {
        return isset($this->EventCount) ? $this->EventCount : null;
    }
    /**
     * Set EventCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventCount
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setEventCount($eventCount = null)
    {
        // validation for constraint: int
        if (!is_null($eventCount) && !(is_int($eventCount) || ctype_digit($eventCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventCount, true), gettype($eventCount)), __LINE__);
        }
        if (is_null($eventCount) || (is_array($eventCount) && empty($eventCount))) {
            unset($this->EventCount);
        } else {
            $this->EventCount = $eventCount;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallName
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setHallName($hallName = null)
    {
        // validation for constraint: string
        if (!is_null($hallName) && !is_string($hallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallName, true), gettype($hallName)), __LINE__);
        }
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get IsAutoRenewRequested value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoRenewRequested()
    {
        return isset($this->IsAutoRenewRequested) ? $this->IsAutoRenewRequested : null;
    }
    /**
     * Set IsAutoRenewRequested value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoRenewRequested
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setIsAutoRenewRequested($isAutoRenewRequested = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoRenewRequested) && !is_bool($isAutoRenewRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoRenewRequested, true), gettype($isAutoRenewRequested)), __LINE__);
        }
        if (is_null($isAutoRenewRequested) || (is_array($isAutoRenewRequested) && empty($isAutoRenewRequested))) {
            unset($this->IsAutoRenewRequested);
        } else {
            $this->IsAutoRenewRequested = $isAutoRenewRequested;
        }
        return $this;
    }
    /**
     * Get IsHospitality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHospitality()
    {
        return isset($this->IsHospitality) ? $this->IsHospitality : null;
    }
    /**
     * Set IsHospitality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHospitality
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setIsHospitality($isHospitality = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHospitality) && !is_bool($isHospitality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHospitality, true), gettype($isHospitality)), __LINE__);
        }
        if (is_null($isHospitality) || (is_array($isHospitality) && empty($isHospitality))) {
            unset($this->IsHospitality);
        } else {
            $this->IsHospitality = $isHospitality;
        }
        return $this;
    }
    /**
     * Get IsPartialEventBased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPartialEventBased()
    {
        return isset($this->IsPartialEventBased) ? $this->IsPartialEventBased : null;
    }
    /**
     * Set IsPartialEventBased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPartialEventBased
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setIsPartialEventBased($isPartialEventBased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPartialEventBased) && !is_bool($isPartialEventBased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPartialEventBased, true), gettype($isPartialEventBased)), __LINE__);
        }
        if (is_null($isPartialEventBased) || (is_array($isPartialEventBased) && empty($isPartialEventBased))) {
            unset($this->IsPartialEventBased);
        } else {
            $this->IsPartialEventBased = $isPartialEventBased;
        }
        return $this;
    }
    /**
     * Get IsPricingPerSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPricingPerSeries()
    {
        return isset($this->IsPricingPerSeries) ? $this->IsPricingPerSeries : null;
    }
    /**
     * Set IsPricingPerSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPricingPerSeries
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setIsPricingPerSeries($isPricingPerSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPricingPerSeries) && !is_bool($isPricingPerSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPricingPerSeries, true), gettype($isPricingPerSeries)), __LINE__);
        }
        if (is_null($isPricingPerSeries) || (is_array($isPricingPerSeries) && empty($isPricingPerSeries))) {
            unset($this->IsPricingPerSeries);
        } else {
            $this->IsPricingPerSeries = $isPricingPerSeries;
        }
        return $this;
    }
    /**
     * Get PartOfSeriesGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartOfSeriesGroupId()
    {
        return isset($this->PartOfSeriesGroupId) ? $this->PartOfSeriesGroupId : null;
    }
    /**
     * Set PartOfSeriesGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partOfSeriesGroupId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setPartOfSeriesGroupId($partOfSeriesGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($partOfSeriesGroupId) && !is_string($partOfSeriesGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partOfSeriesGroupId, true), gettype($partOfSeriesGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($partOfSeriesGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $partOfSeriesGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($partOfSeriesGroupId, true)), __LINE__);
        }
        if (is_null($partOfSeriesGroupId) || (is_array($partOfSeriesGroupId) && empty($partOfSeriesGroupId))) {
            unset($this->PartOfSeriesGroupId);
        } else {
            $this->PartOfSeriesGroupId = $partOfSeriesGroupId;
        }
        return $this;
    }
    /**
     * Get PartOfSeriesGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartOfSeriesGroupName()
    {
        return isset($this->PartOfSeriesGroupName) ? $this->PartOfSeriesGroupName : null;
    }
    /**
     * Set PartOfSeriesGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partOfSeriesGroupName
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setPartOfSeriesGroupName($partOfSeriesGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($partOfSeriesGroupName) && !is_string($partOfSeriesGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partOfSeriesGroupName, true), gettype($partOfSeriesGroupName)), __LINE__);
        }
        if (is_null($partOfSeriesGroupName) || (is_array($partOfSeriesGroupName) && empty($partOfSeriesGroupName))) {
            unset($this->PartOfSeriesGroupName);
        } else {
            $this->PartOfSeriesGroupName = $partOfSeriesGroupName;
        }
        return $this;
    }
    /**
     * Get PrevSubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrevSubscriptionInstanceId()
    {
        return isset($this->PrevSubscriptionInstanceId) ? $this->PrevSubscriptionInstanceId : null;
    }
    /**
     * Set PrevSubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prevSubscriptionInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setPrevSubscriptionInstanceId($prevSubscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($prevSubscriptionInstanceId) && !is_string($prevSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prevSubscriptionInstanceId, true), gettype($prevSubscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($prevSubscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $prevSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($prevSubscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($prevSubscriptionInstanceId) || (is_array($prevSubscriptionInstanceId) && empty($prevSubscriptionInstanceId))) {
            unset($this->PrevSubscriptionInstanceId);
        } else {
            $this->PrevSubscriptionInstanceId = $prevSubscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelName
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setPriceLevelName($priceLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelName) && !is_string($priceLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelName, true), gettype($priceLevelName)), __LINE__);
        }
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get Seasonality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonality()
    {
        return isset($this->Seasonality) ? $this->Seasonality : null;
    }
    /**
     * Set Seasonality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeriesSeasonality::valueIsValid()
     * @uses \patest\EnumType\SeriesSeasonality::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seasonality
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setSeasonality($seasonality = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeriesSeasonality::valueIsValid($seasonality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeriesSeasonality', is_array($seasonality) ? implode(', ', $seasonality) : var_export($seasonality, true), implode(', ', \patest\EnumType\SeriesSeasonality::getValidValues())), __LINE__);
        }
        if (is_null($seasonality) || (is_array($seasonality) && empty($seasonality))) {
            unset($this->Seasonality);
        } else {
            $this->Seasonality = $seasonality;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return isset($this->SeatIdInAreaMap) ? $this->SeatIdInAreaMap : null;
    }
    /**
     * Set SeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        if (is_null($seatIdInAreaMap) || (is_array($seatIdInAreaMap) && empty($seatIdInAreaMap))) {
            unset($this->SeatIdInAreaMap);
        } else {
            $this->SeatIdInAreaMap = $seatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get SeatingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingType()
    {
        return isset($this->SeatingType) ? $this->SeatingType : null;
    }
    /**
     * Set SeatingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaSeatingType::valueIsValid()
     * @uses \patest\EnumType\AreaSeatingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatingType
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setSeatingType($seatingType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaSeatingType::valueIsValid($seatingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaSeatingType', is_array($seatingType) ? implode(', ', $seatingType) : var_export($seatingType, true), implode(', ', \patest\EnumType\AreaSeatingType::getValidValues())), __LINE__);
        }
        if (is_null($seatingType) || (is_array($seatingType) && empty($seatingType))) {
            unset($this->SeatingType);
        } else {
            $this->SeatingType = $seatingType;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorName
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setSectorName($sectorName = null)
    {
        // validation for constraint: string
        if (!is_null($sectorName) && !is_string($sectorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorName, true), gettype($sectorName)), __LINE__);
        }
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesName
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setSeriesName($seriesName = null)
    {
        // validation for constraint: string
        if (!is_null($seriesName) && !is_string($seriesName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesName, true), gettype($seriesName)), __LINE__);
        }
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
    /**
     * Get SkipAutoRenewValidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipAutoRenewValidation()
    {
        return isset($this->SkipAutoRenewValidation) ? $this->SkipAutoRenewValidation : null;
    }
    /**
     * Set SkipAutoRenewValidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipAutoRenewValidation
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setSkipAutoRenewValidation($skipAutoRenewValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipAutoRenewValidation) && !is_bool($skipAutoRenewValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipAutoRenewValidation, true), gettype($skipAutoRenewValidation)), __LINE__);
        }
        if (is_null($skipAutoRenewValidation) || (is_array($skipAutoRenewValidation) && empty($skipAutoRenewValidation))) {
            unset($this->SkipAutoRenewValidation);
        } else {
            $this->SkipAutoRenewValidation = $skipAutoRenewValidation;
        }
        return $this;
    }
    /**
     * Get StandId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStandId()
    {
        return isset($this->StandId) ? $this->StandId : null;
    }
    /**
     * Set StandId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $standId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setStandId($standId = null)
    {
        // validation for constraint: string
        if (!is_null($standId) && !is_string($standId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standId, true), gettype($standId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($standId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $standId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($standId, true)), __LINE__);
        }
        if (is_null($standId) || (is_array($standId) && empty($standId))) {
            unset($this->StandId);
        } else {
            $this->StandId = $standId;
        }
        return $this;
    }
    /**
     * Get StandName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getStandName()
    {
        return isset($this->StandName) ? $this->StandName : null;
    }
    /**
     * Set StandName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $standName
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setStandName(\patest\StructType\GlobalString $standName = null)
    {
        if (is_null($standName) || (is_array($standName) && empty($standName))) {
            unset($this->StandName);
        } else {
            $this->StandName = $standName;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get SubscriptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return isset($this->SubscriptionId) ? $this->SubscriptionId : null;
    }
    /**
     * Set SubscriptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionId, true)), __LINE__);
        }
        if (is_null($subscriptionId) || (is_array($subscriptionId) && empty($subscriptionId))) {
            unset($this->SubscriptionId);
        } else {
            $this->SubscriptionId = $subscriptionId;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get TicketCountPassedOnReplace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketCountPassedOnReplace()
    {
        return isset($this->TicketCountPassedOnReplace) ? $this->TicketCountPassedOnReplace : null;
    }
    /**
     * Set TicketCountPassedOnReplace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketCountPassedOnReplace
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setTicketCountPassedOnReplace($ticketCountPassedOnReplace = null)
    {
        // validation for constraint: int
        if (!is_null($ticketCountPassedOnReplace) && !(is_int($ticketCountPassedOnReplace) || ctype_digit($ticketCountPassedOnReplace))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketCountPassedOnReplace, true), gettype($ticketCountPassedOnReplace)), __LINE__);
        }
        if (is_null($ticketCountPassedOnReplace) || (is_array($ticketCountPassedOnReplace) && empty($ticketCountPassedOnReplace))) {
            unset($this->TicketCountPassedOnReplace);
        } else {
            $this->TicketCountPassedOnReplace = $ticketCountPassedOnReplace;
        }
        return $this;
    }
    /**
     * Get TicketSchemesToEnroll value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_AddSubscriptionTicketSchemeDetails|null
     */
    public function getTicketSchemesToEnroll()
    {
        return isset($this->TicketSchemesToEnroll) ? $this->TicketSchemesToEnroll : null;
    }
    /**
     * Set TicketSchemesToEnroll value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_AddSubscriptionTicketSchemeDetails $ticketSchemesToEnroll
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setTicketSchemesToEnroll(\patest\StructType\RecordSetOfTicketing_AddSubscriptionTicketSchemeDetails $ticketSchemesToEnroll = null)
    {
        if (is_null($ticketSchemesToEnroll) || (is_array($ticketSchemesToEnroll) && empty($ticketSchemesToEnroll))) {
            unset($this->TicketSchemesToEnroll);
        } else {
            $this->TicketSchemesToEnroll = $ticketSchemesToEnroll;
        }
        return $this;
    }
    /**
     * Get WaitMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWaitMode()
    {
        return isset($this->WaitMode) ? $this->WaitMode : null;
    }
    /**
     * Set WaitMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketWaitMode::valueIsValid()
     * @uses \patest\EnumType\TicketWaitMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waitMode
     * @return \patest\StructType\Ticketing_SubscriptionBasketItemData
     */
    public function setWaitMode($waitMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketWaitMode::valueIsValid($waitMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketWaitMode', is_array($waitMode) ? implode(', ', $waitMode) : var_export($waitMode, true), implode(', ', \patest\EnumType\TicketWaitMode::getValidValues())), __LINE__);
        }
        if (is_null($waitMode) || (is_array($waitMode) && empty($waitMode))) {
            unset($this->WaitMode);
        } else {
            $this->WaitMode = $waitMode;
        }
        return $this;
    }
}
