<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SubscriberBenefitsUtilization StructType
 * @subpackage Structs
 */
class Ticketing_SubscriberBenefitsUtilization extends PersistableEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The BenefitKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BenefitKind;
    /**
     * The BenefitProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BenefitProductId;
    /**
     * The BenefitProductInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BenefitProductInstanceId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The StatusDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusDateTime;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The SubscriptionSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionSeriesId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The UtilizationStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UtilizationStatus;
    /**
     * Constructor method for Ticketing.SubscriberBenefitsUtilization
     * @uses Ticketing_SubscriberBenefitsUtilization::setAreaId()
     * @uses Ticketing_SubscriberBenefitsUtilization::setBenefitKind()
     * @uses Ticketing_SubscriberBenefitsUtilization::setBenefitProductId()
     * @uses Ticketing_SubscriberBenefitsUtilization::setBenefitProductInstanceId()
     * @uses Ticketing_SubscriberBenefitsUtilization::setClientId()
     * @uses Ticketing_SubscriberBenefitsUtilization::setNotes()
     * @uses Ticketing_SubscriberBenefitsUtilization::setSeatIdInAreaMap()
     * @uses Ticketing_SubscriberBenefitsUtilization::setStatusDateTime()
     * @uses Ticketing_SubscriberBenefitsUtilization::setSubscriptionInstanceId()
     * @uses Ticketing_SubscriberBenefitsUtilization::setSubscriptionSeriesId()
     * @uses Ticketing_SubscriberBenefitsUtilization::setTransactionGuid()
     * @uses Ticketing_SubscriberBenefitsUtilization::setUtilizationStatus()
     * @param string $areaId
     * @param string $benefitKind
     * @param string $benefitProductId
     * @param string $benefitProductInstanceId
     * @param string $clientId
     * @param string $notes
     * @param int $seatIdInAreaMap
     * @param string $statusDateTime
     * @param string $subscriptionInstanceId
     * @param string $subscriptionSeriesId
     * @param string $transactionGuid
     * @param string $utilizationStatus
     */
    public function __construct($areaId = null, $benefitKind = null, $benefitProductId = null, $benefitProductInstanceId = null, $clientId = null, $notes = null, $seatIdInAreaMap = null, $statusDateTime = null, $subscriptionInstanceId = null, $subscriptionSeriesId = null, $transactionGuid = null, $utilizationStatus = null)
    {
        $this
            ->setAreaId($areaId)
            ->setBenefitKind($benefitKind)
            ->setBenefitProductId($benefitProductId)
            ->setBenefitProductInstanceId($benefitProductInstanceId)
            ->setClientId($clientId)
            ->setNotes($notes)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setStatusDateTime($statusDateTime)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setSubscriptionSeriesId($subscriptionSeriesId)
            ->setTransactionGuid($transactionGuid)
            ->setUtilizationStatus($utilizationStatus);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_SubscriberBenefitsUtilization
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get BenefitKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitKind()
    {
        return isset($this->BenefitKind) ? $this->BenefitKind : null;
    }
    /**
     * Set BenefitKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriberBenefitKind::valueIsValid()
     * @uses \patest\EnumType\SubscriberBenefitKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $benefitKind
     * @return \patest\StructType\Ticketing_SubscriberBenefitsUtilization
     */
    public function setBenefitKind($benefitKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriberBenefitKind::valueIsValid($benefitKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriberBenefitKind', is_array($benefitKind) ? implode(', ', $benefitKind) : var_export($benefitKind, true), implode(', ', \patest\EnumType\SubscriberBenefitKind::getValidValues())), __LINE__);
        }
        if (is_null($benefitKind) || (is_array($benefitKind) && empty($benefitKind))) {
            unset($this->BenefitKind);
        } else {
            $this->BenefitKind = $benefitKind;
        }
        return $this;
    }
    /**
     * Get BenefitProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitProductId()
    {
        return isset($this->BenefitProductId) ? $this->BenefitProductId : null;
    }
    /**
     * Set BenefitProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $benefitProductId
     * @return \patest\StructType\Ticketing_SubscriberBenefitsUtilization
     */
    public function setBenefitProductId($benefitProductId = null)
    {
        // validation for constraint: string
        if (!is_null($benefitProductId) && !is_string($benefitProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitProductId, true), gettype($benefitProductId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($benefitProductId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $benefitProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($benefitProductId, true)), __LINE__);
        }
        if (is_null($benefitProductId) || (is_array($benefitProductId) && empty($benefitProductId))) {
            unset($this->BenefitProductId);
        } else {
            $this->BenefitProductId = $benefitProductId;
        }
        return $this;
    }
    /**
     * Get BenefitProductInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitProductInstanceId()
    {
        return isset($this->BenefitProductInstanceId) ? $this->BenefitProductInstanceId : null;
    }
    /**
     * Set BenefitProductInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $benefitProductInstanceId
     * @return \patest\StructType\Ticketing_SubscriberBenefitsUtilization
     */
    public function setBenefitProductInstanceId($benefitProductInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($benefitProductInstanceId) && !is_string($benefitProductInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitProductInstanceId, true), gettype($benefitProductInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($benefitProductInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $benefitProductInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($benefitProductInstanceId, true)), __LINE__);
        }
        if (is_null($benefitProductInstanceId) || (is_array($benefitProductInstanceId) && empty($benefitProductInstanceId))) {
            unset($this->BenefitProductInstanceId);
        } else {
            $this->BenefitProductInstanceId = $benefitProductInstanceId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_SubscriberBenefitsUtilization
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\Ticketing_SubscriberBenefitsUtilization
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return isset($this->SeatIdInAreaMap) ? $this->SeatIdInAreaMap : null;
    }
    /**
     * Set SeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\Ticketing_SubscriberBenefitsUtilization
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        if (is_null($seatIdInAreaMap) || (is_array($seatIdInAreaMap) && empty($seatIdInAreaMap))) {
            unset($this->SeatIdInAreaMap);
        } else {
            $this->SeatIdInAreaMap = $seatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get StatusDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusDateTime()
    {
        return isset($this->StatusDateTime) ? $this->StatusDateTime : null;
    }
    /**
     * Set StatusDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusDateTime
     * @return \patest\StructType\Ticketing_SubscriberBenefitsUtilization
     */
    public function setStatusDateTime($statusDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($statusDateTime) && !is_string($statusDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDateTime, true), gettype($statusDateTime)), __LINE__);
        }
        if (is_null($statusDateTime) || (is_array($statusDateTime) && empty($statusDateTime))) {
            unset($this->StatusDateTime);
        } else {
            $this->StatusDateTime = $statusDateTime;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\Ticketing_SubscriberBenefitsUtilization
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get SubscriptionSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionSeriesId()
    {
        return isset($this->SubscriptionSeriesId) ? $this->SubscriptionSeriesId : null;
    }
    /**
     * Set SubscriptionSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionSeriesId
     * @return \patest\StructType\Ticketing_SubscriberBenefitsUtilization
     */
    public function setSubscriptionSeriesId($subscriptionSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionSeriesId) && !is_string($subscriptionSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionSeriesId, true), gettype($subscriptionSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionSeriesId, true)), __LINE__);
        }
        if (is_null($subscriptionSeriesId) || (is_array($subscriptionSeriesId) && empty($subscriptionSeriesId))) {
            unset($this->SubscriptionSeriesId);
        } else {
            $this->SubscriptionSeriesId = $subscriptionSeriesId;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Ticketing_SubscriberBenefitsUtilization
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get UtilizationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUtilizationStatus()
    {
        return isset($this->UtilizationStatus) ? $this->UtilizationStatus : null;
    }
    /**
     * Set UtilizationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriberBenefitUtilizationStatus::valueIsValid()
     * @uses \patest\EnumType\SubscriberBenefitUtilizationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $utilizationStatus
     * @return \patest\StructType\Ticketing_SubscriberBenefitsUtilization
     */
    public function setUtilizationStatus($utilizationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriberBenefitUtilizationStatus::valueIsValid($utilizationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriberBenefitUtilizationStatus', is_array($utilizationStatus) ? implode(', ', $utilizationStatus) : var_export($utilizationStatus, true), implode(', ', \patest\EnumType\SubscriberBenefitUtilizationStatus::getValidValues())), __LINE__);
        }
        if (is_null($utilizationStatus) || (is_array($utilizationStatus) && empty($utilizationStatus))) {
            unset($this->UtilizationStatus);
        } else {
            $this->UtilizationStatus = $utilizationStatus;
        }
        return $this;
    }
}
