<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ShowType StructType
 * @subpackage Structs
 */
class Ticketing_ShowType extends Ticketing_Base
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The AllDayEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllDayEvent;
    /**
     * The AllowedBookingRequestTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AllowedBookingRequestTypes
     */
    public $AllowedBookingRequestTypes;
    /**
     * The CrossOrgUnitsAclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CrossOrgUnitsAclSchemeId;
    /**
     * The DefaultSeatgeekAllocationTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultSeatgeekAllocationTypeId;
    /**
     * The DeferredLedgerIdForRegular
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeferredLedgerIdForRegular;
    /**
     * The DeferredLedgerIdForSubscribers
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeferredLedgerIdForSubscribers;
    /**
     * The DisplayStyleValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayStyleValue;
    /**
     * The EntityVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityVersion;
    /**
     * The InheritAllowedBookingRequestsOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $InheritAllowedBookingRequestsOptions;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsGroupTour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGroupTour;
    /**
     * The IsTour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTour;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The MaxEventsInTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxEventsInTransaction;
    /**
     * The MinNumberOfTicketsPerEventForGroupTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinNumberOfTicketsPerEventForGroupTicket;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OnlineTicketsLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OnlineTicketsLimit;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The PromoterId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PromoterId;
    /**
     * The PromoterPriceListIdForRegularTickets
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PromoterPriceListIdForRegularTickets;
    /**
     * The PromoterPriceListIdForSubsTickets
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PromoterPriceListIdForSubsTickets;
    /**
     * The ReplaceSubsTicketAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReplaceSubsTicketAllowed;
    /**
     * The SellOnlyAsPartOfPrompt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SellOnlyAsPartOfPrompt;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Ticketing.ShowType
     * @uses Ticketing_ShowType::setAclSchemeId()
     * @uses Ticketing_ShowType::setAllDayEvent()
     * @uses Ticketing_ShowType::setAllowedBookingRequestTypes()
     * @uses Ticketing_ShowType::setCrossOrgUnitsAclSchemeId()
     * @uses Ticketing_ShowType::setDefaultSeatgeekAllocationTypeId()
     * @uses Ticketing_ShowType::setDeferredLedgerIdForRegular()
     * @uses Ticketing_ShowType::setDeferredLedgerIdForSubscribers()
     * @uses Ticketing_ShowType::setDisplayStyleValue()
     * @uses Ticketing_ShowType::setEntityVersion()
     * @uses Ticketing_ShowType::setInheritAllowedBookingRequestsOptions()
     * @uses Ticketing_ShowType::setIsActive()
     * @uses Ticketing_ShowType::setIsGroupTour()
     * @uses Ticketing_ShowType::setIsTour()
     * @uses Ticketing_ShowType::setLedgerId()
     * @uses Ticketing_ShowType::setMaxEventsInTransaction()
     * @uses Ticketing_ShowType::setMinNumberOfTicketsPerEventForGroupTicket()
     * @uses Ticketing_ShowType::setName()
     * @uses Ticketing_ShowType::setOnlineTicketsLimit()
     * @uses Ticketing_ShowType::setOrdinal()
     * @uses Ticketing_ShowType::setOrganizationUnitId()
     * @uses Ticketing_ShowType::setProjectIdentifierId()
     * @uses Ticketing_ShowType::setPromoterId()
     * @uses Ticketing_ShowType::setPromoterPriceListIdForRegularTickets()
     * @uses Ticketing_ShowType::setPromoterPriceListIdForSubsTickets()
     * @uses Ticketing_ShowType::setReplaceSubsTicketAllowed()
     * @uses Ticketing_ShowType::setSellOnlyAsPartOfPrompt()
     * @uses Ticketing_ShowType::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param bool $allDayEvent
     * @param \patest\StructType\AllowedBookingRequestTypes $allowedBookingRequestTypes
     * @param int $crossOrgUnitsAclSchemeId
     * @param string $defaultSeatgeekAllocationTypeId
     * @param string $deferredLedgerIdForRegular
     * @param string $deferredLedgerIdForSubscribers
     * @param string $displayStyleValue
     * @param string $entityVersion
     * @param bool $inheritAllowedBookingRequestsOptions
     * @param bool $isActive
     * @param bool $isGroupTour
     * @param bool $isTour
     * @param string $ledgerId
     * @param int $maxEventsInTransaction
     * @param int $minNumberOfTicketsPerEventForGroupTicket
     * @param \patest\StructType\GlobalString $name
     * @param int $onlineTicketsLimit
     * @param int $ordinal
     * @param string $organizationUnitId
     * @param string $projectIdentifierId
     * @param string $promoterId
     * @param string $promoterPriceListIdForRegularTickets
     * @param string $promoterPriceListIdForSubsTickets
     * @param bool $replaceSubsTicketAllowed
     * @param bool $sellOnlyAsPartOfPrompt
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, $allDayEvent = null, \patest\StructType\AllowedBookingRequestTypes $allowedBookingRequestTypes = null, $crossOrgUnitsAclSchemeId = null, $defaultSeatgeekAllocationTypeId = null, $deferredLedgerIdForRegular = null, $deferredLedgerIdForSubscribers = null, $displayStyleValue = null, $entityVersion = null, $inheritAllowedBookingRequestsOptions = null, $isActive = null, $isGroupTour = null, $isTour = null, $ledgerId = null, $maxEventsInTransaction = null, $minNumberOfTicketsPerEventForGroupTicket = null, \patest\StructType\GlobalString $name = null, $onlineTicketsLimit = null, $ordinal = null, $organizationUnitId = null, $projectIdentifierId = null, $promoterId = null, $promoterPriceListIdForRegularTickets = null, $promoterPriceListIdForSubsTickets = null, $replaceSubsTicketAllowed = null, $sellOnlyAsPartOfPrompt = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setAllDayEvent($allDayEvent)
            ->setAllowedBookingRequestTypes($allowedBookingRequestTypes)
            ->setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId)
            ->setDefaultSeatgeekAllocationTypeId($defaultSeatgeekAllocationTypeId)
            ->setDeferredLedgerIdForRegular($deferredLedgerIdForRegular)
            ->setDeferredLedgerIdForSubscribers($deferredLedgerIdForSubscribers)
            ->setDisplayStyleValue($displayStyleValue)
            ->setEntityVersion($entityVersion)
            ->setInheritAllowedBookingRequestsOptions($inheritAllowedBookingRequestsOptions)
            ->setIsActive($isActive)
            ->setIsGroupTour($isGroupTour)
            ->setIsTour($isTour)
            ->setLedgerId($ledgerId)
            ->setMaxEventsInTransaction($maxEventsInTransaction)
            ->setMinNumberOfTicketsPerEventForGroupTicket($minNumberOfTicketsPerEventForGroupTicket)
            ->setName($name)
            ->setOnlineTicketsLimit($onlineTicketsLimit)
            ->setOrdinal($ordinal)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setPromoterId($promoterId)
            ->setPromoterPriceListIdForRegularTickets($promoterPriceListIdForRegularTickets)
            ->setPromoterPriceListIdForSubsTickets($promoterPriceListIdForSubsTickets)
            ->setReplaceSubsTicketAllowed($replaceSubsTicketAllowed)
            ->setSellOnlyAsPartOfPrompt($sellOnlyAsPartOfPrompt)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get AllDayEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllDayEvent()
    {
        return isset($this->AllDayEvent) ? $this->AllDayEvent : null;
    }
    /**
     * Set AllDayEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allDayEvent
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setAllDayEvent($allDayEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($allDayEvent) && !is_bool($allDayEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allDayEvent, true), gettype($allDayEvent)), __LINE__);
        }
        if (is_null($allDayEvent) || (is_array($allDayEvent) && empty($allDayEvent))) {
            unset($this->AllDayEvent);
        } else {
            $this->AllDayEvent = $allDayEvent;
        }
        return $this;
    }
    /**
     * Get AllowedBookingRequestTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AllowedBookingRequestTypes|null
     */
    public function getAllowedBookingRequestTypes()
    {
        return isset($this->AllowedBookingRequestTypes) ? $this->AllowedBookingRequestTypes : null;
    }
    /**
     * Set AllowedBookingRequestTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AllowedBookingRequestTypes $allowedBookingRequestTypes
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setAllowedBookingRequestTypes(\patest\StructType\AllowedBookingRequestTypes $allowedBookingRequestTypes = null)
    {
        if (is_null($allowedBookingRequestTypes) || (is_array($allowedBookingRequestTypes) && empty($allowedBookingRequestTypes))) {
            unset($this->AllowedBookingRequestTypes);
        } else {
            $this->AllowedBookingRequestTypes = $allowedBookingRequestTypes;
        }
        return $this;
    }
    /**
     * Get CrossOrgUnitsAclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCrossOrgUnitsAclSchemeId()
    {
        return isset($this->CrossOrgUnitsAclSchemeId) ? $this->CrossOrgUnitsAclSchemeId : null;
    }
    /**
     * Set CrossOrgUnitsAclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $crossOrgUnitsAclSchemeId
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($crossOrgUnitsAclSchemeId) && !(is_int($crossOrgUnitsAclSchemeId) || ctype_digit($crossOrgUnitsAclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($crossOrgUnitsAclSchemeId, true), gettype($crossOrgUnitsAclSchemeId)), __LINE__);
        }
        if (is_null($crossOrgUnitsAclSchemeId) || (is_array($crossOrgUnitsAclSchemeId) && empty($crossOrgUnitsAclSchemeId))) {
            unset($this->CrossOrgUnitsAclSchemeId);
        } else {
            $this->CrossOrgUnitsAclSchemeId = $crossOrgUnitsAclSchemeId;
        }
        return $this;
    }
    /**
     * Get DefaultSeatgeekAllocationTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSeatgeekAllocationTypeId()
    {
        return isset($this->DefaultSeatgeekAllocationTypeId) ? $this->DefaultSeatgeekAllocationTypeId : null;
    }
    /**
     * Set DefaultSeatgeekAllocationTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSeatgeekAllocationTypeId
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setDefaultSeatgeekAllocationTypeId($defaultSeatgeekAllocationTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSeatgeekAllocationTypeId) && !is_string($defaultSeatgeekAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSeatgeekAllocationTypeId, true), gettype($defaultSeatgeekAllocationTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultSeatgeekAllocationTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultSeatgeekAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultSeatgeekAllocationTypeId, true)), __LINE__);
        }
        if (is_null($defaultSeatgeekAllocationTypeId) || (is_array($defaultSeatgeekAllocationTypeId) && empty($defaultSeatgeekAllocationTypeId))) {
            unset($this->DefaultSeatgeekAllocationTypeId);
        } else {
            $this->DefaultSeatgeekAllocationTypeId = $defaultSeatgeekAllocationTypeId;
        }
        return $this;
    }
    /**
     * Get DeferredLedgerIdForRegular value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeferredLedgerIdForRegular()
    {
        return isset($this->DeferredLedgerIdForRegular) ? $this->DeferredLedgerIdForRegular : null;
    }
    /**
     * Set DeferredLedgerIdForRegular value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deferredLedgerIdForRegular
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setDeferredLedgerIdForRegular($deferredLedgerIdForRegular = null)
    {
        // validation for constraint: string
        if (!is_null($deferredLedgerIdForRegular) && !is_string($deferredLedgerIdForRegular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deferredLedgerIdForRegular, true), gettype($deferredLedgerIdForRegular)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deferredLedgerIdForRegular) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deferredLedgerIdForRegular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deferredLedgerIdForRegular, true)), __LINE__);
        }
        if (is_null($deferredLedgerIdForRegular) || (is_array($deferredLedgerIdForRegular) && empty($deferredLedgerIdForRegular))) {
            unset($this->DeferredLedgerIdForRegular);
        } else {
            $this->DeferredLedgerIdForRegular = $deferredLedgerIdForRegular;
        }
        return $this;
    }
    /**
     * Get DeferredLedgerIdForSubscribers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeferredLedgerIdForSubscribers()
    {
        return isset($this->DeferredLedgerIdForSubscribers) ? $this->DeferredLedgerIdForSubscribers : null;
    }
    /**
     * Set DeferredLedgerIdForSubscribers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deferredLedgerIdForSubscribers
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setDeferredLedgerIdForSubscribers($deferredLedgerIdForSubscribers = null)
    {
        // validation for constraint: string
        if (!is_null($deferredLedgerIdForSubscribers) && !is_string($deferredLedgerIdForSubscribers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deferredLedgerIdForSubscribers, true), gettype($deferredLedgerIdForSubscribers)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deferredLedgerIdForSubscribers) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deferredLedgerIdForSubscribers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deferredLedgerIdForSubscribers, true)), __LINE__);
        }
        if (is_null($deferredLedgerIdForSubscribers) || (is_array($deferredLedgerIdForSubscribers) && empty($deferredLedgerIdForSubscribers))) {
            unset($this->DeferredLedgerIdForSubscribers);
        } else {
            $this->DeferredLedgerIdForSubscribers = $deferredLedgerIdForSubscribers;
        }
        return $this;
    }
    /**
     * Get DisplayStyleValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayStyleValue()
    {
        return isset($this->DisplayStyleValue) ? $this->DisplayStyleValue : null;
    }
    /**
     * Set DisplayStyleValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayStyleValue
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setDisplayStyleValue($displayStyleValue = null)
    {
        // validation for constraint: string
        if (!is_null($displayStyleValue) && !is_string($displayStyleValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayStyleValue, true), gettype($displayStyleValue)), __LINE__);
        }
        if (is_null($displayStyleValue) || (is_array($displayStyleValue) && empty($displayStyleValue))) {
            unset($this->DisplayStyleValue);
        } else {
            $this->DisplayStyleValue = $displayStyleValue;
        }
        return $this;
    }
    /**
     * Get EntityVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityVersion()
    {
        return isset($this->EntityVersion) ? $this->EntityVersion : null;
    }
    /**
     * Set EntityVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityVersion
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setEntityVersion($entityVersion = null)
    {
        // validation for constraint: string
        if (!is_null($entityVersion) && !is_string($entityVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityVersion, true), gettype($entityVersion)), __LINE__);
        }
        if (is_null($entityVersion) || (is_array($entityVersion) && empty($entityVersion))) {
            unset($this->EntityVersion);
        } else {
            $this->EntityVersion = $entityVersion;
        }
        return $this;
    }
    /**
     * Get InheritAllowedBookingRequestsOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInheritAllowedBookingRequestsOptions()
    {
        return isset($this->InheritAllowedBookingRequestsOptions) ? $this->InheritAllowedBookingRequestsOptions : null;
    }
    /**
     * Set InheritAllowedBookingRequestsOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inheritAllowedBookingRequestsOptions
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setInheritAllowedBookingRequestsOptions($inheritAllowedBookingRequestsOptions = null)
    {
        // validation for constraint: boolean
        if (!is_null($inheritAllowedBookingRequestsOptions) && !is_bool($inheritAllowedBookingRequestsOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inheritAllowedBookingRequestsOptions, true), gettype($inheritAllowedBookingRequestsOptions)), __LINE__);
        }
        if (is_null($inheritAllowedBookingRequestsOptions) || (is_array($inheritAllowedBookingRequestsOptions) && empty($inheritAllowedBookingRequestsOptions))) {
            unset($this->InheritAllowedBookingRequestsOptions);
        } else {
            $this->InheritAllowedBookingRequestsOptions = $inheritAllowedBookingRequestsOptions;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsGroupTour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGroupTour()
    {
        return isset($this->IsGroupTour) ? $this->IsGroupTour : null;
    }
    /**
     * Set IsGroupTour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGroupTour
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setIsGroupTour($isGroupTour = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGroupTour) && !is_bool($isGroupTour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGroupTour, true), gettype($isGroupTour)), __LINE__);
        }
        if (is_null($isGroupTour) || (is_array($isGroupTour) && empty($isGroupTour))) {
            unset($this->IsGroupTour);
        } else {
            $this->IsGroupTour = $isGroupTour;
        }
        return $this;
    }
    /**
     * Get IsTour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTour()
    {
        return isset($this->IsTour) ? $this->IsTour : null;
    }
    /**
     * Set IsTour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTour
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setIsTour($isTour = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTour) && !is_bool($isTour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTour, true), gettype($isTour)), __LINE__);
        }
        if (is_null($isTour) || (is_array($isTour) && empty($isTour))) {
            unset($this->IsTour);
        } else {
            $this->IsTour = $isTour;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get MaxEventsInTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxEventsInTransaction()
    {
        return isset($this->MaxEventsInTransaction) ? $this->MaxEventsInTransaction : null;
    }
    /**
     * Set MaxEventsInTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxEventsInTransaction
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setMaxEventsInTransaction($maxEventsInTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($maxEventsInTransaction) && !(is_int($maxEventsInTransaction) || ctype_digit($maxEventsInTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxEventsInTransaction, true), gettype($maxEventsInTransaction)), __LINE__);
        }
        if (is_null($maxEventsInTransaction) || (is_array($maxEventsInTransaction) && empty($maxEventsInTransaction))) {
            unset($this->MaxEventsInTransaction);
        } else {
            $this->MaxEventsInTransaction = $maxEventsInTransaction;
        }
        return $this;
    }
    /**
     * Get MinNumberOfTicketsPerEventForGroupTicket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinNumberOfTicketsPerEventForGroupTicket()
    {
        return isset($this->MinNumberOfTicketsPerEventForGroupTicket) ? $this->MinNumberOfTicketsPerEventForGroupTicket : null;
    }
    /**
     * Set MinNumberOfTicketsPerEventForGroupTicket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minNumberOfTicketsPerEventForGroupTicket
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setMinNumberOfTicketsPerEventForGroupTicket($minNumberOfTicketsPerEventForGroupTicket = null)
    {
        // validation for constraint: int
        if (!is_null($minNumberOfTicketsPerEventForGroupTicket) && !(is_int($minNumberOfTicketsPerEventForGroupTicket) || ctype_digit($minNumberOfTicketsPerEventForGroupTicket))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minNumberOfTicketsPerEventForGroupTicket, true), gettype($minNumberOfTicketsPerEventForGroupTicket)), __LINE__);
        }
        if (is_null($minNumberOfTicketsPerEventForGroupTicket) || (is_array($minNumberOfTicketsPerEventForGroupTicket) && empty($minNumberOfTicketsPerEventForGroupTicket))) {
            unset($this->MinNumberOfTicketsPerEventForGroupTicket);
        } else {
            $this->MinNumberOfTicketsPerEventForGroupTicket = $minNumberOfTicketsPerEventForGroupTicket;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OnlineTicketsLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOnlineTicketsLimit()
    {
        return isset($this->OnlineTicketsLimit) ? $this->OnlineTicketsLimit : null;
    }
    /**
     * Set OnlineTicketsLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $onlineTicketsLimit
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setOnlineTicketsLimit($onlineTicketsLimit = null)
    {
        // validation for constraint: int
        if (!is_null($onlineTicketsLimit) && !(is_int($onlineTicketsLimit) || ctype_digit($onlineTicketsLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onlineTicketsLimit, true), gettype($onlineTicketsLimit)), __LINE__);
        }
        if (is_null($onlineTicketsLimit) || (is_array($onlineTicketsLimit) && empty($onlineTicketsLimit))) {
            unset($this->OnlineTicketsLimit);
        } else {
            $this->OnlineTicketsLimit = $onlineTicketsLimit;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get PromoterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoterId()
    {
        return isset($this->PromoterId) ? $this->PromoterId : null;
    }
    /**
     * Set PromoterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoterId
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setPromoterId($promoterId = null)
    {
        // validation for constraint: string
        if (!is_null($promoterId) && !is_string($promoterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoterId, true), gettype($promoterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($promoterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $promoterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($promoterId, true)), __LINE__);
        }
        if (is_null($promoterId) || (is_array($promoterId) && empty($promoterId))) {
            unset($this->PromoterId);
        } else {
            $this->PromoterId = $promoterId;
        }
        return $this;
    }
    /**
     * Get PromoterPriceListIdForRegularTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoterPriceListIdForRegularTickets()
    {
        return isset($this->PromoterPriceListIdForRegularTickets) ? $this->PromoterPriceListIdForRegularTickets : null;
    }
    /**
     * Set PromoterPriceListIdForRegularTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoterPriceListIdForRegularTickets
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setPromoterPriceListIdForRegularTickets($promoterPriceListIdForRegularTickets = null)
    {
        // validation for constraint: string
        if (!is_null($promoterPriceListIdForRegularTickets) && !is_string($promoterPriceListIdForRegularTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoterPriceListIdForRegularTickets, true), gettype($promoterPriceListIdForRegularTickets)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($promoterPriceListIdForRegularTickets) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $promoterPriceListIdForRegularTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($promoterPriceListIdForRegularTickets, true)), __LINE__);
        }
        if (is_null($promoterPriceListIdForRegularTickets) || (is_array($promoterPriceListIdForRegularTickets) && empty($promoterPriceListIdForRegularTickets))) {
            unset($this->PromoterPriceListIdForRegularTickets);
        } else {
            $this->PromoterPriceListIdForRegularTickets = $promoterPriceListIdForRegularTickets;
        }
        return $this;
    }
    /**
     * Get PromoterPriceListIdForSubsTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoterPriceListIdForSubsTickets()
    {
        return isset($this->PromoterPriceListIdForSubsTickets) ? $this->PromoterPriceListIdForSubsTickets : null;
    }
    /**
     * Set PromoterPriceListIdForSubsTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoterPriceListIdForSubsTickets
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setPromoterPriceListIdForSubsTickets($promoterPriceListIdForSubsTickets = null)
    {
        // validation for constraint: string
        if (!is_null($promoterPriceListIdForSubsTickets) && !is_string($promoterPriceListIdForSubsTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoterPriceListIdForSubsTickets, true), gettype($promoterPriceListIdForSubsTickets)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($promoterPriceListIdForSubsTickets) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $promoterPriceListIdForSubsTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($promoterPriceListIdForSubsTickets, true)), __LINE__);
        }
        if (is_null($promoterPriceListIdForSubsTickets) || (is_array($promoterPriceListIdForSubsTickets) && empty($promoterPriceListIdForSubsTickets))) {
            unset($this->PromoterPriceListIdForSubsTickets);
        } else {
            $this->PromoterPriceListIdForSubsTickets = $promoterPriceListIdForSubsTickets;
        }
        return $this;
    }
    /**
     * Get ReplaceSubsTicketAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReplaceSubsTicketAllowed()
    {
        return isset($this->ReplaceSubsTicketAllowed) ? $this->ReplaceSubsTicketAllowed : null;
    }
    /**
     * Set ReplaceSubsTicketAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $replaceSubsTicketAllowed
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setReplaceSubsTicketAllowed($replaceSubsTicketAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($replaceSubsTicketAllowed) && !is_bool($replaceSubsTicketAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceSubsTicketAllowed, true), gettype($replaceSubsTicketAllowed)), __LINE__);
        }
        if (is_null($replaceSubsTicketAllowed) || (is_array($replaceSubsTicketAllowed) && empty($replaceSubsTicketAllowed))) {
            unset($this->ReplaceSubsTicketAllowed);
        } else {
            $this->ReplaceSubsTicketAllowed = $replaceSubsTicketAllowed;
        }
        return $this;
    }
    /**
     * Get SellOnlyAsPartOfPrompt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSellOnlyAsPartOfPrompt()
    {
        return isset($this->SellOnlyAsPartOfPrompt) ? $this->SellOnlyAsPartOfPrompt : null;
    }
    /**
     * Set SellOnlyAsPartOfPrompt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sellOnlyAsPartOfPrompt
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setSellOnlyAsPartOfPrompt($sellOnlyAsPartOfPrompt = null)
    {
        // validation for constraint: boolean
        if (!is_null($sellOnlyAsPartOfPrompt) && !is_bool($sellOnlyAsPartOfPrompt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sellOnlyAsPartOfPrompt, true), gettype($sellOnlyAsPartOfPrompt)), __LINE__);
        }
        if (is_null($sellOnlyAsPartOfPrompt) || (is_array($sellOnlyAsPartOfPrompt) && empty($sellOnlyAsPartOfPrompt))) {
            unset($this->SellOnlyAsPartOfPrompt);
        } else {
            $this->SellOnlyAsPartOfPrompt = $sellOnlyAsPartOfPrompt;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Ticketing_ShowType
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
